/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.task;

import aglobe.container.ElementaryConversationEntity;
import aglobe.container.EventReceiver;
import aglobe.container.task.ConversationUnit;
import aglobe.container.task.Task;
import java.util.TimerTask;

public abstract class TimeoutTask
extends Task {
    protected Object ttLock = new Object();
    private TimerTask tt;

    public TimeoutTask(ConversationUnit cu, int msec) {
        super(cu);
        this.rescheduleTimer(msec);
    }

    public TimeoutTask(ConversationUnit cu, int msec, EventReceiver timeoutThreadReceiver) {
        super(cu);
        this.rescheduleTimer(msec, timeoutThreadReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTask() {
        Object object = this.ttLock;
        synchronized (object) {
            if (this.tt != null) {
                this.tt.cancel();
            }
            super.cancelTask();
        }
    }

    protected abstract void timeout();

    protected void rescheduleTimer(long newTimeout) {
        ElementaryConversationEntity er = this.getConversationManager().conversationEntityOwner;
        this.rescheduleTimer(newTimeout, er);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rescheduleTimer(long newTimeout, final EventReceiver timeoutEventReceiver) {
        Object object = this.ttLock;
        synchronized (object) {
            if (this.tt != null) {
                this.tt.cancel();
            }
            if (0L != newTimeout) {
                this.tt = new TimerTask(){

                    public void run() {
                        timeoutEventReceiver.addEvent(new Timeout());
                    }
                };
                this.getConversationManager().getContainer().TIMER.schedule(this.tt, newTimeout);
            }
        }
    }

    private class Timeout
    implements Runnable {
        private Timeout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = TimeoutTask.this.ttLock;
            synchronized (object) {
                if (!TimeoutTask.this.isCancelled()) {
                    TimeoutTask.this.timeout();
                    TimeoutTask.this.tt = null;
                }
            }
        }
    }
}

