/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.task;

import aglobe.container.ElementaryConversationEntity;
import aglobe.container.task.ConversationManager;
import aglobe.container.task.ConversationUnit;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;

public abstract class Task
implements ConversationUnit {
    private ConversationManager cm = null;
    private boolean cancelledTask = false;

    public Task(ConversationUnit cu) {
        this.cm = cu.getConversationManager();
    }

    public synchronized void cancelTask() {
        if (!this.cancelledTask) {
            this.cancelledTask = true;
            this.cm.removeTask(this);
        }
    }

    public boolean isCancelled() {
        return this.cancelledTask;
    }

    protected void sendMessage(Message m) throws InvisibleContainerException {
        if (this.cancelledTask) {
            throw new RuntimeException("Task is cancelled.");
        }
        this.cm.sendMessage(m, this);
    }

    public void sendMessageAsReference(Message m) throws InvisibleContainerException {
        if (this.cancelledTask) {
            throw new RuntimeException("Task is cancelled.");
        }
        this.cm.sendMessageAsReference(m, this);
    }

    protected abstract void handleIncomingMessage(Message var1);

    protected final void sendNotUnderstood(Message m, String reason) {
        if (!m.getPerformative().equalsIgnoreCase("NOT-UNDERSTOOD")) {
            Message re = m.getReply();
            if (m.getContent() != null) {
                re.setContent(m.getContent());
            }
            re.setPerformative("NOT-UNDERSTOOD");
            if (reason != null) {
                re.setReason(reason);
            }
            try {
                this.sendMessage(re);
            }
            catch (InvisibleContainerException invisibleContainerException) {
                // empty catch block
            }
            re.release();
        }
    }

    public final ConversationManager getConversationManager() {
        return this.cm;
    }

    public final ElementaryConversationEntity getElementaryConversationEntity() {
        return this.cm.getElementaryConversationEntity();
    }

    public final Address getAddress() {
        return this.cm.getElementaryConversationEntity().getAddress();
    }
}

