/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.task;

import aglobe.container.AgentContainer;
import aglobe.container.ElementaryConversationEntity;
import aglobe.container.MessageReceiver;
import aglobe.container.task.Task;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ConversationManager
implements MessageReceiver {
    protected ElementaryConversationEntity conversationEntityOwner;
    private Map<String, Task> taskmap = new LinkedHashMap<String, Task>();
    Task idletask = null;
    private boolean isFinalized = false;

    public ConversationManager(ElementaryConversationEntity sender) {
        this.conversationEntityOwner = sender;
    }

    private ConversationManager() {
        throw new UnsupportedOperationException();
    }

    public AgentContainer getContainer() {
        return this.conversationEntityOwner.getContainer();
    }

    public ElementaryConversationEntity getElementaryConversationEntity() {
        return this.conversationEntityOwner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTask(String convID, Task t) {
        Map<String, Task> map = this.taskmap;
        synchronized (map) {
            this.taskmap.put(convID, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(Task t) {
        if (this.isFinalized) {
            return;
        }
        Map<String, Task> map = this.taskmap;
        synchronized (map) {
            Iterator<Map.Entry<String, Task>> i = this.taskmap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, Task> me = i.next();
                if (me.getValue() != t) continue;
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdleTask(Task t) {
        Map<String, Task> map = this.taskmap;
        synchronized (map) {
            this.idletask = t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Message m, Task t) throws InvisibleContainerException {
        this.conversationEntityOwner.getContainer().getMessageTransport().ensureMessageIDs(m);
        Map<String, Task> map = this.taskmap;
        synchronized (map) {
            if (t != this.idletask) {
                this.registerTask(m.getConversationID(), t);
            }
        }
        this.conversationEntityOwner.sendMessage(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessageAsReference(Message m, Task t) throws InvisibleContainerException {
        this.conversationEntityOwner.getContainer().getMessageTransport().ensureMessageIDs(m);
        Map<String, Task> map = this.taskmap;
        synchronized (map) {
            if (t != this.idletask) {
                this.registerTask(m.getConversationID(), t);
            }
        }
        this.conversationEntityOwner.sendMessageAsReference(m);
    }

    public final MessageReceiver getMessageReceiver(String receiver) {
        return this;
    }

    public void incomingMessage(Message m) {
        Task t = this.findTask(m.getConversationID());
        if (t != null) {
            t.handleIncomingMessage(m);
        } else {
            m.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task findTask(String convID) {
        Task t;
        Object object = this.taskmap;
        synchronized (object) {
            t = this.taskmap.get(convID);
        }
        if (t != null) {
            object = t;
            synchronized (object) {
                if (!t.isCancelled()) {
                    return t;
                }
            }
        }
        if (this.idletask != null) {
            object = this.idletask;
            synchronized (object) {
                if (!this.idletask.isCancelled()) {
                    return this.idletask;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sysFinish() {
        this.isFinalized = true;
        if (this.idletask != null) {
            this.idletask.cancelTask();
            this.idletask = null;
        }
        Map<String, Task> map = this.taskmap;
        synchronized (map) {
            for (Task elem : this.taskmap.values()) {
                elem.cancelTask();
            }
            this.taskmap.clear();
        }
    }
}

