/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.sysservice.directory;

import aglobe.container.sysservice.directory.DirectoryTransmitionRecord;
import aglobe.container.transport.Address;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DirectoryStructure4 {
    final Address remoteDirectoryAddress;
    private Collection<String> currentFilter;
    private String currentFilterInString;
    Pattern regexpCurrentFilter;
    Map<Address, DirectoryTransmitionRecord> invisibleQueueRecordUpdates = new LinkedHashMap<Address, DirectoryTransmitionRecord>();

    DirectoryStructure4(Address remoteDirectoryAddress, String filter) {
        this.remoteDirectoryAddress = remoteDirectoryAddress;
        this.currentFilterInString = filter;
        this.regexpCurrentFilter = Pattern.compile(this.currentFilterInString);
        this.currentFilter = DirectoryStructure4.convertFilter(filter);
    }

    String getCurrentFilterInString() {
        return this.currentFilterInString;
    }

    Collection<String> getCurrentFilter() {
        return this.currentFilter;
    }

    void setCurrentFilterInString(String newFilter) {
        this.currentFilterInString = newFilter;
        this.regexpCurrentFilter = Pattern.compile(newFilter);
    }

    void setCurrentFilter(Collection<String> newFilter) {
        this.currentFilter = newFilter;
    }

    static Collection<String> convertFilter(String filter) {
        LinkedHashSet<String> retVal = new LinkedHashSet<String>();
        String[] tmp = filter.split("\\|");
        int i = 0;
        while (i < tmp.length) {
            retVal.add(tmp[i].substring(1, tmp[i].length() - 1));
            ++i;
        }
        return retVal;
    }
}

