/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.sysservice.directory;

import aglobe.container.sysservice.directory.DirectoryException;
import aglobe.container.sysservice.directory.DirectoryRecord;
import aglobe.container.transport.Address;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DirectoryStructure1 {
    String services = ";";
    DirectoryRecord directoryRecord;
    private int hashValue;

    DirectoryStructure1(Address address) {
        this.directoryRecord = new DirectoryRecord(address, new String[0]);
        this.updateHashValue();
    }

    private void testServices(Collection<String> services) throws DirectoryException {
        for (String item : services) {
            if (item.indexOf(";") >= 0) {
                throw new DirectoryException("Service string cannot contain this character ';' !!!");
            }
            if (item.indexOf("|") < 0) continue;
            throw new DirectoryException("Service string cannot contain this character '|' !!!");
        }
    }

    String addServices(Collection<String> services) throws DirectoryException {
        this.testServices(services);
        String retVal = ";";
        for (String item : services) {
            this.services = String.valueOf(this.services) + item + ";";
            retVal = String.valueOf(retVal) + item + ";";
        }
        LinkedHashSet<String> tmp = new LinkedHashSet<String>((Collection)Arrays.asList(this.directoryRecord.getServices()));
        tmp.addAll(services);
        this.directoryRecord.setServices(tmp.toArray(new String[tmp.size()]));
        this.updateHashValue();
        return retVal;
    }

    String removeServices(Collection<String> services) throws DirectoryException {
        this.testServices(services);
        String retVal = ";";
        LinkedHashSet tmp = new LinkedHashSet(Arrays.asList(this.directoryRecord.getServices()));
        tmp.removeAll(services);
        String[] restServices = tmp.toArray(new String[tmp.size()]);
        this.directoryRecord.setServices(restServices);
        this.services = ";";
        int i = 0;
        while (i < restServices.length) {
            this.services = String.valueOf(this.services) + restServices[i] + ";";
            ++i;
        }
        for (String item : services) {
            retVal = String.valueOf(retVal) + item + ";";
        }
        this.updateHashValue();
        return retVal;
    }

    void changeServices(String newServices) {
        Collection<String> newServ = this.convertServices(newServices);
        this.services = newServices;
        this.directoryRecord.setServices(newServ.toArray(new String[newServ.size()]));
        this.updateHashValue();
    }

    void removeAllServices() {
        this.services = "";
        this.directoryRecord.setServices(new String[0]);
        this.updateHashValue();
    }

    private Collection<String> convertServices(String services) {
        LinkedHashSet<String> retVal = new LinkedHashSet<String>();
        String[] tmp = services.split(";");
        int i = 0;
        while (i < tmp.length) {
            if (tmp[i].length() > 0) {
                retVal.add(tmp[i]);
            }
            ++i;
        }
        return retVal;
    }

    boolean hasServices() {
        return this.directoryRecord.getServices().length > 0;
    }

    private void updateHashValue() {
        int retVal = 19;
        retVal = 37 * retVal + this.services.hashCode();
        this.hashValue = retVal = 37 * retVal + this.directoryRecord.hashCode();
    }

    public int hashCode() {
        return this.hashValue;
    }

    public boolean equals(Object other) {
        if (other instanceof DirectoryStructure1) {
            if (this.hashValue != other.hashCode()) {
                return false;
            }
            DirectoryStructure1 o = (DirectoryStructure1)other;
            return this.services.equals(o.services) && this.directoryRecord.equals(o.directoryRecord);
        }
        return false;
    }
}

