/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.sysservice.directory;

import aglobe.container.AgentContainer;
import aglobe.container.ElementaryEntity;
import aglobe.container.service.Service;
import aglobe.container.service.ServiceShell;
import aglobe.container.sysservice.directory.DirectoryException;
import aglobe.container.sysservice.directory.DirectoryListener;
import aglobe.container.sysservice.directory.DirectoryRecord;
import aglobe.container.sysservice.directory.DirectoryStructure1;
import aglobe.container.sysservice.directory.DirectoryStructure2;
import aglobe.container.sysservice.directory.DirectoryStructure3;
import aglobe.container.sysservice.directory.DirectoryStructure4;
import aglobe.container.sysservice.directory.DirectoryTransmitionRecord;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;
import aglobe.ontology.VisibilityUpdate;
import aglobe.service.gis.client.GISClientService;
import aglobe.service.gis.client.GISTopicListener;
import aglobe.service.link.LinkNeighbourListener;
import aglobe.service.link.LinkService;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryService
extends Service
implements GISTopicListener {
    public static final String SERVICENAME = "container/directory";
    private GISClientService.Shell gisShell = null;
    private LinkService.Shell linkShell = null;
    private Collection<String> currentUnitedFilter = new HashSet<String>();
    private String currentUnitedFilterInString = "";
    private Map<Address, DirectoryStructure1> localDirectory = new LinkedHashMap<Address, DirectoryStructure1>();
    private List<DirectoryStructure2> localSubscribers = new LinkedList<DirectoryStructure2>();
    private Map<String, DirectoryStructure3> myRemoteSubscriptions = new LinkedHashMap<String, DirectoryStructure3>();
    private Collection<String> currentVisibleContainers = new LinkedHashSet<String>();
    private Map<String, Address> containerNameToAddress = new HashMap<String, Address>();
    private Map<String, DirectoryStructure4> remoteSubscribers = new LinkedHashMap<String, DirectoryStructure4>();

    @Override
    public void startService() {
        this.logFine("DirectoryService started");
    }

    public void afterMTvisibilitySubscription() {
        this.gisShell = (GISClientService.Shell)this.getContainer().getServiceManager().getService(null, "gis/client");
        if (this.gisShell != null) {
            this.gisShell.subscribeTopic("VISIBILITY_UPDATES", this);
        } else {
            this.linkShell = (LinkService.Shell)this.getContainer().getServiceManager().getService(null, "container/link");
            if (this.linkShell != null) {
                this.linkShell.subscribeNeighbour(new LinkNeighbourListener(){

                    public void handleRegister(Address containerAddress) {
                        String containerName = containerAddress.getContainerName();
                        if (!DirectoryService.this.currentVisibleContainers.contains(containerName)) {
                            DirectoryService.this.containerNameToAddress.put(containerName, containerAddress);
                            DirectoryService.this.handleVisible(containerName);
                            DirectoryService.this.currentVisibleContainers.add(containerName);
                        }
                    }

                    public void handleDeregister(Address containerAddress) {
                        String containerName = containerAddress.getContainerName();
                        if (DirectoryService.this.currentVisibleContainers.contains(containerName)) {
                            DirectoryService.this.handleInvisible(containerName);
                            DirectoryService.this.currentVisibleContainers.remove(containerName);
                            DirectoryService.this.myRemoteSubscriptions.remove(containerName);
                        }
                    }

                    public void addEvent(Runnable e) {
                        DirectoryService.this.addEvent(e);
                    }
                });
            }
        }
    }

    @Override
    public ServiceShell getServiceShell(ElementaryEntity shellOwner) {
        return new Shell(shellOwner, this);
    }

    @Override
    public synchronized void stopService() {
        if (this.gisShell != null) {
            this.gisShell.dispose();
        }
        if (this.linkShell != null) {
            this.linkShell.dispose();
        }
        this.currentUnitedFilterInString = "";
        for (Map.Entry<String, DirectoryStructure3> item : this.myRemoteSubscriptions.entrySet()) {
            DirectoryStructure3 remoteSubscriptionRecord = item.getValue();
            try {
                this.sendSubscribeChangeFilter(remoteSubscriptionRecord.remoteDirectoryAddress, this.currentUnitedFilterInString);
            }
            catch (InvisibleContainerException invisibleContainerException) {
                // empty catch block
            }
        }
        Message m = null;
        for (DirectoryStructure4 elem : this.remoteSubscribers.values()) {
            if (m != null) {
                m.addReceiver(elem.remoteDirectoryAddress);
                continue;
            }
            m = Message.newInstance("INFORM", this.getAddress(), elem.remoteDirectoryAddress);
            m.setProtocol("subscription_released");
        }
        if (m != null) {
            try {
                this.sendMessageAsReference(m);
            }
            catch (InvisibleContainerException invisibleContainerException) {
                // empty catch block
            }
            m.release();
        }
    }

    private void handleLocalSubscribersUpdate(DirectoryStructure1 directoryRecord) {
        for (DirectoryStructure2 item : this.localSubscribers) {
            final String filter = item.filter;
            final DirectoryListener listener = item.listener;
            final DirectoryRecord record = directoryRecord.directoryRecord;
            if (item.regexFilter.matcher(directoryRecord.services).find()) {
                if (!item.knownProvides.containsKey(record.address)) {
                    listener.addEvent(new Runnable(){

                        public void run() {
                            listener.handleNewRegister(record.containerName, new DirectoryRecord[]{record}, filter);
                            listener.handleVisible(record.containerName, new DirectoryRecord[]{record}, filter);
                        }
                    });
                }
                item.knownProvides.put(record.address, directoryRecord);
                item.visibleProviders.put(record.address, directoryRecord);
                continue;
            }
            if (item.visibleProviders.containsKey(record.address)) {
                listener.addEvent(new Runnable(){

                    public void run() {
                        listener.handleInvisible(record.containerName, new DirectoryRecord[]{record}, filter);
                        listener.handleDeregister(record.containerName, new DirectoryRecord[]{record}, filter);
                    }
                });
                item.visibleProviders.remove(record.address);
                item.knownProvides.remove(record.address);
                continue;
            }
            if (!item.knownProvides.containsKey(record.address)) continue;
            listener.addEvent(new Runnable(){

                public void run() {
                    listener.handleDeregister(record.containerName, new DirectoryRecord[]{record}, filter);
                }
            });
            item.knownProvides.remove(record.address);
        }
    }

    @Override
    protected synchronized void handleIncomingMessage(Message m) {
        if ("INFORM".equals(m.getPerformative()) && m.getProtocol() != null) {
            String remoteContainerName = m.getSender().getContainerName();
            String protocol = m.getProtocol();
            if ("handle_directory_record_update".equals(protocol)) {
                DirectoryTransmitionRecord updatedRecord = (DirectoryTransmitionRecord)m.getContent();
                Address serviceProvider = updatedRecord.getAddress();
                DirectoryStructure3 remoteSubscriptionRecord = this.myRemoteSubscriptions.get(remoteContainerName);
                if (remoteSubscriptionRecord != null) {
                    DirectoryStructure1 providerRecord = remoteSubscriptionRecord.remoteDirectory.get(serviceProvider);
                    if (providerRecord == null) {
                        providerRecord = new DirectoryStructure1(serviceProvider);
                        remoteSubscriptionRecord.remoteDirectory.put(serviceProvider, providerRecord);
                    }
                    providerRecord.changeServices(updatedRecord._Services);
                    this.handleLocalSubscribersUpdate(providerRecord);
                    if (!providerRecord.hasServices()) {
                        remoteSubscriptionRecord.remoteDirectory.remove(serviceProvider);
                    }
                }
                if (!this.currentVisibleContainers.contains(remoteContainerName) && !this.containerNameToAddress.containsKey(remoteContainerName)) {
                    this.containerNameToAddress.put(remoteContainerName, m.getSender().deriveContainerAddress());
                }
                m.release();
                return;
            }
            if ("subscribe/change".equals(protocol)) {
                DirectoryStructure4 remoteSubscriberRecord;
                String findFilter = "";
                if (this.remoteSubscribers.containsKey(remoteContainerName)) {
                    remoteSubscriberRecord = this.remoteSubscribers.get(remoteContainerName);
                    Collection<String> newFilter = DirectoryStructure4.convertFilter((String)m.getContent());
                    LinkedHashSet<String> addedFilters = new LinkedHashSet<String>(newFilter);
                    addedFilters.removeAll(remoteSubscriberRecord.getCurrentFilter());
                    if (addedFilters.size() > 0) {
                        for (String item : addedFilters) {
                            findFilter = String.valueOf(findFilter) + "|;" + item + ";";
                        }
                        if (findFilter.length() > 1) {
                            findFilter = findFilter.substring(1);
                        }
                    }
                    remoteSubscriberRecord.setCurrentFilter(newFilter);
                    remoteSubscriberRecord.setCurrentFilterInString((String)m.getContent());
                } else {
                    remoteSubscriberRecord = new DirectoryStructure4(m.getSender(), (String)m.getContent());
                    this.remoteSubscribers.put(remoteContainerName, remoteSubscriberRecord);
                    findFilter = remoteSubscriberRecord.getCurrentFilterInString();
                }
                if (findFilter.length() > 0) {
                    Pattern regexpFilter = Pattern.compile(findFilter);
                    for (DirectoryStructure1 item : this.localDirectory.values()) {
                        if (!regexpFilter.matcher(item.services).find()) continue;
                        this.sendDirectoryRecordUpdate(item, remoteSubscriberRecord);
                    }
                }
                if (!this.currentVisibleContainers.contains(remoteContainerName) && !this.containerNameToAddress.containsKey(remoteContainerName)) {
                    this.containerNameToAddress.put(remoteContainerName, m.getSender().deriveContainerAddress());
                }
                m.release();
                return;
            }
            if ("unsubscribe".equals(protocol)) {
                this.remoteSubscribers.remove(remoteContainerName);
                m.release();
                return;
            }
            if ("subscription_released".equals(protocol)) {
                this.remoteSubscribers.remove(remoteContainerName);
                DirectoryStructure3 remoteSubscriptionRecord = this.myRemoteSubscriptions.get(remoteContainerName);
                if (remoteSubscriptionRecord != null) {
                    for (DirectoryStructure1 elem : remoteSubscriptionRecord.remoteDirectory.values()) {
                        elem.removeAllServices();
                        this.handleLocalSubscribersUpdate(elem);
                    }
                    remoteSubscriptionRecord.remoteDirectory.clear();
                }
                this.myRemoteSubscriptions.remove(remoteContainerName);
                this.containerNameToAddress.remove(remoteContainerName);
                m.release();
                return;
            }
        }
        this.logWarning("Unexpected incoming message: " + m);
        m.release();
    }

    private void sendDirectoryRecordUpdate(DirectoryStructure1 updatedRecord, DirectoryStructure4 remoteSubscriber) {
        String remoteContainerName = remoteSubscriber.remoteDirectoryAddress.getContainerName();
        DirectoryTransmitionRecord transmitionRecord = new DirectoryTransmitionRecord(updatedRecord.directoryRecord.address, updatedRecord.services);
        if (this.currentVisibleContainers.contains(remoteContainerName)) {
            try {
                this.sendDirectoryRecordUpdate(remoteSubscriber.remoteDirectoryAddress, transmitionRecord);
            }
            catch (InvisibleContainerException ex) {
                this.currentVisibleContainers.remove(remoteContainerName);
                remoteSubscriber.invisibleQueueRecordUpdates.put(transmitionRecord.getAddress(), transmitionRecord);
                this.handleInvisible(remoteContainerName);
            }
        } else {
            remoteSubscriber.invisibleQueueRecordUpdates.put(transmitionRecord.getAddress(), transmitionRecord);
        }
    }

    private synchronized void register(Address providerAddress, Collection<String> services) throws DirectoryException {
        DirectoryStructure1 localDirectoryRecord = this.localDirectory.get(providerAddress);
        if (localDirectoryRecord == null) {
            localDirectoryRecord = new DirectoryStructure1(providerAddress);
            this.localDirectory.put(providerAddress, localDirectoryRecord);
        }
        String addedServices = localDirectoryRecord.addServices(services);
        final DirectoryRecord record = localDirectoryRecord.directoryRecord;
        for (DirectoryStructure2 directoryStructure2 : this.localSubscribers) {
            if (directoryStructure2.knownProvides.containsKey(providerAddress) || !directoryStructure2.regexFilter.matcher(addedServices).find()) continue;
            final DirectoryListener listener = directoryStructure2.listener;
            final String filter = directoryStructure2.filter;
            listener.addEvent(new Runnable(){

                public void run() {
                    listener.handleNewRegister(record.containerName, new DirectoryRecord[]{record}, filter);
                    listener.handleVisible(record.containerName, new DirectoryRecord[]{record}, filter);
                }
            });
            directoryStructure2.knownProvides.put(record.address, localDirectoryRecord);
            directoryStructure2.visibleProviders.put(record.address, localDirectoryRecord);
        }
        for (DirectoryStructure4 directoryStructure4 : this.remoteSubscribers.values()) {
            if (!directoryStructure4.regexpCurrentFilter.matcher(addedServices).find()) continue;
            this.sendDirectoryRecordUpdate(localDirectoryRecord, directoryStructure4);
        }
    }

    private synchronized void deregister(Address providerAddress, Collection<String> services) throws DirectoryException {
        DirectoryStructure1 localDirectoryRecord = this.localDirectory.get(providerAddress);
        if (localDirectoryRecord != null) {
            String removedServices = localDirectoryRecord.removeServices(services);
            if (!localDirectoryRecord.hasServices()) {
                this.localDirectory.remove(providerAddress);
            }
            this.handleLocalSubscribersUpdate(localDirectoryRecord);
            for (DirectoryStructure4 item : this.remoteSubscribers.values()) {
                if (!item.regexpCurrentFilter.matcher(removedServices).find()) continue;
                this.sendDirectoryRecordUpdate(localDirectoryRecord, item);
            }
        }
    }

    private synchronized void subscribeLocal(final DirectoryListener listener, final String filter) {
        DirectoryStructure2 localSubscriberRecord = new DirectoryStructure2(listener, filter);
        this.localSubscribers.add(localSubscriberRecord);
        if (!this.currentUnitedFilter.contains(filter)) {
            boolean updated = false;
            StringBuilder newPartOfUnitedFilter = new StringBuilder(";").append(filter).append(";");
            this.currentUnitedFilter.add(filter);
            if (this.currentUnitedFilterInString.length() > 0) {
                Pattern pattern = Pattern.compile(this.currentUnitedFilterInString);
                if (!pattern.matcher(newPartOfUnitedFilter).find()) {
                    this.currentUnitedFilterInString = this.currentUnitedFilterInString + "|" + newPartOfUnitedFilter;
                    updated = true;
                }
            } else {
                this.currentUnitedFilterInString = newPartOfUnitedFilter.toString();
                updated = true;
            }
            if (updated) {
                this.updateMyRemoteSubscriptions();
            }
        }
        final LinkedHashSet<DirectoryRecord> result = new LinkedHashSet<DirectoryRecord>();
        for (DirectoryStructure1 directoryStructure1 : this.localDirectory.values()) {
            if (!localSubscriberRecord.regexFilter.matcher(directoryStructure1.services).find()) continue;
            result.add(directoryStructure1.directoryRecord);
            localSubscriberRecord.knownProvides.put(directoryStructure1.directoryRecord.address, directoryStructure1);
            localSubscriberRecord.visibleProviders.put(directoryStructure1.directoryRecord.address, directoryStructure1);
        }
        if (result.size() > 0) {
            final String containerName = this.getContainer().getContainerName();
            listener.addEvent(new Runnable(){

                public void run() {
                    listener.handleNewRegister(containerName, result.toArray(new DirectoryRecord[result.size()]), filter);
                    listener.handleVisible(containerName, result.toArray(new DirectoryRecord[result.size()]), filter);
                }
            });
        }
        for (Map.Entry entry : this.myRemoteSubscriptions.entrySet()) {
            DirectoryStructure3 remoteSubscriptionRecord = (DirectoryStructure3)entry.getValue();
            final String remoteContainerName = (String)entry.getKey();
            final boolean visible = this.currentVisibleContainers.contains(remoteContainerName);
            final LinkedHashSet<DirectoryRecord> res = new LinkedHashSet<DirectoryRecord>();
            for (DirectoryStructure1 item2 : remoteSubscriptionRecord.remoteDirectory.values()) {
                if (!localSubscriberRecord.regexFilter.matcher(item2.services).find()) continue;
                res.add(item2.directoryRecord);
                localSubscriberRecord.knownProvides.put(item2.directoryRecord.address, item2);
                if (!visible) continue;
                localSubscriberRecord.visibleProviders.put(item2.directoryRecord.address, item2);
            }
            if (res.size() <= 0) continue;
            listener.addEvent(new Runnable(){

                public void run() {
                    listener.handleNewRegister(remoteContainerName, res.toArray(new DirectoryRecord[res.size()]), filter);
                    if (visible) {
                        listener.handleVisible(remoteContainerName, res.toArray(new DirectoryRecord[res.size()]), filter);
                    }
                }
            });
        }
    }

    private synchronized void unsubscribeLocal(DirectoryListener listener, String filter) {
        Iterator<DirectoryStructure2> iter = this.localSubscribers.iterator();
        while (iter.hasNext()) {
            DirectoryStructure2 item = iter.next();
            if (item.listener != listener || !item.filter.equals(filter)) continue;
            iter.remove();
            HashSet<String> newUnitedFilter = new HashSet<String>();
            StringBuilder newUnitedFilterBuilder = new StringBuilder();
            boolean firstValue = true;
            for (DirectoryStructure2 item2 : this.localSubscribers) {
                if (newUnitedFilter.contains(item2.filter)) continue;
                newUnitedFilter.add(item2.filter);
                StringBuilder filterToAdd = new StringBuilder(";").append(item2.filter).append(";");
                if (firstValue) {
                    firstValue = false;
                    newUnitedFilterBuilder.append((CharSequence)filterToAdd);
                    continue;
                }
                Pattern testObject = Pattern.compile(newUnitedFilterBuilder.toString());
                if (testObject.matcher(filterToAdd).find()) continue;
                newUnitedFilterBuilder.append("|").append((CharSequence)filterToAdd);
            }
            String newUnitedFilterInString = newUnitedFilterBuilder.toString();
            if (!this.currentUnitedFilterInString.equals(newUnitedFilterInString)) {
                this.updateMyRemoteSubscriptions();
            }
            this.currentUnitedFilter = newUnitedFilter;
            this.currentUnitedFilterInString = newUnitedFilterInString;
            break;
        }
    }

    private void updateMyRemoteSubscriptions() {
        for (String item : this.myRemoteSubscriptions.keySet()) {
            DirectoryStructure3 remoteSubscriptionsRecord = this.myRemoteSubscriptions.get(item);
            if (this.currentVisibleContainers.contains(item)) {
                try {
                    this.sendSubscribeChangeFilter(remoteSubscriptionsRecord.remoteDirectoryAddress, this.currentUnitedFilterInString);
                }
                catch (InvisibleContainerException ex) {
                    remoteSubscriptionsRecord.invisibleMyFilterUpdate = this.currentUnitedFilterInString;
                    this.currentVisibleContainers.remove(item);
                    this.handleInvisible(item);
                }
                continue;
            }
            remoteSubscriptionsRecord.invisibleMyFilterUpdate = this.currentUnitedFilterInString;
        }
    }

    private void sendSubscribeChangeFilter(Address remoteDirectory, String newFilter) throws InvisibleContainerException {
        Message m = Message.newInstance("INFORM", this.getAddress(), remoteDirectory);
        if (newFilter != null && newFilter.length() > 0) {
            m.setProtocol("subscribe/change");
            m.setContent(newFilter);
        } else {
            m.setProtocol("unsubscribe");
        }
        this.sendMessageAsReference(m);
        m.release();
    }

    private void sendDirectoryRecordUpdate(Address remoteDirectory, DirectoryTransmitionRecord record) throws InvisibleContainerException {
        Message m = Message.newInstance("INFORM", this.getAddress(), remoteDirectory);
        m.setProtocol("handle_directory_record_update");
        m.setContent(record);
        this.sendMessageAsReference(m);
        m.release();
    }

    private void handleVisible(final String remoteContainerName) {
        DirectoryStructure4 remoteSubscriber;
        DirectoryStructure3 remoteSubscriberRecord;
        if (!this.myRemoteSubscriptions.containsKey(remoteContainerName)) {
            remoteSubscriberRecord = new DirectoryStructure3(this.containerNameToAddress.get(remoteContainerName));
            this.myRemoteSubscriptions.put(remoteContainerName, remoteSubscriberRecord);
            if (this.currentUnitedFilter.size() > 0) {
                try {
                    this.sendSubscribeChangeFilter(remoteSubscriberRecord.remoteDirectoryAddress, this.currentUnitedFilterInString);
                }
                catch (InvisibleContainerException ex) {
                    remoteSubscriberRecord.invisibleMyFilterUpdate = this.currentUnitedFilterInString;
                    this.currentVisibleContainers.remove(remoteContainerName);
                    return;
                }
            }
        } else {
            remoteSubscriberRecord = this.myRemoteSubscriptions.get(remoteContainerName);
            if (remoteSubscriberRecord.invisibleMyFilterUpdate != null) {
                try {
                    this.sendSubscribeChangeFilter(remoteSubscriberRecord.remoteDirectoryAddress, remoteSubscriberRecord.invisibleMyFilterUpdate);
                    remoteSubscriberRecord.invisibleMyFilterUpdate = null;
                }
                catch (InvisibleContainerException ex1) {
                    this.currentVisibleContainers.remove(remoteContainerName);
                    return;
                }
            }
            for (DirectoryStructure2 directoryStructure2 : this.localSubscribers) {
                LinkedHashSet<DirectoryStructure1> getVisible = new LinkedHashSet<DirectoryStructure1>(remoteSubscriberRecord.remoteDirectory.values());
                getVisible.retainAll(directoryStructure2.knownProvides.values());
                getVisible.removeAll(directoryStructure2.visibleProviders.values());
                if (getVisible.size() <= 0) continue;
                final DirectoryRecord[] visible = new DirectoryRecord[getVisible.size()];
                int i = 0;
                for (DirectoryStructure1 item2 : getVisible) {
                    visible[i++] = item2.directoryRecord;
                }
                final String filter = directoryStructure2.filter;
                final DirectoryListener listener = directoryStructure2.listener;
                listener.addEvent(new Runnable(){

                    public void run() {
                        listener.handleVisible(remoteContainerName, visible, filter);
                    }
                });
                for (DirectoryStructure1 item2 : getVisible) {
                    directoryStructure2.visibleProviders.put(item2.directoryRecord.address, item2);
                }
            }
        }
        if ((remoteSubscriber = this.remoteSubscribers.get(remoteContainerName)) != null && remoteSubscriber.invisibleQueueRecordUpdates.size() > 0) {
            for (DirectoryTransmitionRecord directoryTransmitionRecord : remoteSubscriber.invisibleQueueRecordUpdates.values()) {
                try {
                    this.sendDirectoryRecordUpdate(remoteSubscriber.remoteDirectoryAddress, directoryTransmitionRecord);
                }
                catch (InvisibleContainerException ex2) {
                    this.currentVisibleContainers.remove(remoteContainerName);
                    this.handleInvisible(remoteContainerName);
                    return;
                }
            }
        }
    }

    private void handleInvisible(final String remoteContainerName) {
        DirectoryStructure3 remoteSubscriptionRecord = this.myRemoteSubscriptions.get(remoteContainerName);
        if (remoteSubscriptionRecord != null) {
            for (DirectoryStructure2 item : this.localSubscribers) {
                LinkedHashSet<DirectoryStructure1> lastVisible = new LinkedHashSet<DirectoryStructure1>(remoteSubscriptionRecord.remoteDirectory.values());
                lastVisible.retainAll(item.visibleProviders.values());
                if (lastVisible.size() <= 0) continue;
                final DirectoryRecord[] invisible = new DirectoryRecord[lastVisible.size()];
                int i = 0;
                for (DirectoryStructure1 item2 : lastVisible) {
                    invisible[i++] = item2.directoryRecord;
                }
                final String filter = item.filter;
                final DirectoryListener listener = item.listener;
                listener.addEvent(new Runnable(){

                    public void run() {
                        listener.handleInvisible(remoteContainerName, invisible, filter);
                    }
                });
                for (DirectoryStructure1 item2 : lastVisible) {
                    item.visibleProviders.remove(item2.directoryRecord.address);
                }
            }
        }
    }

    @Override
    public synchronized void handleTopic(String topic, Object content, String reason) {
        VisibilityUpdate gi = (VisibilityUpdate)content;
        LinkedHashSet<String> newVisibleContainers = new LinkedHashSet<String>();
        for (Address address : gi.getVisibleContainerAddress()) {
            String containerName = address.getContainerName();
            newVisibleContainers.add(containerName);
            if (this.currentVisibleContainers.contains(containerName)) continue;
            if (!this.containerNameToAddress.containsKey(containerName)) {
                Address remoteContainerAddress = address;
                this.containerNameToAddress.put(containerName, remoteContainerAddress);
            } else if (!this.containerNameToAddress.get(containerName).equals(address)) {
                this.containerNameToAddress.put(containerName, address);
                this.myRemoteSubscriptions.remove(containerName);
            }
            this.handleVisible(containerName);
        }
        this.currentVisibleContainers.removeAll(newVisibleContainers);
        for (String string : this.currentVisibleContainers) {
            this.handleInvisible(string);
        }
        this.currentVisibleContainers = newVisibleContainers;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Shell
    extends ServiceShell {
        transient DirectoryService theservice = null;
        private Collection<String> registredServices = new LinkedHashSet<String>();
        private ElementaryEntity serviceProvider = null;
        private List<String> subscribedFilters = new LinkedList<String>();
        private List<DirectoryListener> subscribedListeners = new LinkedList<DirectoryListener>();
        private transient boolean postInit = false;
        private transient Collection<String> memRegistredServices;
        private transient List<String> memSubscribedFilters;
        private transient List<DirectoryListener> memSubscribedListeners;

        public Shell() {
        }

        private Shell(ElementaryEntity shellOwner, DirectoryService _theservice) {
            super(shellOwner);
            this.theservice = _theservice;
        }

        public void register(ElementaryEntity serviceProvider, Collection<String> services) throws DirectoryException {
            if (this.serviceProvider != null && this.serviceProvider != serviceProvider) {
                throw new DirectoryException("You try to register another service provider than before !!!");
            }
            this.serviceProvider = serviceProvider;
            LinkedHashSet<String> addServices = new LinkedHashSet<String>(services);
            addServices.removeAll(this.registredServices);
            if (addServices.size() > 0) {
                this.registredServices.addAll(addServices);
                this.theservice.register(serviceProvider.getAddress(), addServices);
            }
        }

        public void register(ElementaryEntity serviceProvider, String[] services) throws DirectoryException {
            if (this.serviceProvider != null && this.serviceProvider != serviceProvider) {
                throw new DirectoryException("You try to register another service provider than before !!!");
            }
            this.serviceProvider = serviceProvider;
            LinkedHashSet<String> addServices = new LinkedHashSet<String>(services.length);
            String[] stringArray = services;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String elem = stringArray[n];
                if (!this.registredServices.contains(elem)) {
                    addServices.add(elem);
                }
                ++n;
            }
            if (addServices.size() > 0) {
                this.registredServices.addAll(addServices);
                this.theservice.register(serviceProvider.getAddress(), addServices);
            }
        }

        public void deregister(Collection<String> services) throws DirectoryException {
            LinkedHashSet<String> removeServices = new LinkedHashSet<String>(services);
            removeServices.retainAll(this.registredServices);
            if (removeServices.size() > 0) {
                this.registredServices.removeAll(removeServices);
                this.theservice.deregister(this.serviceProvider.getAddress(), removeServices);
            }
        }

        public void deregister(String[] services) throws DirectoryException {
            LinkedHashSet<String> removeServices = new LinkedHashSet<String>(services.length);
            String[] stringArray = services;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String elem = stringArray[n];
                if (this.registredServices.contains(elem)) {
                    removeServices.add(elem);
                }
                ++n;
            }
            if (removeServices.size() > 0) {
                this.registredServices.removeAll(removeServices);
                this.theservice.deregister(this.serviceProvider.getAddress(), removeServices);
            }
        }

        private void deregisterAll() {
            try {
                this.theservice.deregister(this.serviceProvider.getAddress(), this.registredServices);
            }
            catch (DirectoryException ex) {
                Logger.getLogger(DirectoryService.SERVICENAME).warning("Problem with deregister service: " + ex);
            }
            this.registredServices.clear();
        }

        public void subscribe(DirectoryListener listener, String filter) {
            this.theservice.subscribeLocal(listener, filter);
            this.subscribedFilters.add(filter);
            this.subscribedListeners.add(listener);
        }

        public void unsubscribe(DirectoryListener listener, String filter) {
            Iterator<DirectoryListener> iter2 = this.subscribedListeners.iterator();
            Iterator<String> iter = this.subscribedFilters.iterator();
            while (iter.hasNext()) {
                String item = iter.next();
                DirectoryListener listener2 = iter2.next();
                if (listener != listener2 || !item.equals(filter)) continue;
                iter.remove();
                iter2.remove();
                this.theservice.unsubscribeLocal(listener, filter);
                break;
            }
        }

        private void unsubscribeAll() {
            Iterator<DirectoryListener> iter2 = this.subscribedListeners.iterator();
            for (String item : this.subscribedFilters) {
                DirectoryListener listener = iter2.next();
                this.theservice.unsubscribeLocal(listener, item);
            }
            this.subscribedFilters.clear();
            this.subscribedListeners.clear();
        }

        @Override
        public void dispose() {
            Iterator<DirectoryListener> iter2 = this.subscribedListeners.iterator();
            for (String item : this.subscribedFilters) {
                DirectoryListener listener = iter2.next();
                this.theservice.unsubscribeLocal(listener, item);
            }
            if (this.serviceProvider != null) {
                try {
                    this.theservice.deregister(this.serviceProvider.getAddress(), this.registredServices);
                }
                catch (DirectoryException ex) {
                    Logger.getLogger(DirectoryService.SERVICENAME).warning("Problem with deregister service: " + ex);
                }
            }
            super.dispose();
        }

        @Override
        public boolean isValid() {
            return this.theservice != null;
        }

        @Override
        public void setContainer(AgentContainer container) throws Exception {
            ServiceShell ss = container.getServiceManager().getService(null, DirectoryService.SERVICENAME);
            if (ss == null || !(ss instanceof Shell)) {
                throw new Exception(String.valueOf(container.getContainerName()) + ": Cannot reconect to the Directory Service");
            }
            this.theservice = ((Shell)ss).theservice;
            this.postInit = true;
            this.memSubscribedFilters = new LinkedList<String>(this.subscribedFilters);
            this.memSubscribedListeners = new LinkedList<DirectoryListener>(this.subscribedListeners);
            this.memRegistredServices = new LinkedList<String>(this.registredServices);
        }

        @Override
        public void postInit() {
            if (!this.postInit) {
                return;
            }
            Iterator<DirectoryListener> iter2 = this.memSubscribedListeners.iterator();
            for (String item : this.memSubscribedFilters) {
                DirectoryListener listener = iter2.next();
                this.theservice.subscribeLocal(listener, item);
            }
            if (this.serviceProvider != null) {
                try {
                    this.theservice.register(this.serviceProvider.getAddress(), this.memRegistredServices);
                }
                catch (DirectoryException ex) {
                    Logger.getLogger(DirectoryService.SERVICENAME).warning("Problem with register service: " + ex);
                }
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeInt(this.registredServices.size());
            for (String string : this.registredServices) {
                Message.writeString(out, string);
            }
            out.writeObject(this.serviceProvider);
            out.writeInt(this.subscribedFilters.size());
            for (String string : this.subscribedFilters) {
                Message.writeString(out, string);
            }
            out.writeObject(this.subscribedListeners);
            for (DirectoryListener directoryListener : this.subscribedListeners) {
                out.writeObject(directoryListener);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            int cnt = in.readInt();
            this.registredServices = new LinkedHashSet<String>();
            int i = 0;
            while (i < cnt) {
                this.registredServices.add(Message.readString(in));
                ++i;
            }
            this.serviceProvider = (ElementaryEntity)in.readObject();
            cnt = in.readInt();
            this.subscribedFilters = new LinkedList<String>();
            i = 0;
            while (i < cnt) {
                this.subscribedFilters.add(Message.readString(in));
                ++i;
            }
            cnt = in.readInt();
            this.subscribedListeners = new LinkedList<DirectoryListener>();
            i = 0;
            while (i < cnt) {
                this.subscribedListeners.add((DirectoryListener)in.readObject());
                ++i;
            }
        }
    }
}

