/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.sysservice.directory;

import aglobe.container.transport.Address;

public class DirectoryRecord {
    public final Address address;
    public final String containerName;
    private String[] services;
    private int hashValue;

    public DirectoryRecord(Address address, String[] services) {
        this.address = address;
        this.containerName = address.getContainerName();
        this.services = services;
        this.updateHashValue();
    }

    public String[] getServices() {
        return this.services;
    }

    void setServices(String[] services) {
        this.services = services;
        this.updateHashValue();
    }

    public boolean hasService(String service) {
        int i = 0;
        while (i < this.services.length) {
            if (this.services[i].equals(service)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void updateHashValue() {
        int retVal = 19;
        retVal = 37 * retVal + this.address.hashCode();
        retVal = 37 * retVal + this.containerName.hashCode();
        this.hashValue = retVal = 37 * retVal + this.services.hashCode();
    }

    public int hashCode() {
        return this.hashValue;
    }

    public boolean equals(Object other) {
        if (other instanceof DirectoryRecord) {
            if (this.hashValue != other.hashCode()) {
                return false;
            }
            DirectoryRecord o = (DirectoryRecord)other;
            return this.address.equals(o.address) && this.containerName.equals(o.containerName) && this.services.equals(o.services);
        }
        return false;
    }

    public String toString() {
        String tmp = "";
        int i = 0;
        while (i < this.services.length) {
            tmp = String.valueOf(tmp) + "[" + this.services[i] + "]";
            ++i;
        }
        return "Address: " + this.address + " Container: " + this.containerName + " Services: " + tmp;
    }
}

