/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.sysservice;

import aglobe.container.AgentContainer;
import aglobe.container.ElementaryEntity;
import aglobe.container.RecepientNotFound;
import aglobe.container.service.Service;
import aglobe.container.service.ServiceShell;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;
import aglobe.ontology.MessageConstants;
import aglobe.ontology.Query;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class DirService
extends Service
implements MessageConstants {
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String PARAM = "name";
    private final Query.QueryResult[] EMPTY_ARRAY = new Query.QueryResult[0];

    public void startService() {
    }

    public void stopService() {
    }

    public ServiceShell getServiceShell(ElementaryEntity shellOwner) {
        return new Shell(shellOwner, this);
    }

    public void handleIncomingMessage(Message m) throws RecepientNotFound {
        if (!m.getPerformative().equalsIgnoreCase("REQUEST")) {
            String msg = "Wrong QUERY performative (" + m.getPerformative() + ")";
            this.sendNotUnderstood(m, msg);
            this.logWarning(msg);
        }
        if (m.getContent() instanceof Query) {
            Query q = (Query)m.getContent();
            Message re = m.getReply();
            Query nq = new Query();
            nq.setParam(q.getParam());
            nq.setValue(q.getValue());
            try {
                this.search(nq);
                re.setPerformative("DONE");
            }
            catch (Exception ex) {
                re.setPerformative("FAILURE");
                re.setReason(ex.toString());
            }
            re.setContent(nq);
            try {
                this.sendMessage(re);
            }
            catch (InvisibleContainerException ex) {
                this.logWarning(ex.toString());
            }
            re.release();
        } else {
            this.sendNotUnderstood(m, "Wrong QUERY ontology (" + m.getOntology() + ")");
            this.logWarning("Wrong QUERY ontology (" + m.getOntology() + ")");
        }
        m.release();
    }

    protected abstract void search(Query var1);

    public Query.QueryResult[] search(String param, String value) {
        Query q = new Query();
        q.setParam(param);
        q.setValue(value);
        this.search(q);
        return q.getQueryResult().toArray(this.EMPTY_ARRAY);
    }

    public static class Shell
    extends ServiceShell {
        private String name;
        transient DirService theservice = null;

        public Shell() {
        }

        private Shell(ElementaryEntity shellOwner, DirService _theservice) {
            super(shellOwner);
            this.theservice = _theservice;
            this.name = this.theservice.name;
        }

        public boolean isValid() {
            return this.theservice != null;
        }

        public void setContainer(AgentContainer container) throws Exception {
            ServiceShell ss = container.getServiceManager().getService(null, this.name);
            if (ss == null || !(ss instanceof Shell)) {
                throw new Exception(String.valueOf(container.getContainerName()) + ": Cannot reconect to the Dir Service");
            }
            this.theservice = ((Shell)ss).theservice;
        }

        public void postInit() {
        }

        public Query.QueryResult[] search(String param, String value) {
            return this.theservice.search(param, value);
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeObject(this.name);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.name = (String)in.readObject();
        }
    }
}

