/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.sysservice;

import aglobe.container.ElementaryConversationEntity;
import aglobe.container.agent.Agent;
import aglobe.container.agent.CMAgent;
import aglobe.container.service.CMService;
import aglobe.container.service.Service;
import aglobe.container.sysservice.DeployCallback;
import aglobe.container.task.Task;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;

public final class DeployTask
extends Task {
    final ElementaryConversationEntity owner;
    AgentInfo ai;
    DeployCallback callback;
    Address target;
    Agent aOwner = null;
    Service sOwner = null;
    Object lock = new Object();
    boolean finished = false;

    public DeployTask(CMAgent owner, Address target, AgentInfo ai) {
        this(owner, target, ai, null);
    }

    public DeployTask(CMService owner, Address target, AgentInfo ai) {
        this(owner, target, ai, null);
    }

    public DeployTask(CMAgent owner, Address target, AgentInfo ai, DeployCallback callback) {
        super(owner);
        this.owner = owner;
        this.ai = ai;
        this.callback = callback;
        this.target = target;
        this.aOwner = owner;
        Address targetDeployService = target.deriveServiceAddress("container/deploy");
        Message m = Message.newInstance("REQUEST", owner.getAddress(), targetDeployService);
        m.setContent(ai);
        try {
            this.sendMessage(m);
        }
        catch (InvisibleContainerException ex) {
            owner.logWarning("Undeliverable Message. Cannot deploy agent.");
            this.finish("FAILED");
        }
        m.release();
    }

    public DeployTask(CMService owner, Address target, AgentInfo ai, DeployCallback callback) {
        super(owner);
        this.owner = owner;
        this.ai = ai;
        this.callback = callback;
        this.target = target;
        this.sOwner = owner;
        Address targetDeployService = target.deriveServiceAddress("container/deploy");
        Message m = Message.newInstance("REQUEST", owner.getAddress(), targetDeployService);
        m.setContent(ai);
        try {
            this.sendMessage(m);
        }
        catch (InvisibleContainerException ex) {
            owner.logWarning("Undeliverable Message. Cannot deploy service.");
            this.finish("FAILED");
        }
        m.release();
    }

    private void finish(String r) {
        if (!this.finished) {
            this.owner.logFine("Agent Deploy finished: " + r);
            this.finished = true;
            this.cancelTask();
            if (this.callback != null) {
                try {
                    if (this.aOwner != null) {
                        this.callback.agentDeployFinished(r, this.aOwner);
                    }
                    if (this.sOwner != null) {
                        this.callback.serviceDeployFinished(r, this.sOwner);
                    }
                }
                catch (Exception e) {
                    this.owner.logSevere("Exception thrown by 'DeployFinished' method: " + e);
                }
            }
        }
    }

    protected void handleIncomingMessage(Message m) {
        this.owner.logFinest("Got message: " + m.getPerformative());
        if (m.getPerformative().equals("DONE")) {
            this.finish("DONE");
        } else if (m.getPerformative().equals("FAILURE")) {
            this.finish("FAILED");
        } else if (m.getPerformative().equals("REFUSE")) {
            this.finish("REFUSE");
        }
        m.release();
    }
}

