/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.sysservice;

import aglobe.container.ElementaryEntity;
import aglobe.container.library.LibraryManager;
import aglobe.container.library.LibraryRequesterCallback;
import aglobe.container.service.CMService;
import aglobe.container.service.ServiceShell;
import aglobe.container.task.Task;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;
import aglobe.ontology.ServiceInfo;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class DeployService
extends CMService {
    public static final String SERVICENAME = "container/deploy";
    private LinkedList<Deployer> deployers = new LinkedList();

    public DeployService() {
        this.setIdleTask(new IdleTask(this));
    }

    public ServiceShell getServiceShell(ElementaryEntity shellOwner) {
        return null;
    }

    public void startService() {
        this.logFine("DeployService created.");
    }

    public void stopService() {
    }

    private class IdleTask
    extends Task {
        DeployService owner;

        IdleTask(DeployService owner) {
            super(owner);
            this.owner = owner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void handleIncomingMessage(Message m) {
            if (m.getPerformative().equalsIgnoreCase("REQUEST")) {
                if (m.getContent() instanceof AgentInfo || m.getContent() instanceof ServiceInfo) {
                    LinkedList linkedList = this.owner.deployers;
                    synchronized (linkedList) {
                        this.owner.deployers.add(new Deployer(this.owner, m));
                        return;
                    }
                }
                this.owner.logWarning("Bad ontology: " + m.getOntology());
                this.sendNotUnderstood(m, "Bad ontology");
            } else {
                this.owner.logWarning("Bad performative: " + m.getPerformative());
                this.sendNotUnderstood(m, "Bad performative");
            }
            m.release();
        }
    }

    private class Deployer
    extends Task
    implements LibraryRequesterCallback {
        DeployService owner;
        Message m;
        AgentInfo ai;
        ServiceInfo si;
        boolean finished;
        boolean libsOK;
        int libcnt;

        Deployer(DeployService owner, Message m) {
            Message re;
            Deployer item;
            Iterator iter;
            List<String> libs;
            super(owner);
            this.finished = false;
            this.libsOK = true;
            this.owner = owner;
            this.m = m;
            if (m.getContent() instanceof AgentInfo) {
                this.ai = (AgentInfo)m.getContent();
                this.si = null;
            } else {
                this.ai = null;
                this.si = (ServiceInfo)m.getContent();
            }
            Address srcContainer = m.getSender().deriveContainerAddress();
            boolean duplicate = false;
            if (this.ai != null) {
                libs = this.ai.getLibraries().getLibrary();
                if (owner.getContainer().getAgentManager().existsAgent(this.ai.getName())) {
                    duplicate = true;
                } else {
                    iter = owner.deployers.iterator();
                    while (iter.hasNext()) {
                        item = (Deployer)iter.next();
                        if (item.finished) {
                            iter.remove();
                            continue;
                        }
                        if (item.ai == null || !this.myEqueals(this.ai, item.ai)) continue;
                        duplicate = true;
                        break;
                    }
                }
            } else {
                libs = this.si.getLibraries().getLibrary();
                if (owner.getContainer().getServiceManager().existsService(this.si.getName())) {
                    duplicate = true;
                } else {
                    iter = owner.deployers.iterator();
                    while (iter.hasNext()) {
                        item = (Deployer)iter.next();
                        if (item.finished) {
                            iter.remove();
                            continue;
                        }
                        if (item.si == null || !this.myEqueals(this.si, item.si)) continue;
                        duplicate = true;
                        break;
                    }
                }
            }
            if (duplicate) {
                re = m.getReply();
                re.setPerformative("REFUSE");
                try {
                    this.sendMessageAsReference(re);
                }
                catch (InvisibleContainerException ex) {
                    owner.logWarning("Cannot send refuse to the requester: " + ex);
                }
                re.release();
                this.finished = true;
                this.cancelTask();
            } else {
                re = m.getReply();
                re.setPerformative("AGREE");
                try {
                    this.sendMessageAsReference(re);
                }
                catch (InvisibleContainerException ex1) {
                    owner.logWarning("Cannot send agree to the requester: " + ex1);
                }
                re.release();
                LibraryManager lm = DeployService.this.getContainer().getLibraryManager();
                this.libcnt = libs.size();
                if (this.libcnt > 0) {
                    Iterator<String> i = libs.iterator();
                    while (i.hasNext()) {
                        lm.obtainLibrary(owner.getContainer(), srcContainer, i.next(), this);
                    }
                } else {
                    this.libraryRequestFinished(DONE);
                }
            }
        }

        private boolean myEqueals(AgentInfo ai1, AgentInfo ai2) {
            if (!ai1.getName().equals(ai2.getName())) {
                return false;
            }
            if (!ai1.getReadableName().equals(ai2.getReadableName())) {
                return false;
            }
            if (!ai1.getType().equals(ai1.getType())) {
                return false;
            }
            return ai1.getMainClass().equals(ai2.getMainClass());
        }

        private boolean myEqueals(ServiceInfo si1, ServiceInfo si2) {
            if (!si1.getName().equals(si2.getName())) {
                return false;
            }
            return si1.getMainClass().equals(si2.getMainClass());
        }

        public void handleIncomingMessage(Message m, Exception ex) {
            this.cancelTask();
        }

        public synchronized void libraryRequestFinished(LibraryRequesterCallback.Result result) {
            if (result == FAILED) {
                this.libsOK = false;
            }
            if (this.libcnt > 0) {
                --this.libcnt;
            }
            if (this.libcnt == 0) {
                if (this.libsOK) {
                    try {
                        Message re = this.m.getReply();
                        re.setPerformative("DONE");
                        try {
                            if (this.ai != null) {
                                this.owner.getContainer().getAgentManager().createAgent(this.ai, false);
                            } else {
                                this.owner.getContainer().getServiceManager().registerService(this.si);
                            }
                        }
                        catch (Exception ex) {
                            this.owner.logSevere("Error while starting Agent/Service: " + ex);
                        }
                        this.sendMessageAsReference(re);
                        re.release();
                        this.finished = true;
                        this.cancelTask();
                        return;
                    }
                    catch (InvisibleContainerException ex1) {
                        this.owner.logWarning("Cannot send done to the requester: " + ex1);
                    }
                } else {
                    Message re = this.m.getReply();
                    re.setPerformative("FAILURE");
                    try {
                        this.sendMessageAsReference(re);
                        this.finished = true;
                        this.cancelTask();
                    }
                    catch (InvisibleContainerException ex) {
                        this.owner.logWarning("Cannot send failure to the requester: " + ex);
                    }
                    re.release();
                }
            }
        }

        protected void handleIncomingMessage(Message m) {
        }

        public void cancelTask() {
            if (this.m != null) {
                this.m.release();
                this.m = null;
            }
            super.cancelTask();
        }
    }
}

