/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.sysservice;

import aglobe.container.ElementaryEntity;
import aglobe.container.EventReceiver;
import aglobe.container.agent.Agent;
import aglobe.container.service.CMService;
import aglobe.container.service.ServiceShell;
import aglobe.container.sysservice.AgentMoverCallback;
import aglobe.container.task.TimeoutTask;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;

public final class AgentMoverService
extends CMService {
    private static final int TIMEOUT = 10000;
    public static final String SERVICENAME = "agent/mover";

    public void moveAgent(Agent a, AgentInfo ai, AgentMoverCallback callback, EventReceiver timeoutThreadReceiver) {
        if (timeoutThreadReceiver != null) {
            new AgentMoverTask(this, a, ai, callback, timeoutThreadReceiver);
        } else {
            new AgentMoverTask(this, a, ai, callback, this);
        }
    }

    public ServiceShell getServiceShell(ElementaryEntity shellOwner) {
        return null;
    }

    public void startService() {
    }

    public void stopService() {
    }

    private class AgentMoverTask
    extends TimeoutTask {
        AgentMoverService owner;
        Agent agent;
        AgentInfo ai;
        AgentMoverCallback callback;
        Object lock;
        boolean finished;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AgentMoverTask(AgentMoverService owner, Agent a, AgentInfo ai, AgentMoverCallback callback, EventReceiver timeoutThreadReceiver) {
            super(owner, 10000, timeoutThreadReceiver);
            this.lock = new Object();
            this.finished = false;
            this.owner = owner;
            this.agent = a;
            this.ai = ai;
            this.callback = callback;
            Object object = this.lock;
            synchronized (object) {
                Address target = this.agent.getMigrationDest().deriveServiceAddress("container/deploy");
                Message m = Message.newInstance("REQUEST", owner.getAddress(), target);
                m.setContent(ai);
                try {
                    this.sendMessage(m);
                }
                catch (InvisibleContainerException ex) {
                    this.finish(AgentMoverCallback.FAILED);
                }
                m.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void timeout() {
            Object object = this.lock;
            synchronized (object) {
                this.owner.logWarning("Timeout while moving agent: " + this.ai.getName());
                this.finish(AgentMoverCallback.FAILED);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finish(AgentMoverCallback.Result r) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.finished) {
                    this.owner.logger.fine("Agent Move finished: " + (r == AgentMoverCallback.FAILED ? "FAILED" : "DONE"));
                    this.finished = true;
                    this.cancelTask();
                    try {
                        this.callback.agentMoveFinished(r, this.agent);
                    }
                    catch (Exception e) {
                        this.owner.logSevere("Exception thrown by 'agentMoveFinished' method: " + e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleIncomingMessage(Message m) {
            Object object = this.lock;
            synchronized (object) {
                this.owner.logger.finest("Got message: " + m.getPerformative());
                if (m.getPerformative().equals("DONE")) {
                    this.finish(AgentMoverCallback.DONE);
                } else if (m.getPerformative().equals("FAILURE")) {
                    this.finish(AgentMoverCallback.FAILED);
                } else if (m.getPerformative().equals("REFUSE")) {
                    this.finish(AgentMoverCallback.FAILED);
                }
            }
            m.release();
        }
    }
}

