/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.service;

import aglobe.container.AgentContainer;
import aglobe.container.DuplicateNameException;
import aglobe.container.ElementaryEntity;
import aglobe.container.MessageReceiver;
import aglobe.container.RecepientNotFound;
import aglobe.container.Store;
import aglobe.container.gui.ListListener;
import aglobe.container.gui.ListSource;
import aglobe.container.library.LibraryManager;
import aglobe.container.library.LibraryRequesterCallback;
import aglobe.container.service.Service;
import aglobe.container.service.ServiceRunner;
import aglobe.container.service.ServiceShell;
import aglobe.container.transport.Address;
import aglobe.ontology.Message;
import aglobe.ontology.ServiceInfo;
import aglobe.ontology.ServiceList;
import aglobe.platform.thread.AglobeThreadPool;
import aglobe.util.AglobeXMLtools;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceManager
implements MessageReceiver,
ListSource {
    private static final String SERVICESTORE = "service/autorun.xml";
    public static final String SERVICETHREAD = "Services";
    public static final String MAIN_SERVICE_THREAD_NAME = "main service thread";
    private final AgentContainer container;
    private ThreadGroup _servicethreads = null;
    Map<String, Service> _servicemap = new TreeMap<String, Service>();
    ServiceList _servicelist = null;
    private boolean managerShutDown = false;
    final Object lock = new Object();
    ListListener listListener = null;
    Logger logger = Logger.getLogger("container.ServiceManager");
    boolean libraryWait = false;
    boolean libraryFailed = false;
    Object libraryWaitLock = new Object();

    public void aferContainerInit(Map<String, Service> services, ServiceList _serviceList, Address librarySourceContainer) throws Exception {
        this.initServices(services, _serviceList, librarySourceContainer);
    }

    private void stopService(Service service) {
        service.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServiceManager(int timeout) {
        this.managerShutDown = true;
        Object object = this.lock;
        synchronized (object) {
            Iterator<Service> i = this._servicemap.values().iterator();
            while (i.hasNext()) {
                this.stopService(i.next());
            }
        }
        object = this.lock;
        synchronized (object) {
            int curRunning = this._servicemap.size();
            int lastRunning = -1;
            while (curRunning > 0 && curRunning != lastRunning) {
                lastRunning = curRunning;
                try {
                    this.lock.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                curRunning = this._servicemap.size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceShell getService(ElementaryEntity shellOwner, String _name) {
        Service ser;
        Object object = this.lock;
        synchronized (object) {
            ser = this._servicemap.get(_name);
        }
        if (ser != null) {
            return ser.getServiceShellSys(shellOwner);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInfo getServiceInfo(String _name) {
        ServiceInfo si;
        if (_name == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            int i = this._servicelist.getServiceInfo().indexOf(new ServiceInfoComparator(_name));
            if (i != -1) {
                ServiceInfo orig_si = this._servicelist.getServiceInfo().get(i);
                si = (ServiceInfo)AglobeXMLtools.cloneSerializable(orig_si);
            } else {
                Service s = this._servicemap.get(_name);
                if (s != null) {
                    si = new ServiceInfo();
                    si.setName(_name);
                    si.setMainClass("");
                    si.setDescription("This service is part of the container infrastructure.\nIt should not be stopped.");
                } else {
                    si = null;
                }
            }
        }
        return si;
    }

    public Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsService(String _name) {
        Object object = this.lock;
        synchronized (object) {
            return this._servicemap.containsKey(_name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerService(ServiceInfo si) throws Exception {
        if (si.getName().length() == 0) {
            throw new Exception("Requested service name is empty!");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this._servicelist.getServiceInfo().contains(new ServiceInfoComparator(si.getName()))) {
                throw new DuplicateNameException("Service with name " + si.getName() + " already exists!");
            }
            Service service = this.loadService(si);
            this._servicelist.getServiceInfo().add(si);
            Store s = this.container.getGlobalStore();
            s.putXML(SERVICESTORE, this._servicelist);
        }
        this.fireListListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showService(String name) {
        Service s;
        Object object = this.lock;
        synchronized (object) {
            s = this._servicemap.get(name);
        }
        if (s != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    s.showGUI();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideService(String name) {
        Service s;
        Object object = this.lock;
        synchronized (object) {
            s = this._servicemap.get(name);
        }
        if (s != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    s.hideGUI();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishService(String _name, boolean remove) {
        int pos;
        if (!remove) {
            Service ser = null;
            Object object = this.lock;
            synchronized (object) {
                ser = this._servicemap.get(_name);
                this._servicemap.remove(_name);
                if (this.managerShutDown) {
                    this.lock.notify();
                }
            }
            if (ser != null) {
                ser.stopService();
                ser.sysFinish();
            }
        }
        if ((pos = this._servicelist.getServiceInfo().indexOf(new ServiceInfoComparator(_name))) != -1) {
            if (remove) {
                Service ser = null;
                Object object = this.lock;
                synchronized (object) {
                    ser = this._servicemap.get(_name);
                    this._servicemap.remove(_name);
                }
                if (ser != null) {
                    ser.stopService();
                    ser.sysFinish();
                }
            }
            ServiceInfo si = this._servicelist.getServiceInfo().get(pos);
            this._servicelist.getServiceInfo().remove(pos);
            LibraryManager lm = this.container.getLibraryManager();
            lm.deregisterService(si.getName(), si.getLibraries().getLibrary().toArray(new String[0]));
            if (remove) {
                Store s = this.container.getGlobalStore();
                s.putXML(SERVICESTORE, this._servicelist);
            }
            this.fireListListener();
        }
    }

    public void stopService(String _name) {
        this.finishService(_name, false);
    }

    public void deregisterService(String _name) {
        this.finishService(_name, true);
    }

    public void startService(String name, Service service) throws DuplicateNameException {
        this.startService(name, service, ClassLoader.getSystemClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startService(String name, final Service service, ClassLoader classLoader) throws DuplicateNameException {
        Object object = this.lock;
        synchronized (object) {
            if (this._servicemap.containsKey(name)) {
                throw new DuplicateNameException(name);
            }
            service.setName(name, null, this.container);
            this.container.getLibraryManager().registerClassOwner(service, classLoader);
            service.addEvent(new Runnable(){

                public void run() {
                    service.startService();
                }
            });
            this._servicemap.put(name, service);
            ThreadGroup stg = new ThreadGroup(this._servicethreads, service.getName());
            AglobeThreadPool.startInNewThread(stg, new ServiceRunner(service, stg), String.valueOf(this.container.getContainerName()) + ": " + service.getName() + ": " + MAIN_SERVICE_THREAD_NAME);
        }
        this.fireListListener();
    }

    public ServiceManager(AgentContainer container) {
        this.container = container;
        this._servicethreads = new ThreadGroup(container.getContainerThreadGroup(), SERVICETHREAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initServices(Map<String, Service> services, ServiceList _StartingServiceList, Address librarySourceContainer) throws Exception {
        Store s = this.container.getGlobalStore();
        try {
            Object object = this.lock;
            synchronized (object) {
                boolean checkLibrary = false;
                boolean saveChanges = false;
                if (_StartingServiceList == null) {
                    if (s.exist(SERVICESTORE)) {
                        this._servicelist = (ServiceList)s.getXML(SERVICESTORE, ServiceList.class);
                    } else {
                        this.logger.fine("Creating empty service list...");
                        this._servicelist = new ServiceList();
                    }
                } else {
                    checkLibrary = true;
                    this.logger.fine("Service list read from starting params...");
                    this._servicelist = _StartingServiceList;
                }
                LibraryManager lm = this.container.getLibraryManager();
                for (String key : services.keySet()) {
                    Service service = services.get(key);
                    if (service != null) {
                        this.startService(key, service);
                        continue;
                    }
                    throw new IllegalArgumentException("null service: " + key);
                }
                this.libraryFailed = false;
                List<ServiceInfo> sl = this._servicelist.getServiceInfo();
                Iterator<Object> i = sl.iterator();
                while (i.hasNext()) {
                    ServiceInfo si = (ServiceInfo)i.next();
                    if (checkLibrary && si.getLibraries().getLibrary().size() > 0) {
                        if (librarySourceContainer == null) {
                            this.logger.severe("Libary source container is not specified.");
                            throw new Exception("Library source container is not specified.");
                        }
                        for (String item : si.getLibraries().getLibrary()) {
                            Object object2 = this.libraryWaitLock;
                            synchronized (object2) {
                                this.libraryWait = true;
                                lm.obtainLibrary(this.container, librarySourceContainer, item, new LibraryRequesterCallback(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void libraryRequestFinished(LibraryRequesterCallback.Result result) {
                                        Object object = ServiceManager.this.libraryWaitLock;
                                        synchronized (object) {
                                            if (result == LibraryRequesterCallback.FAILED) {
                                                ServiceManager.this.libraryFailed = true;
                                            }
                                            ServiceManager.this.libraryWait = false;
                                            ServiceManager.this.libraryWaitLock.notify();
                                        }
                                    }
                                });
                                while (this.libraryWait) {
                                    try {
                                        this.libraryWaitLock.wait();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    if (!this.libraryFailed) continue;
                                    this.logger.severe("Library: " + item + " cannot be loaded from: " + librarySourceContainer);
                                    throw new Exception("Library: " + item + " cannot be loaded from: " + librarySourceContainer);
                                }
                            }
                        }
                    }
                    try {
                        this.loadService(si);
                    }
                    catch (Exception ex) {
                        i.remove();
                        saveChanges = true;
                        this.logger.severe("Error while restarting the Service: " + si.getName() + " (" + ex + ")\nThe service has been removed from autostart configuration.");
                    }
                }
                if (saveChanges) {
                    s.putXML(SERVICESTORE, this._servicelist);
                }
            }
            this.fireListListener();
        }
        catch (Exception ex) {
            this.logger.severe("Cannot start the default services! " + ex);
            throw ex;
        }
    }

    private Service loadService(ServiceInfo si) throws Exception {
        LibraryManager lm = this.container.getLibraryManager();
        List<String> libs = si.getLibraries().getLibrary();
        ClassLoader classLoader = lm.registerService(si.getName(), libs.toArray(new String[libs.size()]));
        Class<?> cl = classLoader.loadClass(si.getMainClass());
        Constructor<?> con = cl.getConstructor(new Class[0]);
        final Service service = (Service)con.newInstance(new Object[0]);
        lm.registerClassOwner(service, classLoader);
        service.setName(si.getName(), (ServiceInfo)AglobeXMLtools.cloneSerializable(si), this.container);
        service.addEvent(new Runnable(){

            public void run() {
                service.startService();
            }
        });
        this._servicemap.put(si.getName(), service);
        ThreadGroup stg = new ThreadGroup(this._servicethreads, si.getName());
        AglobeThreadPool.startInNewThread(stg, new ServiceRunner(service, stg), String.valueOf(this.container.getContainerName()) + ": " + service.getName() + ": " + MAIN_SERVICE_THREAD_NAME);
        return service;
    }

    public List<ServiceInfo> getRunningServices() {
        LinkedList<ServiceInfo> retVal = new LinkedList<ServiceInfo>();
        TreeSet collection = new TreeSet(this._servicemap.keySet());
        for (String item : collection) {
            ServiceInfo si = this.getServiceInfo(item);
            retVal.add(si);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service getServiceInstance(String serviceName) {
        Object object = this.lock;
        synchronized (object) {
            return this._servicemap.get(serviceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageReceiver getMessageReceiver(String receiver) throws RecepientNotFound {
        Service service = null;
        Object object = this.lock;
        synchronized (object) {
            service = this._servicemap.get(receiver);
        }
        if (service == null) {
            throw new RecepientNotFound();
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incomingMessage(Message m) throws RecepientNotFound {
        Address receiver = m.getReceiver();
        Service service = null;
        Object object = this.lock;
        synchronized (object) {
            service = this._servicemap.get(receiver.getName());
        }
        if (service == null) {
            m.release();
            throw new RecepientNotFound();
        }
        service.incomingMessage(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListListener(ListListener ll) {
        TreeSet<String> services;
        Object object = this.lock;
        synchronized (object) {
            this.listListener = ll;
            services = new TreeSet<String>((Collection)this._servicemap.keySet());
        }
        ll.ListChanged(ListListener.SERVICES, services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireListListener() {
        ListListener ll;
        TreeSet<String> services;
        Object object = this.lock;
        synchronized (object) {
            services = new TreeSet<String>((Collection)this._servicemap.keySet());
            ll = this.listListener;
        }
        if (ll != null) {
            ll.ListChanged(ListListener.SERVICES, services);
        }
    }

    public class ServiceInfoComparator {
        String _name;

        ServiceInfoComparator(String name) {
            this._name = name;
        }

        public boolean equals(Object other) {
            if (other instanceof ServiceInfo) {
                return this._name.equals(((ServiceInfo)other).getName());
            }
            return super.equals(other);
        }
    }
}

