/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.service;

import aglobe.container.AgentContainer;
import aglobe.container.CallerInferer;
import aglobe.container.ElementaryEntity;
import aglobe.container.MessageReceiver;
import aglobe.container.Store;
import aglobe.container.library.ClassLoaderOwner;
import aglobe.container.service.ServiceRunner;
import aglobe.container.service.ServiceShell;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.container.transport.MessageTransport;
import aglobe.ontology.Message;
import aglobe.ontology.ServiceInfo;
import aglobe.platform.thread.AglobeThreadPool;
import aglobe.service.gis.client.GISClientService;
import aglobe.service.gis.server.GISServerService;
import java.awt.Component;
import java.awt.Window;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.LinkedList;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public abstract class Service
extends ClassLoaderOwner
implements ElementaryEntity {
    public Logger logger = Logger.getLogger("global");
    protected String name;
    protected ServiceInfo serviceInfo = null;
    private AgentContainer container = null;
    private boolean kill = false;
    private boolean stop = false;
    public static final int UNKNOWN_STATUS = -1;
    public static final int KILL_STATUS = 1;
    public static final int STOP_STATUS = 2;
    public static final int SLEEP_STATUS = 3;
    private static final int MAXPLAN = 1000000;
    private static final int MAXWAIT = 1000;
    private LinkedList<Object> plan = new LinkedList();
    private MessageTransport mt = null;
    private Address serviceAddress = null;
    private boolean logConnectionInitialized = false;
    private boolean hasLogConnection = false;
    private GISServerService.Shell gisServerShell = null;
    private GISClientService.Shell gisClientShell = null;
    ServiceRunner myServiceRunner = null;
    private boolean isActive = true;
    private volatile boolean hasThreadAssigned = true;
    private String myThreadName = null;
    private boolean usePersistentThread = false;
    private int lastMsgSize = 0;

    public final void setName(String name, ServiceInfo si, AgentContainer container) {
        this.container = container;
        this.name = name;
        this.serviceInfo = si;
        this.mt = container.getMessageTransport();
        this.logger = Logger.getLogger("service." + name);
    }

    public final AgentContainer getContainer() {
        return this.container;
    }

    public final String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ServiceShell getServiceShellSys(ElementaryEntity shellOwner) {
        LinkedList<Object> linkedList = this.plan;
        synchronized (linkedList) {
            block4: {
                if (this.isActive) break block4;
                return null;
            }
        }
        return this.getServiceShell(shellOwner);
    }

    protected abstract ServiceShell getServiceShell(ElementaryEntity var1);

    public abstract void startService();

    public abstract void stopService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sysFinish() {
        LinkedList<Object> linkedList = this.plan;
        synchronized (linkedList) {
            if (!this.isActive) {
                for (Object e : this.plan) {
                    if (!(e instanceof Message)) continue;
                    ((Message)e).release();
                }
                this.plan.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void showGUI() {
        try {
            LinkedList<Object> linkedList = this.plan;
            synchronized (linkedList) {
                if (!this.isActive) {
                    return;
                }
            }
            Field gui = this.getClass().getField("gui");
            Object o = gui.get(this);
            if (o != null && o instanceof Component) {
                final Component reflectGUI = (Component)o;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (reflectGUI != null) {
                            reflectGUI.setVisible(true);
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void hideGUI() {
        try {
            Field gui = this.getClass().getField("gui");
            Object o = gui.get(this);
            if (o != null && o instanceof Component) {
                final Component reflectGUI = (Component)o;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (reflectGUI != null) {
                            reflectGUI.setVisible(false);
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void destroyGUI() {
        try {
            Field gui = this.getClass().getField("gui");
            Object o = gui.get(this);
            if (o != null && o instanceof Window) {
                Window reflectGUI = (Window)o;
                reflectGUI.dispose();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void sendMessage(Message m) throws InvisibleContainerException {
        this.lastMsgSize = 0;
        this.lastMsgSize = m.isMulticast() ? this.mt.sendMulticastMessage(m, false) : this.mt.sendStandardMessage(m, false);
    }

    public void sendMessageAsReference(Message m) throws InvisibleContainerException {
        this.lastMsgSize = 0;
        this.lastMsgSize = m.isMulticast() ? this.mt.sendMulticastMessage(m, true) : this.mt.sendStandardMessage(m, true);
    }

    public int getLastMessageSize() {
        return this.lastMsgSize;
    }

    protected final void sendNotUnderstood(Message m, String reason) {
        if (!m.getPerformative().equalsIgnoreCase("NOT-UNDERSTOOD")) {
            Message re = m.getReply();
            re.setContent(m.getContent());
            re.setPerformative("NOT-UNDERSTOOD");
            if (reason != null) {
                re.setReason(reason);
            }
            try {
                this.sendMessage(re);
            }
            catch (InvisibleContainerException invisibleContainerException) {
                // empty catch block
            }
            re.release();
        }
    }

    public final Address getAddress() {
        if (this.serviceAddress == null) {
            this.serviceAddress = Address.getLocalServiceAddress(this, this.name);
        }
        return this.serviceAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void kill() {
        LinkedList<Object> linkedList = this.plan;
        synchronized (linkedList) {
            if (!this.isActive) {
                return;
            }
            this.kill = true;
            if (this.hasThreadAssigned) {
                this.plan.notify();
            } else {
                this.hasThreadAssigned = true;
                AglobeThreadPool.startInNewThread(this.myServiceRunner.serviceThreadGroup, this.myServiceRunner, this.myThreadName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void stop() {
        LinkedList<Object> linkedList = this.plan;
        synchronized (linkedList) {
            if (!this.isActive) {
                return;
            }
            this.stop = true;
            if (this.hasThreadAssigned) {
                this.plan.notify();
            } else {
                this.hasThreadAssigned = true;
                AglobeThreadPool.startInNewThread(this.myServiceRunner.serviceThreadGroup, this.myServiceRunner, this.myThreadName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final TimerTask scheduleEvent(final Runnable event, long delay) {
        LinkedList<Object> linkedList = this.plan;
        synchronized (linkedList) {
            if (!this.isActive) {
                return null;
            }
        }
        TimerTask tt = new TimerTask(){

            public void run() {
                Service.this.addEvent(event);
            }
        };
        this.getContainer().TIMER.schedule(tt, delay);
        return tt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final TimerTask scheduleEvent(final Runnable event, long delay, long period) {
        LinkedList<Object> linkedList = this.plan;
        synchronized (linkedList) {
            if (!this.isActive) {
                return null;
            }
        }
        TimerTask tt = new TimerTask(){

            public void run() {
                Service.this.addEvent(event);
            }
        };
        this.getContainer().TIMER.schedule(tt, delay, period);
        return tt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addEvent(Runnable e) {
        LinkedList<Object> linkedList = this.plan;
        synchronized (linkedList) {
            if (!this.isActive) {
                return;
            }
            if (this.plan.size() >= 1000000) {
                throw new IllegalStateException("Maximum scheduled tasks limit exceeded");
            }
            this.plan.addLast(e);
            if (this.hasThreadAssigned) {
                this.plan.notify();
            } else {
                this.hasThreadAssigned = true;
                AglobeThreadPool.startInNewThread(this.myServiceRunner.serviceThreadGroup, this.myServiceRunner, this.myThreadName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int run() {
        try {
            if (this.myThreadName == null) {
                this.myThreadName = Thread.currentThread().getName();
            }
            while (true) {
                boolean planIsEmpty;
                LinkedList<Object> linkedList;
                if (this.kill || this.stop) {
                    linkedList = this.plan;
                    synchronized (linkedList) {
                        this.isActive = false;
                        break;
                    }
                }
                linkedList = this.plan;
                synchronized (linkedList) {
                    planIsEmpty = this.plan.isEmpty();
                }
                if (!planIsEmpty) {
                    Object o;
                    LinkedList<Object> linkedList2 = this.plan;
                    synchronized (linkedList2) {
                        o = this.plan.removeFirst();
                    }
                    if (o instanceof Runnable) {
                        ((Runnable)o).run();
                        continue;
                    }
                    if (!(o instanceof Message)) continue;
                    Message m = (Message)o;
                    this.handleIncomingMessage(m);
                    continue;
                }
                linkedList = this.plan;
                synchronized (linkedList) {
                    if (this.plan.isEmpty()) {
                        if (!this.usePersistentThread) {
                            this.hasThreadAssigned = false;
                            return 3;
                        }
                        try {
                            this.plan.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            if (this.kill) {
                return 1;
            }
            if (this.stop) {
                return 2;
            }
            return -1;
        }
        catch (Throwable ex) {
            LinkedList<Object> linkedList = this.plan;
            synchronized (linkedList) {
                this.isActive = false;
            }
            this.logSevere("Run exception: " + ex);
            ex.printStackTrace();
            return -1;
        }
    }

    protected final void setThreadPersistency(boolean persistent) {
        this.usePersistentThread = persistent;
        AglobeThreadPool.adjustThreadMode(!this.usePersistentThread);
    }

    public final MessageReceiver getMessageReceiver(String receiver) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incomingMessage(Message m) {
        LinkedList<Object> linkedList = this.plan;
        synchronized (linkedList) {
            if (!this.isActive) {
                m.release();
                return;
            }
            if (this.plan.size() >= 1000000) {
                throw new IllegalStateException("Maximum scheduled tasks limit exceeded");
            }
            this.plan.addLast(m);
            if (this.hasThreadAssigned) {
                this.plan.notify();
            } else {
                this.hasThreadAssigned = true;
                AglobeThreadPool.startInNewThread(this.myServiceRunner.serviceThreadGroup, this.myServiceRunner, this.myThreadName);
            }
        }
    }

    protected abstract void handleIncomingMessage(Message var1);

    public final Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void log(Level level, String[] callPoint, String message) {
        String lm = "container: " + this.getContainer().getContainerName() + "; service: " + this.getName() + "\n" + message;
        if (this.logger != null) {
            this.logger.logp(level, callPoint[0], callPoint[1], lm);
        } else {
            Logger.getAnonymousLogger().logp(level, callPoint[0], callPoint[1], lm);
        }
        LinkedList<Object> linkedList = this.plan;
        synchronized (linkedList) {
            if (!this.logConnectionInitialized && this.isActive) {
                this.gisClientShell = (GISClientService.Shell)this.getContainer().getServiceManager().getService(this, "gis/client");
                if (this.gisClientShell == null) {
                    this.gisServerShell = (GISServerService.Shell)this.getContainer().getServiceManager().getService(this, "gis/master");
                    if (this.gisServerShell != null) {
                        this.hasLogConnection = true;
                    }
                } else {
                    this.hasLogConnection = true;
                }
                this.logConnectionInitialized = true;
            }
        }
        if (this.hasLogConnection) {
            String m = String.valueOf(new Date().toString()) + ": " + callPoint[0] + " " + callPoint[1] + "\n" + level.toString() + ": " + lm;
            if (this.gisClientShell != null) {
                this.gisClientShell.submitTopic("LOGGER_MESSAGE", m, Integer.toString(level.intValue()));
            } else if (this.gisServerShell != null) {
                this.gisServerShell.sendTopicToLocal("LOGGER_MESSAGE", m, Integer.toString(level.intValue()));
            }
        }
    }

    private final void log(Level level, String message) {
        String[] callPoint = CallerInferer.inferCaller();
        this.log(level, callPoint, message);
    }

    public final void logFinest(String message) {
        this.log(Level.FINEST, message);
    }

    public final void logFine(String message) {
        this.log(Level.FINE, message);
    }

    public final void logInfo(String message) {
        this.log(Level.INFO, message);
    }

    public final void logWarning(String message) {
        this.log(Level.WARNING, message);
    }

    public final void logSevere(String message) {
        this.log(Level.SEVERE, message);
    }

    public final Store getStore() {
        return this.container.getServiceStore(this.name);
    }
}

