/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.library;

import aglobe.container.ElementaryEntity;
import aglobe.container.library.LibraryManager;
import aglobe.container.library.LibraryRequesterCallback;
import aglobe.container.service.CMService;
import aglobe.container.service.ServiceShell;
import aglobe.container.task.Task;
import aglobe.container.task.TimeoutTask;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.LibInfo;
import aglobe.ontology.Message;
import aglobe.ontology.TheLibrary;
import java.io.FileInputStream;
import java.io.IOException;

public final class LibraryRequesterService
extends CMService {
    private static final int TIMEOUT = 10000;
    public static final String SERVICENAME = "library/loader";

    public LibraryRequesterService() {
        this.setIdleTask(new SenderTask(this));
    }

    protected void obtainLibrary(Address srcContainer, String libname, LibraryRequesterCallback callback) {
        new RequesterTask(this, srcContainer, libname, callback);
    }

    public ServiceShell getServiceShell(ElementaryEntity shellOwner) {
        return null;
    }

    public void startService() {
    }

    public void stopService() {
    }

    private class RequesterTask
    extends TimeoutTask {
        LibraryRequesterService owner;
        Address srcContainer;
        String libname;
        LibraryRequesterCallback callback;
        boolean terminated;

        RequesterTask(LibraryRequesterService owner, Address srcContainer, String libname, LibraryRequesterCallback callback) {
            super(owner, 10000);
            this.terminated = false;
            this.owner = owner;
            this.srcContainer = srcContainer;
            this.libname = libname;
            this.callback = callback;
            Message m = Message.newInstance("REQUEST", owner.getAddress(), srcContainer.deriveServiceAddress(LibraryRequesterService.SERVICENAME));
            TheLibrary l = new TheLibrary();
            l.setName(libname);
            m.setContent(l);
            try {
                this.sendMessageAsReference(m);
            }
            catch (InvisibleContainerException ex) {
                this.terminate(LibraryRequesterCallback.FAILED);
            }
            m.release();
        }

        protected void timeout() {
            this.terminate(LibraryRequesterCallback.FAILED);
        }

        private synchronized void terminate(LibraryRequesterCallback.Result result) {
            if (!this.terminated) {
                this.terminated = true;
                this.callback.libraryRequestFinished(result);
                this.cancelTask();
            }
        }

        protected void handleIncomingMessage(Message m) {
            LibraryRequesterCallback.Result result = LibraryRequesterCallback.FAILED;
            if (m.getPerformative().equalsIgnoreCase("DONE")) {
                if (m.getContent() instanceof TheLibrary) {
                    TheLibrary l = (TheLibrary)m.getContent();
                    LibraryRequesterService.this.getContainer().getLibraryManager().storeLibrary(l);
                    result = LibraryRequesterCallback.DONE;
                } else {
                    String msg = "Wrong ontology (" + m.getOntology() + ")";
                    LibraryRequesterService.this.logWarning(msg);
                }
            } else if (!m.getPerformative().equalsIgnoreCase("FAILURE")) {
                String msg = "Wrong performative (" + m.getPerformative() + ")";
                LibraryRequesterService.this.logWarning(msg);
            }
            m.release();
            this.terminate(result);
        }
    }

    private class SenderTask
    extends Task {
        public SenderTask(CMService owner) {
            super(owner);
        }

        protected void handleIncomingMessage(Message m) {
            String msg;
            if (!m.getPerformative().equalsIgnoreCase("REQUEST")) {
                msg = "Wrong performative (" + m.getPerformative() + ")";
                LibraryRequesterService.this.logWarning(msg);
            }
            if (m.getContent() instanceof TheLibrary) {
                TheLibrary l = (TheLibrary)m.getContent();
                if (l.getData() != null) {
                    LibraryRequesterService.this.logWarning("SenderTask received message with non-empty data.");
                } else {
                    LibraryManager lm = LibraryRequesterService.this.getContainer().getLibraryManager();
                    Message re = m.getReply();
                    if (lm.exists(l.getName())) {
                        try {
                            String jarname = LibraryManager.lib2jar(l.getName());
                            FileInputStream in = lm._store.getFile(jarname);
                            byte[] content = new byte[in.available()];
                            in.read(content);
                            in.close();
                            LibInfo li = lm.getLibInfo(l.getName());
                            TheLibrary nl = new TheLibrary();
                            nl.setName(l.getName());
                            nl.setVersion(li.getVersion());
                            nl.setComment(li.getComment());
                            nl.setData(content);
                            re.setPerformative("DONE");
                            re.setContent(nl);
                        }
                        catch (IOException ex) {
                            re.setPerformative("FAILURE");
                            re.setReason(ex.toString());
                        }
                    } else {
                        re.setPerformative("FAILURE");
                    }
                    try {
                        this.sendMessageAsReference(re);
                    }
                    catch (InvisibleContainerException ex1) {
                        LibraryRequesterService.this.logWarning("Cannot send failure to the requester: " + ex1);
                    }
                    re.release();
                }
            } else {
                msg = "Wrong ontology (" + m.getOntology() + ")";
                LibraryRequesterService.this.logWarning(msg);
            }
            m.release();
        }
    }
}

