/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.library;

import aglobe.container.library.ClassLoaderOwner;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LibraryObjectInputStream
extends ObjectInputStream {
    private ClassLoader classLoader;

    public LibraryObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
        super(in);
        this.classLoader = classLoader;
    }

    public LibraryObjectInputStream(InputStream in, ClassLoaderOwner classLoaderOwner) throws IOException {
        super(in);
        this.classLoader = classLoaderOwner.classLoader;
    }

    public void setClassLoader(ClassLoaderOwner classLoaderOwner) {
        this.classLoader = classLoaderOwner.classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
        try {
            return Class.forName(v.getName(), false, this.classLoader);
        }
        catch (ClassNotFoundException ex) {
            try {
                return super.resolveClass(v);
            }
            catch (ClassNotFoundException ex2) {
                throw new IOException("No class definition found: " + v.getName());
            }
        }
    }
}

