/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.library;

import aglobe.container.AgentContainer;
import aglobe.container.Store;
import aglobe.container.gui.ListListener;
import aglobe.container.gui.ListSource;
import aglobe.container.library.ClassLoaderOwner;
import aglobe.container.library.EntityClassLoader;
import aglobe.container.library.HashCounter;
import aglobe.container.library.LibraryException;
import aglobe.container.library.LibraryRequesterCallback;
import aglobe.container.library.LibraryRequesterService;
import aglobe.container.sysservice.DirService;
import aglobe.container.transport.Address;
import aglobe.ontology.LibInfo;
import aglobe.ontology.Query;
import aglobe.ontology.TheLibrary;
import aglobe.util.AglobeXMLtools;
import aglobe.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LibraryManager
implements ListSource {
    private static Logger logger = Logger.getLogger("platform.LibraryManager");
    private static final String JAREXT = ".jar";
    private final AgentContainer ownerContainer;
    Store _store = null;
    private Map<String, LibInfo> _libmap = null;
    private LinkedList<ListListener> listListeners = new LinkedList();
    private HashMap<AgentContainer, LibraryRequesterService> requesters = new HashMap();
    final HashMap<EntityClassLoader.EntityClassLoaderDescriptor, EntityClassLoader> classLoaders = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aferContainerInit(AgentContainer container) {
        LibraryRequesterService requester = new LibraryRequesterService();
        HashMap<AgentContainer, LibraryRequesterService> hashMap = this.requesters;
        synchronized (hashMap) {
            this.requesters.put(container, requester);
        }
        try {
            container.getServiceManager().startService("library/loader", requester);
        }
        catch (Exception ex) {
            logger.severe("Cannot start LibraryRequesterService: " + ex);
        }
    }

    public LibraryManager(AgentContainer container) {
        this.ownerContainer = container;
        this._store = container.getLibraryStore();
        this._libmap = new TreeMap<String, LibInfo>();
        String[] libs = this._store.listEntries("");
        int i = 0;
        while (i < libs.length) {
            if (FileUtils.hasExtension(libs[i], "jar")) {
                this.getLibInfo(FileUtils.removeExtension(libs[i]));
            }
            ++i;
        }
    }

    public String getLibraryName(File libraryFile) {
        try {
            String newLibName = String.valueOf(FileUtils.removeExtension(libraryFile.getName()).toLowerCase()) + "." + HashCounter.getHash(libraryFile) + "." + "jar";
            return newLibName;
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private LibInfo getLibInfo(File libraryFile, String version, String comment) {
        String newLibName = this.getLibraryName(libraryFile);
        if (newLibName == null) {
            return null;
        }
        LibInfo li = this.getLibInfo(newLibName);
        li.setVersion(version);
        li.setComment(comment);
        return li;
    }

    public void registerClassOwner(ClassLoaderOwner clo, ClassLoader classLoader) {
        clo.classLoader = classLoader;
        if (classLoader instanceof EntityClassLoader) {
            EntityClassLoader ecl = (EntityClassLoader)classLoader;
            ecl.addClassLoaderOwner(clo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterClassOwner(ClassLoaderOwner clo) {
        if (clo.classLoader instanceof EntityClassLoader) {
            HashMap<EntityClassLoader.EntityClassLoaderDescriptor, EntityClassLoader> hashMap = this.classLoaders;
            synchronized (hashMap) {
                EntityClassLoader ecl = (EntityClassLoader)clo.classLoader;
                if (ecl.removeClassLoaderOwner(clo)) {
                    this.classLoaders.remove(ecl.classLoaderDescriptor);
                }
            }
        }
    }

    public synchronized ClassLoader registerAgent(String agname, String[] libnames) throws LibraryException {
        ClassLoader cl = libnames.length == 0 ? ClassLoader.getSystemClassLoader() : EntityClassLoader.getInstance(this, libnames);
        LibInfo.LibUser lu = new LibInfo.LibUser();
        lu.setName(agname);
        lu.setType("agent");
        this.register(lu, libnames);
        this.sendListChanged(ListListener.LIBRARIES, this._libmap.keySet());
        return cl;
    }

    public synchronized ClassLoader registerService(String sname, String[] libnames) throws LibraryException {
        ClassLoader cl = libnames.length == 0 ? ClassLoader.getSystemClassLoader() : EntityClassLoader.getInstance(this, libnames);
        LibInfo.LibUser lu = new LibInfo.LibUser();
        lu.setName(sname);
        lu.setType("service");
        this.register(lu, libnames);
        this.sendListChanged(ListListener.LIBRARIES, this._libmap.keySet());
        return cl;
    }

    public synchronized void deregisterAgent(String agname, String[] libnames) {
        LibInfo.LibUser lu = new LibInfo.LibUser();
        lu.setName(agname);
        lu.setType("agent");
        this.deregister(lu, libnames);
        this.sendListChanged(ListListener.LIBRARIES, this._libmap.keySet());
    }

    public synchronized void deregisterService(String sname, String[] libnames) {
        LibInfo.LibUser lu = new LibInfo.LibUser();
        lu.setName(sname);
        lu.setType("service");
        this.deregister(lu, libnames);
        this.sendListChanged(ListListener.LIBRARIES, this._libmap.keySet());
    }

    private void register(LibInfo.LibUser ui, String[] libnames) {
        int i = 0;
        while (i < libnames.length) {
            this.register(ui, libnames[i]);
            ++i;
        }
    }

    private void register(LibInfo.LibUser ui, String _libname) {
        String libname = _libname.toLowerCase();
        try {
            LibInfo li = this.getLibInfo(libname);
            if (!li.getLibUser().contains(new LibUserComparator(ui))) {
                li.getLibUser().add(ui);
                this.storeLibInfo(li);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void deregister(LibInfo.LibUser ui, String[] libnames) {
        int i = 0;
        while (i < libnames.length) {
            this.deregister(ui, libnames[i]);
            ++i;
        }
    }

    private void deregister(LibInfo.LibUser ui, String _libname) {
        String libname = _libname.toLowerCase();
        try {
            LibInfo li = this.getLibInfo(libname);
            if (li.getLibUser().remove(new LibUserComparator(ui))) {
                this.storeLibInfo(li);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean exists(String libname) {
        return this._store.exist(LibraryManager.lib2jar(libname.toLowerCase()));
    }

    public synchronized LibraryRecord[] getLibraryList() {
        String[] libs = this._store.listEntries("");
        TreeSet<LibraryRecord> records = new TreeSet<LibraryRecord>();
        int i = 0;
        while (i < libs.length) {
            if (FileUtils.hasExtension(libs[i], "jar")) {
                records.add(new LibraryRecord(this.getLibInfo(libs[i])));
            }
            ++i;
        }
        return records.toArray(new LibraryRecord[records.size()]);
    }

    public String getLibraryStoreRoot() {
        return this._store.getAbsolutePath("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendListChanged(ListListener.ListType which, Set<String> values) {
        LinkedList<ListListener> linkedList = this.listListeners;
        synchronized (linkedList) {
            for (ListListener item : this.listListeners) {
                item.ListChanged(which, values);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendValueChanged(ListListener.ListType where, Object what) {
        LinkedList<ListListener> linkedList = this.listListeners;
        synchronized (linkedList) {
            for (ListListener item : this.listListeners) {
                item.ValueChanged(where, what);
            }
        }
    }

    public synchronized LibInfo storeLibrary(File l, String comment) {
        try {
            if (!FileUtils.hasExtension(l.getName(), "jar")) {
                throw new IllegalArgumentException("Illegal library file name: " + l.getName());
            }
            String lname = FileUtils.removeExtension(l.getName()).toLowerCase();
            int maxVersion = 0;
            String xmlname = LibraryManager.lib2xml(lname);
            Pattern p = Pattern.compile("^(\\d+)$");
            try {
                if (this._store.exist(xmlname)) {
                    FileInputStream in = this._store.getFile(xmlname);
                    LibInfo li = (LibInfo)AglobeXMLtools.unmarshallJAXBObject(LibInfo.class, in);
                    ((InputStream)in).close();
                    Matcher m = p.matcher(li.getVersion());
                    if (m.find()) {
                        try {
                            maxVersion = Math.max(maxVersion, Integer.parseInt(m.group(1)));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
            }
            catch (Exception in) {
                // empty catch block
            }
            LibInfo li = this.getLibInfo(l, "ver" + (maxVersion + 1) + "@" + this.ownerContainer.getContainerName(), comment);
            FileOutputStream out = this._store.putFile(li.getName());
            FileChannel chout = out.getChannel();
            FileInputStream in = new FileInputStream(l);
            FileChannel chin = in.getChannel();
            chin.transferTo(0L, chin.size(), chout);
            chin.close();
            chout.close();
            this.ownerContainer.getClassFinder().invalidate();
            this.storeLibInfo(li);
            this.sendListChanged(ListListener.LIBRARIES, this._libmap.keySet());
            LibInfo lllast = new LibInfo();
            lllast.setName(lname);
            lllast.setVersion(Integer.toString(maxVersion + 1));
            lllast.setComment(li.getComment());
            try {
                FileOutputStream out2 = this._store.putFile(LibraryManager.lib2xml(lllast.getName()));
                AglobeXMLtools.marshallJAXBObject(lllast, out2);
                ((OutputStream)out2).close();
            }
            catch (Exception ex) {
                logger.warning("Warning storing LibInfo: " + ex);
            }
            return li;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public synchronized void storeLibrary(TheLibrary l) {
        try {
            LibInfo li = this.getLibInfo(l.getName());
            if (li.getVersion().equalsIgnoreCase("unknown") || li.getVersion().compareToIgnoreCase(l.getVersion()) < 0) {
                li.setComment(l.getComment());
                li.setVersion(l.getVersion());
                this.sendListChanged(ListListener.LIBRARIES, this._libmap.keySet());
                this.storeLibInfo(li);
                FileOutputStream out = this._store.putFile(LibraryManager.lib2jar(l.getName()));
                out.write(l.getData());
                out.close();
                this.ownerContainer.getClassFinder().invalidate();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.severe("Error writing library file.");
        }
    }

    public synchronized void deleteLibrary(String _libname) throws LibraryException {
        LibInfo li = this.getLibInfo(_libname);
        if (!li.getLibUser().isEmpty()) {
            throw new LibraryException("The library is used.");
        }
        String libname = _libname.toLowerCase();
        if (!this._store.removeFile(libname)) {
            throw new LibraryException("The library cannot be removed, because it is still loaded.");
        }
        this._store.deleteKey(LibraryManager.lib2xml(libname));
        this._libmap.remove(LibraryManager.lib2jar(libname));
        this.sendListChanged(ListListener.LIBRARIES, this._libmap.keySet());
        this.ownerContainer.getClassFinder().invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void obtainLibrary(AgentContainer container, Address srcContainer, String _libname, LibraryRequesterCallback callback) {
        String libname = _libname.toLowerCase();
        if (!this.exists(libname)) {
            LibraryRequesterService requester = null;
            HashMap<AgentContainer, LibraryRequesterService> hashMap = this.requesters;
            synchronized (hashMap) {
                requester = this.requesters.get(container);
            }
            if (requester != null) {
                requester.obtainLibrary(srcContainer, libname, callback);
            } else {
                callback.libraryRequestFinished(LibraryRequesterCallback.FAILED);
            }
        } else {
            callback.libraryRequestFinished(LibraryRequesterCallback.DONE);
        }
    }

    protected static String lib2xml(String lib) {
        if (lib.endsWith(JAREXT)) {
            return lib.replaceAll(JAREXT, ".xml");
        }
        return String.valueOf(lib) + ".xml";
    }

    protected static String lib2jar(String lib) {
        if (!lib.endsWith(JAREXT)) {
            return String.valueOf(lib) + JAREXT;
        }
        return lib;
    }

    public synchronized LibInfo getLibInfo(String _libname) {
        String libname = _libname.toLowerCase();
        LibInfo li = this._libmap.get(LibraryManager.lib2jar(libname));
        if (li != null) {
            return li;
        }
        String xmlname = LibraryManager.lib2xml(libname);
        try {
            if (!this._store.exist(xmlname)) {
                throw new Exception("File not found.");
            }
            FileInputStream in = this._store.getFile(xmlname);
            li = (LibInfo)AglobeXMLtools.unmarshallJAXBObject(LibInfo.class, in);
            ((InputStream)in).close();
        }
        catch (Exception ex) {
            logger.fine("Generating new LibInfo (reason: " + ex.toString() + ").");
            li = new LibInfo();
            li.setName(LibraryManager.lib2jar(libname));
            li.setComment("LibInfo automatically generated on " + DateFormat.getInstance().format(new Date(System.currentTimeMillis())));
            li.setVersion("unknown");
            this._store.putXML(xmlname, li);
        }
        this._libmap.put(LibraryManager.lib2jar(libname), li);
        return li;
    }

    private void storeLibInfo(LibInfo li) {
        try {
            FileOutputStream out = this._store.putFile(LibraryManager.lib2xml(li.getName()));
            AglobeXMLtools.marshallJAXBObject(li, out);
            ((OutputStream)out).close();
            this.sendValueChanged(ListListener.LIBRARIES, li.getName());
        }
        catch (Exception ex) {
            logger.warning("Warning storing LibInfo: " + ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListListener(ListListener ll) {
        if (ll != null) {
            ll.ListChanged(ListListener.LIBRARIES, this._libmap.keySet());
            LinkedList<ListListener> linkedList = this.listListeners;
            synchronized (linkedList) {
                this.listListeners.add(ll);
            }
        }
    }

    public class LibraryRecord
    implements Comparable {
        public final LibInfo libInfo;
        public final String absolutePathToTheLibrary;
        public final String readableName;

        private LibraryRecord(LibInfo li) {
            this.libInfo = li;
            this.absolutePathToTheLibrary = LibraryManager.this._store.getAbsolutePath(li.getName());
            this.readableName = FileUtils.removeExtension(FileUtils.removeExtension(li.getName())) + "." + li.getVersion();
        }

        public String toString() {
            return this.readableName;
        }

        public int compareTo(Object o) {
            return this.readableName.compareTo(o.toString());
        }
    }

    private class LibUserComparator {
        String name;
        String type;

        LibUserComparator(LibInfo.LibUser lu) {
            this.name = lu.getName();
            this.type = lu.getType();
        }

        public boolean equals(Object other) {
            if (other instanceof LibInfo.LibUser) {
                LibInfo.LibUser lu = (LibInfo.LibUser)other;
                return this.name.equals(lu.getName()) && this.type.equals(lu.getType());
            }
            return super.equals(other);
        }
    }

    public static class LibraryDir
    extends DirService {
        public LibraryDir() {
            logger.fine("Starting LibraryDir service");
        }

        protected void search(Query query) {
            if ("name".equalsIgnoreCase(query.getParam())) {
                String[] libs = this.getContainer().getLibraryManager()._store.listEntries("");
                Pattern p = Pattern.compile(query.getValue());
                int i = 0;
                while (i < libs.length) {
                    if (libs[i].endsWith(LibraryManager.JAREXT) && p.matcher(libs[i]).matches()) {
                        Query.QueryResult r = new Query.QueryResult();
                        r.setName(libs[i]);
                        query.getQueryResult().add(r);
                    }
                    ++i;
                }
            } else {
                throw new IllegalArgumentException("Service search 'parameter' is not name, but " + query.getParam());
            }
        }
    }
}

