/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.library;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashCounter {
    private HashCounter() {
    }

    public static String getHash(String filename) throws IOException, NoSuchAlgorithmException {
        return HashCounter.getHash(new File(filename));
    }

    public static String getHash(File file) throws IOException, NoSuchAlgorithmException {
        int read;
        FileInputStream fis = new FileInputStream(file);
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        sha1.reset();
        byte[] buffer = new byte[1024];
        while ((read = fis.read(buffer)) != -1) {
            sha1.update(buffer, 0, read);
        }
        byte[] hash = sha1.digest();
        StringBuilder sb = new StringBuilder(hash.length * 2);
        int usbyte = 0;
        int i = 0;
        while (i < hash.length) {
            usbyte = hash[i] & 0xFF;
            if (usbyte < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(usbyte));
            ++i;
        }
        fis.close();
        return sb.toString();
    }
}

