/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.library;

import aglobe.container.library.ClassLoaderOwner;
import aglobe.container.library.LibraryException;
import aglobe.container.library.LibraryManager;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class EntityClassLoader
extends URLClassLoader {
    public final EntityClassLoaderDescriptor classLoaderDescriptor;
    private final LibraryManager owner;
    private final Set<ClassLoaderOwner> classUsers = new HashSet<ClassLoaderOwner>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityClassLoader getInstance(LibraryManager owner, String[] libs) throws LibraryException {
        EntityClassLoader loader;
        EntityClassLoaderDescriptor classLoaderDescriptor = new EntityClassLoaderDescriptor(libs);
        HashMap<EntityClassLoaderDescriptor, EntityClassLoader> hashMap = owner.classLoaders;
        synchronized (hashMap) {
            loader = owner.classLoaders.get(classLoaderDescriptor);
            if (loader != null) {
                return loader;
            }
        }
        ArrayList<URL> tmplibs = new ArrayList<URL>(libs.length);
        int i = 0;
        while (i < libs.length) {
            File f = new File(owner._store.getAbsolutePath(libs[i]));
            if (f.exists()) {
                try {
                    tmplibs.add(f.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {}
            } else {
                throw new LibraryException("Library not found: " + libs[i]);
            }
            ++i;
        }
        URL[] urls = tmplibs.toArray(new URL[tmplibs.size()]);
        loader = new EntityClassLoader(owner, libs, urls, classLoaderDescriptor);
        HashMap<EntityClassLoaderDescriptor, EntityClassLoader> hashMap2 = owner.classLoaders;
        synchronized (hashMap2) {
            owner.classLoaders.put(classLoaderDescriptor, loader);
        }
        return loader;
    }

    private EntityClassLoader(LibraryManager owner, String[] libs, URL[] urls, EntityClassLoaderDescriptor classLoaderDescriptor) {
        super(urls);
        this.owner = owner;
        this.classLoaderDescriptor = classLoaderDescriptor;
    }

    void addClassLoaderOwner(ClassLoaderOwner owner) {
        this.classUsers.add(owner);
    }

    boolean removeClassLoaderOwner(ClassLoaderOwner owner) {
        this.classUsers.remove(owner);
        return this.classUsers.isEmpty();
    }

    public static class EntityClassLoaderDescriptor {
        public final String[] libs;

        private EntityClassLoaderDescriptor(String[] libs) {
            this.libs = libs;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EntityClassLoaderDescriptor)) {
                return false;
            }
            EntityClassLoaderDescriptor cmp = (EntityClassLoaderDescriptor)obj;
            if (this == obj) {
                return true;
            }
            if (this.libs.length != cmp.libs.length) {
                return false;
            }
            HashSet test = new HashSet(Arrays.asList(cmp.libs));
            int i = 0;
            while (i < this.libs.length) {
                if (!test.contains(this.libs[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

