/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.gui;

import aglobe.container.gui.AgentContainerGUI;
import aglobe.container.gui.InfoPanel;
import aglobe.ontology.ServiceInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class ServicePanel
extends InfoPanel {
    private final AgentContainerGUI owner;
    private DefaultListModel liblm = new DefaultListModel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JPanel contentPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JScrollPane contentScrollPane = new JScrollPane();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private JButton stopButton = new JButton();
    private JButton hideButton = new JButton();
    private JButton showButton = new JButton();
    private JButton refreshButton = new JButton();
    private JLabel nameLabel = new JLabel();
    private JLabel mainclassLabel = new JLabel();
    private JLabel descriptionLabel = new JLabel();
    private JLabel LibrariesLabel = new JLabel();
    private JTextField nameValue = new JTextField();
    private JTextField mainclassValue = new JTextField();
    private JScrollPane descriptionScrollPane = new JScrollPane();
    private JTextArea descriptionTextArea = new JTextArea();
    private JScrollPane librariesScrollPane = new JScrollPane();
    private JList librariesList = new JList(this.liblm);
    private JLabel jLabel1 = new JLabel();

    ServicePanel(AgentContainerGUI owner) {
        this.owner = owner;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void setValues(String name) {
        ServiceInfo si = this.owner.owner.getServiceManager().getServiceInfo(name);
        this.liblm.clear();
        if (si != null) {
            this.nameValue.setText(si.getName());
            this.mainclassValue.setText(si.getMainClass());
            this.descriptionTextArea.setText(si.getDescription());
            if (si.getLibraries() != null) {
                int pos = 0;
                for (String l : si.getLibraries().getLibrary()) {
                    this.liblm.add(pos++, l);
                }
            }
        } else {
            this.nameValue.setText("");
            this.mainclassValue.setText("");
            this.descriptionTextArea.setText("");
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.contentPanel.setLayout(this.gridBagLayout2);
        this.buttonPanel.setLayout(this.gridBagLayout3);
        this.stopButton.setText("Stop");
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServicePanel.this.stopButton_actionPerformed(e);
            }
        });
        this.hideButton.setText("Hide");
        this.hideButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServicePanel.this.hideButton_actionPerformed(e);
            }
        });
        this.showButton.setText("Show");
        this.showButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServicePanel.this.showButton_actionPerformed(e);
            }
        });
        this.refreshButton.setText("Refresh");
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServicePanel.this.refreshButton_actionPerformed(e);
            }
        });
        this.nameLabel.setText("Name:");
        this.mainclassLabel.setText("Main class:");
        this.descriptionLabel.setText("Description:");
        this.LibrariesLabel.setText("Libraries:");
        this.nameValue.setEditable(false);
        this.nameValue.setColumns(30);
        this.mainclassValue.setEditable(false);
        this.mainclassValue.setColumns(30);
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setColumns(30);
        this.descriptionTextArea.setRows(3);
        this.librariesList.setVisibleRowCount(4);
        this.contentScrollPane.getViewport().add((Component)this.contentPanel, null);
        this.librariesScrollPane.getViewport().add((Component)this.librariesList, null);
        this.descriptionScrollPane.getViewport().add((Component)this.descriptionTextArea, null);
        this.add((Component)this.contentScrollPane, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 11, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.buttonPanel.add((Component)this.stopButton, new GridBagConstraints(3, 0, 1, 1, 0.1, 0.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.hideButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 2, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.showButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 0, 2), 0, 0));
        this.buttonPanel.add((Component)this.refreshButton, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.contentPanel.add((Component)this.nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 4, 2, 4), 0, 0));
        this.contentPanel.add((Component)this.mainclassLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 4, 2, 4), 0, 0));
        this.contentPanel.add((Component)this.descriptionLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 4, 2, 4), 0, 0));
        this.contentPanel.add((Component)this.LibrariesLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 4, 2, 4), 0, 0));
        this.contentPanel.add((Component)this.nameValue, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 2, 4), 0, 0));
        this.contentPanel.add((Component)this.mainclassValue, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 17, 2, new Insets(2, 0, 2, 4), 0, 0));
        this.contentPanel.add((Component)this.descriptionScrollPane, new GridBagConstraints(1, 2, 1, 1, 0.1, 0.0, 17, 2, new Insets(2, 0, 2, 4), 0, 0));
        this.contentPanel.add((Component)this.librariesScrollPane, new GridBagConstraints(1, 3, 1, 1, 0.1, 0.0, 18, 2, new Insets(2, 0, 2, 4), 0, 0));
        this.contentPanel.add((Component)this.jLabel1, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.1, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    void refreshButton_actionPerformed(ActionEvent e) {
        this.setValues(this.nameValue.getText());
    }

    void showButton_actionPerformed(ActionEvent e) {
        this.owner.owner.getServiceManager().showService(this.nameValue.getText());
    }

    void hideButton_actionPerformed(ActionEvent e) {
        this.owner.owner.getServiceManager().hideService(this.nameValue.getText());
    }

    void stopButton_actionPerformed(ActionEvent e) {
        String an = this.nameValue.getText();
        int res = JOptionPane.showConfirmDialog(this, "Really stop the service " + an, "Stop Service", 0);
        if (res != 0) {
            return;
        }
        this.owner.owner.getServiceManager().deregisterService(an);
    }
}

