/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.gui;

import aglobe.ontology.AglobeParam;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;

class ParamPanel
extends JPanel {
    private static final String[] NAMES = new String[]{"Name", "Value"};
    private DefaultTableModel tm = new DefaultTableModel(NAMES, 0);
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JScrollPane paramScrollPane = new JScrollPane();
    private JButton removeButton = new JButton();
    private JButton addButton = new JButton();
    private JTable paramTable = new JTable(this.tm);
    private Border border1;

    ParamPanel() {
        try {
            this.jbInit();
            Dimension d = this.removeButton.getPreferredSize();
            d.width *= 4;
            d.height = this.paramTable.getRowHeight() * 4;
            this.paramTable.setPreferredScrollableViewportSize(d);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    AglobeParam[] getParams() {
        int len = 0;
        int i = 0;
        while (i < this.tm.getRowCount()) {
            String s = (String)this.tm.getValueAt(i, 0);
            if (s != null && !"".equals(s)) {
                ++len;
            }
            ++i;
        }
        int pos = 0;
        AglobeParam[] res = new AglobeParam[len];
        int i2 = 0;
        while (i2 < this.tm.getRowCount()) {
            String name = (String)this.tm.getValueAt(i2, 0);
            if (name != null && !"".equals(name)) {
                AglobeParam np = new AglobeParam();
                np.setName(name);
                np.setValue((String)this.tm.getValueAt(i2, 1));
                res[pos++] = np;
            }
            ++i2;
        }
        return res;
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createLineBorder(UIManager.getColor("Panel.background"), 1);
        this.setLayout(this.gridBagLayout1);
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParamPanel.this.removeButton_actionPerformed(e);
            }
        });
        this.addButton.setText("Add");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParamPanel.this.addButton_actionPerformed(e);
            }
        });
        this.paramScrollPane.setBorder(this.border1);
        this.add((Component)this.paramScrollPane, new GridBagConstraints(0, 0, 1, 2, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.removeButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.addButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.paramScrollPane.getViewport().add((Component)this.paramTable, null);
    }

    void addButton_actionPerformed(ActionEvent e) {
        this.tm.addRow(new String[]{"", ""});
    }

    void removeButton_actionPerformed(ActionEvent e) {
        int i = this.paramTable.getSelectedRow();
        if (i >= 0) {
            this.tm.removeRow(i);
        }
    }
}

