/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.gui;

import aglobe.container.Store;
import aglobe.container.gui.AgentContainerGUI;
import aglobe.container.library.LibraryManager;
import aglobe.util.fileinputtextfield.FileInputTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

class NewLibraryDialog
extends JDialog {
    private static final String LIB_DIRECTORY = "gui/lib_directory";
    private AgentContainerGUI owner;
    private JPanel panel1 = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel fieldPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JButton cancelButton = new JButton();
    private JButton okButton = new JButton();
    private TitledBorder titledBorder1;
    private JLabel fileLabel = new JLabel();
    private JLabel commentLabel = new JLabel();
    private FileInputTextField fileTextField = new FileInputTextField();
    private JTextField commentTextField = new JTextField();

    NewLibraryDialog(Frame frame, String title, boolean modal, AgentContainerGUI owner) {
        super(frame, title, modal);
        this.owner = owner;
        try {
            this.jbInit();
            this.pack();
            Store s = owner.owner.getGlobalStore();
            if (s.exist(LIB_DIRECTORY)) {
                this.fileTextField.setCurrentDirectory(s.getString(LIB_DIRECTORY, "ERROR"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    NewLibraryDialog(Frame frame) {
        this(frame, "Register Library", true, (AgentContainerGUI)frame);
    }

    NewLibraryDialog(AgentContainerGUI owner) {
        this(null, "Register Library", true, owner);
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Library properties");
        this.panel1.setLayout(this.borderLayout1);
        this.fieldPanel.setLayout(this.gridBagLayout1);
        this.buttonPanel.setLayout(this.gridBagLayout2);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewLibraryDialog.this.cancelButton_actionPerformed(e);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewLibraryDialog.this.okButton_actionPerformed(e);
            }
        });
        this.okButton.setPreferredSize(this.cancelButton.getPreferredSize());
        this.fieldPanel.setBorder(this.titledBorder1);
        this.fileLabel.setText("File:");
        this.commentLabel.setText("Comment:");
        this.commentTextField.setColumns(20);
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.fieldPanel, "Center");
        this.fieldPanel.add((Component)this.fileLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 3, 2, 3), 0, 0));
        this.fieldPanel.add((Component)this.commentLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 3, 2, 3), 0, 0));
        this.panel1.add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.cancelButton, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.buttonPanel.add((Component)this.okButton, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 13, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.fieldPanel.add((Component)this.fileTextField, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(2, 2, 2, 3), 0, 0));
        this.fieldPanel.add((Component)this.commentTextField, new GridBagConstraints(1, 2, 1, 1, 0.5, 0.0, 10, 2, new Insets(2, 2, 2, 3), 0, 0));
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    void okButton_actionPerformed(ActionEvent e) {
        LibraryManager lm = this.owner.owner.getLibraryManager();
        File f = new File(this.fileTextField.getText());
        this.owner.owner.getGlobalStore().putString(LIB_DIRECTORY, f.getParentFile().getAbsolutePath());
        if (lm.storeLibrary(f, this.commentTextField.getText()) == null) {
            JOptionPane.showMessageDialog(this, "An error occured while loading the library!", "Error", 0);
        } else {
            this.dispose();
        }
    }
}

