/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.gui;

import aglobe.container.gui.AgentContainerGUI;
import aglobe.container.gui.ParamPanel;
import aglobe.container.library.LibraryManager;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.AglobeParam;
import aglobe.ontology.Libraries;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

class NewAgentDialog
extends JDialog {
    private AgentContainerGUI owner;
    private JPanel panel1 = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel fieldPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JButton cancelButton = new JButton();
    private JButton okButton = new JButton();
    private TitledBorder titledBorder1;
    private JLabel readablenameLabel = new JLabel();
    private JLabel typeLabel = new JLabel();
    private JLabel mainclassLabel = new JLabel();
    private JLabel librariesLabel = new JLabel();
    private JTextField readablenameValue = new JTextField();
    private boolean textField;
    private JTextField mainclassValue = new JTextField();
    private JComboBox mainclassCombo = new JComboBox();
    private ParamPanel paramPanel = new ParamPanel();
    private Border border1;
    private TitledBorder titledBorder2;
    private JScrollPane libScroll = new JScrollPane();
    private JList libList = new JList();
    private TitledBorder libBorder;

    NewAgentDialog(Frame frame, String title, boolean modal, AgentContainerGUI owner) {
        super(frame, title, modal);
        this.owner = owner;
        try {
            this.jbInit();
            LibraryManager.LibraryRecord[] libs = owner.owner.getLibraryManager().getLibraryList();
            this.libList.setListData(libs);
            this.libList.setVisibleRowCount(Math.min(libs.length, 4));
            List cls = owner.owner.getClassFinder().getAgentList();
            if (cls.size() != 0) {
                for (String item : cls) {
                    this.mainclassCombo.addItem(item);
                }
                this.mainclassLabel.setLabelFor(this.mainclassCombo);
                this.fieldPanel.add((Component)this.mainclassCombo, new GridBagConstraints(1, 2, 1, 1, 0.6, 0.0, 10, 2, new Insets(2, 4, 2, 4), 0, 0));
                this.textField = false;
            } else {
                this.mainclassLabel.setLabelFor(this.mainclassValue);
                this.fieldPanel.add((Component)this.mainclassValue, new GridBagConstraints(1, 2, 1, 1, 0.6, 0.0, 10, 2, new Insets(2, 4, 2, 4), 0, 0));
                this.textField = true;
            }
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    NewAgentDialog(Frame frame) {
        this(frame, "Create Agent", true, (AgentContainerGUI)frame);
    }

    NewAgentDialog(AgentContainerGUI owner) {
        this(null, "Create Agent", true, owner);
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "New agent properties");
        this.libBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Select libraries");
        this.border1 = new EtchedBorder(0, Color.white, new Color(165, 163, 151));
        this.titledBorder2 = new TitledBorder(this.border1, "Parameters");
        this.panel1.setLayout(this.borderLayout1);
        this.fieldPanel.setLayout(this.gridBagLayout1);
        this.buttonPanel.setLayout(this.gridBagLayout2);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewAgentDialog.this.cancelButton_actionPerformed(e);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewAgentDialog.this.okButton_actionPerformed(e);
            }
        });
        this.okButton.setPreferredSize(this.cancelButton.getPreferredSize());
        this.fieldPanel.setBorder(this.titledBorder1);
        this.readablenameLabel.setLabelFor(this.readablenameValue);
        this.readablenameLabel.setText("Name prefix:");
        this.typeLabel.setText("");
        this.mainclassLabel.setText("Main Class:");
        this.librariesLabel.setLabelFor(this.libScroll);
        this.librariesLabel.setText("Libraries:");
        this.paramPanel.setBorder(this.titledBorder2);
        this.readablenameValue.setColumns(20);
        this.libScroll.setBorder(this.libBorder);
        this.libScroll.getViewport().setView(this.libList);
        this.libList.setSelectionMode(2);
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.fieldPanel, "Center");
        this.fieldPanel.add((Component)this.readablenameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 2, 4), 0, 0));
        this.fieldPanel.add((Component)this.typeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 4, 2, 4), 0, 0));
        this.fieldPanel.add((Component)this.mainclassLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 4, 2, 4), 0, 0));
        this.fieldPanel.add((Component)this.librariesLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 4, 2, 4), 0, 0));
        this.fieldPanel.add((Component)this.readablenameValue, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(4, 4, 2, 4), 0, 0));
        this.fieldPanel.add((Component)this.libScroll, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.1, 10, 1, new Insets(2, 4, 2, 4), 0, 0));
        this.panel1.add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.cancelButton, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.buttonPanel.add((Component)this.okButton, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 13, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.fieldPanel.add((Component)this.paramPanel, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    void okButton_actionPerformed(ActionEvent e) {
        Object lib;
        int i;
        Object[] libs = this.libList.getSelectedValues();
        String mainClass = this.textField ? this.mainclassValue.getText() : (String)this.mainclassCombo.getSelectedItem();
        int separatorPosition = mainClass.indexOf(64);
        if (separatorPosition != -1) {
            String libId = mainClass.substring(separatorPosition + 1);
            mainClass = mainClass.substring(0, separatorPosition);
            boolean found = false;
            i = 0;
            while (i < libs.length) {
                lib = (LibraryManager.LibraryRecord)libs[i];
                if (((LibraryManager.LibraryRecord)lib).readableName.equalsIgnoreCase(libId)) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                JOptionPane.showMessageDialog(this, "The library with main class of an agent is not selected. Requested library: \"" + libId + "\"", "Error", 0);
                return;
            }
        }
        AgentInfo ai = new AgentInfo();
        ai.setReadableName(this.readablenameValue.getText());
        ai.setType("");
        ai.setMainClass(mainClass);
        Libraries l = new Libraries();
        i = 0;
        while (i < libs.length) {
            lib = ((LibraryManager.LibraryRecord)libs[i]).libInfo.getName();
            l.getLibrary().add((String)lib);
            ++i;
        }
        ai.setLibraries(l);
        AglobeParam[] p = this.paramPanel.getParams();
        int i2 = 0;
        while (i2 < p.length) {
            ai.getAglobeParam().add(p[i2]);
            ++i2;
        }
        try {
            this.owner.owner.getAgentManager().createAgent(ai, false);
            this.dispose();
        }
        catch (ClassNotFoundException ex1) {
            JOptionPane.showMessageDialog(this, "Class not found: \"" + (this.textField ? this.mainclassValue.getText() : (String)this.mainclassCombo.getSelectedItem()) + "\"", "Error", 0);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "An exception occured while loading the agent: \"" + ex.toString() + "\"", "Error", 0);
        }
    }
}

