/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.gui;

import aglobe.container.gui.AgentContainerGUI;
import aglobe.container.gui.InfoPanel;
import aglobe.container.library.LibraryException;
import aglobe.container.library.LibraryManager;
import aglobe.ontology.LibInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

class LibraryPanel
extends InfoPanel {
    private final AgentContainerGUI owner;
    private DefaultListModel lm = new DefaultListModel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JScrollPane contentScrollPane = new JScrollPane();
    private JPanel contentPanel = new JPanel();
    private GridBagLayout contentgridBagLayout = new GridBagLayout();
    private JLabel nameLabel = new JLabel();
    private JLabel versionLabel = new JLabel();
    private JLabel commentLabel = new JLabel();
    private JTextField nameValue = new JTextField();
    private JTextField versionValue = new JTextField();
    private JTextField commentValue = new JTextField();
    private JLabel usersLabel = new JLabel();
    private JScrollPane usersScrollPane = new JScrollPane();
    private JList usersList = new JList(this.lm);
    private JPanel buttonPanel = new JPanel();
    private JButton deleteButton = new JButton();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JButton refreshButton = new JButton();
    private JLabel emptyLabel = new JLabel();

    LibraryPanel(AgentContainerGUI owner) {
        this.owner = owner;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void setValues(String libname) {
        LibraryManager libMan = this.owner.owner.getLibraryManager();
        if (libname != null && libMan.exists(libname)) {
            LibInfo li = libMan.getLibInfo(libname);
            this.nameValue.setText(li.getName());
            this.versionValue.setText(li.getVersion());
            this.commentValue.setText(li.getComment());
            this.lm.clear();
            int pos = 0;
            for (LibInfo.LibUser usr : li.getLibUser()) {
                this.lm.add(pos++, new User(usr.getType(), usr.getName()));
            }
        } else {
            this.nameValue.setText("");
            this.versionValue.setText("");
            this.commentValue.setText("");
            this.lm.clear();
        }
    }

    private void jbInit() throws Exception {
        this.nameLabel.setText("Name: ");
        this.setLayout(this.gridBagLayout1);
        this.versionLabel.setText("Version:");
        this.commentLabel.setText("Comment:");
        this.nameValue.setEditable(false);
        this.nameValue.setColumns(30);
        this.versionValue.setEditable(false);
        this.versionValue.setColumns(30);
        this.commentValue.setEditable(false);
        this.commentValue.setColumns(30);
        this.usersLabel.setText("Users:");
        this.usersList.setSelectionMode(0);
        this.usersList.setVisibleRowCount(5);
        this.deleteButton.setText("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LibraryPanel.this.deleteButton_actionPerformed(e);
            }
        });
        this.buttonPanel.setLayout(this.gridBagLayout2);
        this.refreshButton.setText("Refresh");
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LibraryPanel.this.refreshButton_actionPerformed(e);
            }
        });
        this.contentPanel.setLayout(this.contentgridBagLayout);
        this.contentPanel.add((Component)this.nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 4, 2, 4), 0, 0));
        this.contentPanel.add((Component)this.versionLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 4, 2, 4), 0, 0));
        this.contentPanel.add((Component)this.commentLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 4, 2, 4), 0, 0));
        this.contentPanel.add((Component)this.nameValue, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 2, 2, 5), 0, 0));
        this.contentPanel.add((Component)this.versionValue, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 5), 0, 0));
        this.contentPanel.add((Component)this.commentValue, new GridBagConstraints(1, 2, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 5), 0, 0));
        this.contentPanel.add((Component)this.usersLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 4, 2, 4), 0, 0));
        this.contentPanel.add((Component)this.usersScrollPane, new GridBagConstraints(1, 3, 1, 1, 0.1, 0.0, 10, 1, new Insets(2, 2, 2, 5), 0, 0));
        this.contentPanel.add((Component)this.emptyLabel, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.contentScrollPane, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.5, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.buttonPanel.add((Component)this.deleteButton, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.refreshButton, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.usersScrollPane.getViewport().add((Component)this.usersList, null);
        this.contentScrollPane.getViewport().add((Component)this.contentPanel, null);
    }

    void deleteButton_actionPerformed(ActionEvent e) {
        if (this.lm.size() != 0) {
            JOptionPane.showMessageDialog(this, "The library is in use. Cannot be removed.", "Error", 0);
            return;
        }
        try {
            this.owner.owner.getLibraryManager().deleteLibrary(this.nameValue.getText());
        }
        catch (LibraryException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
        }
    }

    void refreshButton_actionPerformed(ActionEvent e) {
        this.setValues(this.nameValue.getText());
    }

    private class User {
        final String type;
        final String name;

        private User(String type, String name) {
            this.type = type;
            this.name = name;
        }

        public String toString() {
            if (this.type.equals("agent")) {
                return "A " + this.name;
            }
            return "S " + this.name;
        }
    }
}

