/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.gui;

import aglobe.container.gui.AgentContainerGUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

class Background
extends JPanel {
    private Icon bmpGrid = new ImageIcon(AgentContainerGUI.class.getResource("grid.png"));
    private Icon bmpBarMain = new ImageIcon(AgentContainerGUI.class.getResource("bar_main.png"));
    private Icon bmpBarExt = new ImageIcon(AgentContainerGUI.class.getResource("bar_ext.png"));

    Background() {
    }

    public void paintComponent(Graphics g) {
        this.drawGrid(g);
        this.drawBar(g);
    }

    private void drawGrid(Graphics g) {
        int panelWidth = this.getWidth();
        int panelHeight = this.getHeight();
        int gridWidth = this.bmpGrid.getIconWidth();
        int gridHeight = this.bmpGrid.getIconHeight();
        int countX = (int)Math.ceil((double)panelWidth / (double)gridWidth);
        int countY = (int)Math.ceil((double)panelHeight / (double)gridHeight);
        int y = 0;
        int j = 0;
        while (j < countY) {
            int x = 0;
            int i = 0;
            while (i < countX) {
                this.bmpGrid.paintIcon(this, g, x, y);
                x += gridWidth;
                ++i;
            }
            y += gridHeight;
            ++j;
        }
    }

    private void drawBar(Graphics g) {
        int panelWidth = this.getWidth();
        int panelHeight = this.getHeight();
        int barMainWidth = this.bmpBarMain.getIconWidth();
        int barMainHeight = this.bmpBarExt.getIconHeight();
        int barExtWidth = this.bmpBarExt.getIconWidth();
        int y = panelHeight - barMainHeight;
        if (y < 0) {
            y = 0;
        }
        this.bmpBarMain.paintIcon(this, g, 0, y);
        if (panelWidth > barMainWidth) {
            int barExtCount = (int)Math.ceil((double)(panelWidth - barMainWidth) / (double)barExtWidth);
            int x = barMainWidth;
            int i = 0;
            while (i < barExtCount) {
                this.bmpBarExt.paintIcon(this, g, x, y);
                x += barExtWidth;
                ++i;
            }
        }
        this.drawAglobeVersion(g, panelWidth - 30, y + 15);
    }

    private void drawAglobeVersion(Graphics g, int x, int y) {
        String version = "v4.1";
        g.setColor(Color.GRAY);
        g.setFont(new Font("Tahoma", 0, 11));
        g.drawString(version, x, y);
    }
}

