/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.gui;

import aglobe.container.gui.AgentContainerGUI;
import aglobe.container.gui.InfoPanel;
import aglobe.container.gui.UneditableTableModel;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.AglobeParam;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;

class AgentPanel
extends InfoPanel {
    private static final String[] HISTORYLABELS = new String[]{"Container", "Since", "Until"};
    private static final String[] PARAMLABELS = new String[]{"Name", "Value"};
    private final AgentContainerGUI owner;
    private DefaultTableModel historytm = new UneditableTableModel(HISTORYLABELS, 0);
    private DefaultTableModel paramtm = new UneditableTableModel(PARAMLABELS, 0);
    private DefaultListModel liblm = new DefaultListModel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JScrollPane contentScrollPane = new JScrollPane();
    private JPanel buttonPanel = new JPanel();
    private JPanel contentPanel = new JPanel();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JButton killButton = new JButton();
    private JButton hideButton = new JButton();
    private JButton showButton = new JButton();
    private JButton refreshButton = new JButton();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private JLabel nameLabel = new JLabel();
    private JLabel mainclassLabel = new JLabel();
    private JTextField nameValue = new JTextField();
    private JTextField mainclassValue = new JTextField();
    private JLabel librariesLabel = new JLabel();
    private JLabel parametersLabel = new JLabel();
    private JLabel historyLabel = new JLabel();
    private JScrollPane libraryScrollPane = new JScrollPane();
    private JList libraryList = new JList(this.liblm);
    private JScrollPane parametersScrollPane = new JScrollPane();
    private JScrollPane historyScrollPane = new JScrollPane();
    private JTable parametersTable = new JTable(this.paramtm);
    private JTable historyTable = new JTable(this.historytm);
    private JLabel jLabel1 = new JLabel();

    AgentPanel(AgentContainerGUI owner) {
        this.owner = owner;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void setValues(String name) {
        AgentInfo ai = this.owner.owner.getAgentManager().getAgentInfo(name);
        this.historytm = new DefaultTableModel(HISTORYLABELS, 0);
        this.historyTable.setModel(this.historytm);
        this.paramtm = new DefaultTableModel(PARAMLABELS, 0);
        this.parametersTable.setModel(this.paramtm);
        this.liblm.clear();
        if (ai != null) {
            this.nameValue.setText(ai.getName());
            this.mainclassValue.setText(ai.getMainClass());
            int pos = 0;
            for (String l : ai.getLibraries().getLibrary()) {
                this.liblm.add(pos++, l);
            }
            for (AglobeParam p : ai.getAglobeParam()) {
                this.paramtm.addRow(new Object[]{p.getName(), p.getValue()});
            }
            DateFormat df = DateFormat.getInstance();
            for (AgentInfo.TravelHistory he : ai.getTravelHistory()) {
                String start = he.getStart() != 0L ? df.format(new Date(he.getStart())) : "";
                String stop = he.getStop() != 0L ? df.format(new Date(he.getStop())) : "";
                this.historytm.addRow(new Object[]{he.getContainer(), start, stop});
            }
        } else {
            this.nameValue.setText("");
            this.mainclassValue.setText("");
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.buttonPanel.setLayout(this.gridBagLayout2);
        this.killButton.setText("Kill");
        this.killButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AgentPanel.this.killButton_actionPerformed(e);
            }
        });
        this.hideButton.setText("Hide");
        this.hideButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AgentPanel.this.hideButton_actionPerformed(e);
            }
        });
        this.showButton.setText("Show");
        this.showButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AgentPanel.this.showButton_actionPerformed(e);
            }
        });
        this.refreshButton.setText("Refresh");
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AgentPanel.this.refreshButton_actionPerformed(e);
            }
        });
        this.contentPanel.setLayout(this.gridBagLayout3);
        this.nameLabel.setText("Name:");
        this.mainclassLabel.setText("Main class:");
        this.nameValue.setEditable(false);
        this.nameValue.setColumns(30);
        this.mainclassValue.setEditable(false);
        this.mainclassValue.setColumns(30);
        this.librariesLabel.setText("Libraries:");
        this.parametersLabel.setText("Parameters:");
        this.historyLabel.setText("Travel history:");
        this.libraryList.setVisibleRowCount(4);
        this.historyScrollPane.getViewport().add((Component)this.historyTable, null);
        this.parametersScrollPane.getViewport().add((Component)this.parametersTable, null);
        this.libraryScrollPane.getViewport().add((Component)this.libraryList, null);
        this.contentScrollPane.getViewport().add((Component)this.contentPanel, null);
        this.add((Component)this.contentScrollPane, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 11, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.buttonPanel.add((Component)this.killButton, new GridBagConstraints(3, 0, 1, 1, 0.1, 0.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.hideButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 2, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.showButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 0, 2), 0, 0));
        this.buttonPanel.add((Component)this.refreshButton, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.contentPanel.add((Component)this.nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 2, 4), 0, 0));
        this.contentPanel.add((Component)this.mainclassLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 4), 0, 0));
        this.contentPanel.add((Component)this.nameValue, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 2, 5), 0, 0));
        this.contentPanel.add((Component)this.mainclassValue, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.contentPanel.add((Component)this.librariesLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 4), 0, 0));
        this.contentPanel.add((Component)this.parametersLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 4), 0, 0));
        this.contentPanel.add((Component)this.historyLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 4), 0, 0));
        this.contentPanel.add((Component)this.libraryScrollPane, new GridBagConstraints(1, 3, 1, 1, 0.1, 0.0, 18, 2, new Insets(2, 2, 2, 5), 0, 0));
        this.contentPanel.add((Component)this.parametersScrollPane, new GridBagConstraints(1, 4, 1, 1, 0.1, 0.0, 18, 2, new Insets(2, 2, 2, 5), 0, 0));
        this.contentPanel.add((Component)this.historyScrollPane, new GridBagConstraints(1, 5, 1, 1, 0.1, 0.0, 18, 2, new Insets(2, 2, 2, 5), 0, 0));
        this.contentPanel.add((Component)this.jLabel1, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.1, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        Dimension d = this.nameValue.getPreferredSize();
        d.height = this.parametersTable.getRowHeight() * 3;
        this.parametersTable.setPreferredScrollableViewportSize(d);
        d.height = this.historyTable.getRowHeight() * 4;
        this.historyTable.setPreferredScrollableViewportSize(d);
    }

    void refreshButton_actionPerformed(ActionEvent e) {
        this.setValues(this.nameValue.getText());
    }

    void showButton_actionPerformed(ActionEvent e) {
        this.owner.owner.getAgentManager().showAgent(this.nameValue.getText());
    }

    void hideButton_actionPerformed(ActionEvent e) {
        this.owner.owner.getAgentManager().hideAgent(this.nameValue.getText());
    }

    void killButton_actionPerformed(ActionEvent e) {
        String an = this.nameValue.getText();
        int res = JOptionPane.showConfirmDialog(this, "Really kill the agent " + an, "Kill Agent", 0);
        if (res != 0) {
            return;
        }
        this.owner.owner.getAgentManager().killAgent(an);
    }
}

