/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.gui;

import aglobe.container.gui.AgentContainerGUI;
import aglobe.container.gui.ListListener;
import aglobe.container.transport.Address;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AgentContainerTreeModel
implements TreeModel,
ListListener {
    private String ROOT = "Root";
    private final List<Object> ROOTCHILDREN = new ArrayList<Object>(4);
    private final AgentContainerGUI owner;
    List<TreeModelListener> listeners = new LinkedList<TreeModelListener>();
    List<String> agents = new ArrayList<String>();
    List<String> services = new ArrayList<String>();
    List<String> libraries = new ArrayList<String>();

    AgentContainerTreeModel(AgentContainerGUI owner) {
        this.owner = owner;
        this.ROOTCHILDREN.add(Address.getLocalContainerAddress(owner.owner).toString());
        this.ROOTCHILDREN.add(AGENTS);
        this.ROOTCHILDREN.add(SERVICES);
        this.ROOTCHILDREN.add(LIBRARIES);
        if (owner.owner.getAgentManager() != null) {
            owner.owner.getAgentManager().addListListener(this);
        }
        if (owner.owner.getServiceManager() != null) {
            owner.owner.getServiceManager().addListListener(this);
        }
        if (owner.owner.getLibraryManager() != null) {
            owner.owner.getLibraryManager().addListListener(this);
        }
        if (owner.owner.getContainerName() != null) {
            this.ROOT = owner.owner.getContainerName();
        }
    }

    @Override
    public Object getRoot() {
        return this.ROOT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getChild(Object parent, int index) {
        if (parent == this.ROOT) {
            return this.ROOTCHILDREN.get(index);
        }
        if (parent == AGENTS) {
            List<String> list = this.agents;
            synchronized (list) {
                return this.agents.get(index);
            }
        }
        if (parent == SERVICES) {
            List<String> list = this.services;
            synchronized (list) {
                return this.services.get(index);
            }
        }
        if (parent == LIBRARIES) {
            return this.libraries.get(index);
        }
        throw new IllegalArgumentException("Bad parent passed to ContainerTreeModel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChildCount(Object parent) {
        if (parent == this.ROOT) {
            return this.ROOTCHILDREN.size();
        }
        if (parent == AGENTS) {
            List<String> list = this.agents;
            synchronized (list) {
                return this.agents.size();
            }
        }
        if (parent == SERVICES) {
            List<String> list = this.services;
            synchronized (list) {
                return this.services.size();
            }
        }
        if (parent == LIBRARIES) {
            return this.libraries.size();
        }
        throw new IllegalArgumentException("Bad parent passed to ContainerTreeModel");
    }

    @Override
    public boolean isLeaf(Object node) {
        return node != this.ROOT && node != AGENTS && node != SERVICES && node != LIBRARIES;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException("Method ContainerTreeModel.valueForPathChanged should have never been called.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.ROOT) {
            return this.ROOTCHILDREN.indexOf(child);
        }
        if (parent == AGENTS) {
            List<String> list = this.agents;
            synchronized (list) {
                return this.agents.indexOf(child);
            }
        }
        if (parent == SERVICES) {
            List<String> list = this.services;
            synchronized (list) {
                return this.services.indexOf(child);
            }
        }
        if (parent == LIBRARIES) {
            return this.libraries.indexOf(child);
        }
        throw new IllegalArgumentException("Bad parent passed to ContainerTreeModel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTreeModelListener(TreeModelListener l) {
        List<TreeModelListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        List<TreeModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    @Override
    public void ValueChanged(ListListener.ListType where, Object what) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ListChanged(final ListListener.ListType which, Set<String> values) {
        if (which == AGENTS) {
            List<String> list = this.agents;
            synchronized (list) {
                this.agents.clear();
                this.agents.addAll(values);
            }
        } else if (which == SERVICES) {
            List<String> list = this.services;
            synchronized (list) {
                this.services.clear();
                this.services.addAll(values);
            }
        } else if (which == LIBRARIES) {
            this.libraries.clear();
            this.libraries.addAll(values);
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{AgentContainerTreeModel.this.ROOT, which});
                List<TreeModelListener> list = AgentContainerTreeModel.this.listeners;
                synchronized (list) {
                    Iterator<TreeModelListener> i = AgentContainerTreeModel.this.listeners.iterator();
                    while (i.hasNext()) {
                        i.next().treeStructureChanged(e);
                    }
                }
            }
        });
    }
}

