/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.gui;

import aglobe.container.AgentContainer;
import aglobe.container.Store;
import aglobe.container.StoreOwner;
import aglobe.container.gui.Actions;
import aglobe.container.gui.AgentContainerTreeModel;
import aglobe.container.gui.AgentPanel;
import aglobe.container.gui.Background;
import aglobe.container.gui.InfoPanel;
import aglobe.container.gui.LibraryPanel;
import aglobe.container.gui.ListListener;
import aglobe.container.gui.NewAgentDialog;
import aglobe.container.gui.NewLibraryDialog;
import aglobe.container.gui.NewServiceDialog;
import aglobe.container.gui.ServicePanel;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Command;
import aglobe.ontology.Libraries;
import aglobe.service.gis.server.GISServerService;
import aglobe.service.link.LinkService;
import aglobe.util.GUIUtils;
import aglobe.util.gui.RememberPositionJFrame;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;

public class AgentContainerGUI
extends RememberPositionJFrame {
    private static final String EMPTY = "EMPTY";
    private static final String AGENT = "AGENT";
    private static final String SERVICE = "SERVICE";
    private static final String LIBRARY = "LIBRARY";
    final AgentContainer owner;
    private Action exitAction = new Actions.ExitAction(this);
    private Action loadLibraryAction = new Actions.LoadLibraryAction(this);
    private Action loadAgentAction = new Actions.LoadAgentAction(this);
    private Action loadServicetAction = new Actions.LoadServiceAction(this);
    private Action startESMatrixServerAction = new Actions.StartESMatrixServerAction(this);
    private Action startSnifferAction = new Actions.StartSnifferAction(this);
    private Action startComAnalyzerAction = new Actions.StartComAnalyzerAction(this);
    private Action startLoggerAction = new Actions.StartLoggerAction(this);
    private TreeModel containerTreeModel1;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JMenuBar jMenuBar1 = new JMenuBar();
    private JToolBar jToolBar1 = new JToolBar();
    private JPanel treePanel = new JPanel();
    private JSplitPane jSplitPane1 = new JSplitPane();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JPanel infoPanel = new JPanel();
    private CardLayout cardLayout1 = new CardLayout();
    private JTree jTree1 = new JTree();
    private JMenu fileMenu = new JMenu();
    private JMenuItem exitMenuItem = new JMenuItem();
    private JMenuItem loadLibraryMenuItem = new JMenuItem();
    private JMenuItem loadServiceMenuItem = new JMenuItem();
    private JMenuItem loadAgentMenuItem = new JMenuItem();
    private JMenu esMenu = new JMenu();
    private JMenuItem startESMatrixServerMenuItem = new JMenuItem();
    private JMenu tools = new JMenu();
    private JMenuItem startSnifferMenuItem = new JMenuItem();
    private JMenuItem startComAnalyzerMenuItem = new JMenuItem();
    private JMenuItem startLoggerMenuItem = new JMenuItem();
    private JLabel emptyLabel = new JLabel();
    private Background emptyPanel = new Background();
    private InfoPanel libraryPanel = new LibraryPanel(this);
    private InfoPanel servicePanel = new ServicePanel(this);
    private InfoPanel agentPanel = new AgentPanel(this);
    private Icon logoIcon = new ImageIcon(AgentContainerGUI.class.getResource("logo.png"));
    private Icon logoIcon2 = new ImageIcon(AgentContainerGUI.class.getResource("logo2.png"));
    private GISServerService.Shell gisServer = null;
    private LinkService.Shell link = null;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel logoLabel = new JLabel();
    JLabel logoLabel2 = new JLabel();
    JLabel aglobeLabel = new JLabel();
    JLabel aglobeVer = new JLabel();

    public AgentContainerGUI(final AgentContainer owner) {
        super(new StoreOwner(){

            public Store getStore() {
                return owner.getGlobalStore();
            }
        });
        this.owner = owner;
        this.containerTreeModel1 = new AgentContainerTreeModel(this);
        this.gisServer = (GISServerService.Shell)owner.getServiceManager().getService(null, "gis/master");
        this.link = (LinkService.Shell)owner.getServiceManager().getService(null, "container/link");
        try {
            this.jbInit();
            this.setTitle(owner.getContainerName());
            this.jSplitPane1.setDividerLocation(150);
            this.setSize(400, 300);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void saveWindowSettings() {
        this.store.putInt("gui/divider", this.jSplitPane1.getDividerLocation());
    }

    protected void loadWindowSettings() {
        int divPos = this.jSplitPane1.getDividerLocation();
        this.jSplitPane1.setDividerLocation(this.store.getInt("gui/divider", divPos));
    }

    private void jbInit() throws Exception {
        this.setJMenuBar(this.jMenuBar1);
        this.getContentPane().setLayout(this.borderLayout1);
        this.treePanel.setLayout(this.borderLayout2);
        this.infoPanel.setLayout(this.cardLayout1);
        this.jTree1.setModel(this.containerTreeModel1);
        this.jTree1.getSelectionModel().setSelectionMode(1);
        this.jTree1.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                AgentContainerGUI.this.treeSelectionChanged(e);
            }
        });
        this.fileMenu.setMnemonic('F');
        this.fileMenu.setText("File");
        this.loadAgentMenuItem.setAction(this.loadAgentAction);
        this.loadServiceMenuItem.setAction(this.loadServicetAction);
        this.loadLibraryMenuItem.setAction(this.loadLibraryAction);
        this.exitMenuItem.setAction(this.exitAction);
        this.emptyLabel.setHorizontalAlignment(0);
        this.emptyLabel.setHorizontalTextPosition(0);
        this.emptyLabel.setText("No object selected");
        this.emptyPanel.setLayout(this.gridBagLayout1);
        this.aglobeLabel.setFont(new Font("SansSerif", 1, 20));
        this.aglobeLabel.setHorizontalAlignment(0);
        this.aglobeLabel.setHorizontalTextPosition(0);
        this.aglobeLabel.setText("A-globe");
        this.aglobeVer.setFont(new Font("Tahoma", 1, 11));
        this.aglobeVer.setHorizontalAlignment(0);
        this.aglobeVer.setHorizontalTextPosition(0);
        this.aglobeVer.setText("ver. 4.1");
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.getContentPane().add((Component)this.treePanel, "Center");
        this.treePanel.add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.setDividerSize(3);
        this.jSplitPane1.add((Component)this.jScrollPane1, "left");
        this.jScrollPane1.getViewport().add((Component)this.jTree1, null);
        this.jSplitPane1.add((Component)this.infoPanel, "right");
        this.jMenuBar1.add(this.fileMenu);
        this.fileMenu.add(this.loadAgentMenuItem);
        this.fileMenu.add(this.loadServiceMenuItem);
        this.fileMenu.add(this.loadLibraryMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitMenuItem);
        this.infoPanel.add((Component)this.emptyPanel, EMPTY);
        this.infoPanel.add((Component)this.libraryPanel, LIBRARY);
        this.infoPanel.add((Component)this.servicePanel, SERVICE);
        this.infoPanel.add((Component)this.agentPanel, AGENT);
        this.logoLabel.setIcon(this.logoIcon);
        this.logoLabel2.setIcon(this.logoIcon2);
        this.esMenu.setText("Environment Simulator");
        this.esMenu.setMnemonic('E');
        this.startESMatrixServerMenuItem.setAction(this.startESMatrixServerAction);
        this.esMenu.add(this.startESMatrixServerMenuItem);
        this.tools.setText("Tools");
        this.tools.setMnemonic('T');
        this.startSnifferMenuItem.setAction(this.startSnifferAction);
        this.startComAnalyzerMenuItem.setAction(this.startComAnalyzerAction);
        this.startLoggerMenuItem.setAction(this.startLoggerAction);
        this.tools.add(this.startSnifferMenuItem);
        this.tools.add(this.startComAnalyzerMenuItem);
        if (this.link == null) {
            this.tools.add(this.startLoggerMenuItem);
        }
        if (this.gisServer != null) {
            this.jMenuBar1.add(this.esMenu);
            this.jMenuBar1.add(this.tools);
        }
        if (this.link != null) {
            this.jMenuBar1.add(this.tools);
        }
    }

    void Quit() {
        int res = JOptionPane.showConfirmDialog(this, "Are you sure to shut down the Agent Container?", "Shutdown agent container", 0);
        if (res != 0) {
            return;
        }
        AgentContainer.CommandService.Shell s = (AgentContainer.CommandService.Shell)this.owner.getServiceManager().getService(null, "container/command");
        Command c = new Command();
        c.setName("QUIT");
        s.execute(c);
    }

    void LoadLibrary() {
        NewLibraryDialog nld = new NewLibraryDialog(this);
        GUIUtils.centerOnScreen(nld);
        nld.setVisible(true);
    }

    void LoadAgent() {
        NewAgentDialog nad = new NewAgentDialog(this);
        GUIUtils.centerOnScreen(nad);
        nad.setVisible(true);
    }

    void LoadService() {
        NewServiceDialog nsd = new NewServiceDialog(this);
        GUIUtils.centerOnScreen(nsd);
        nsd.setVisible(true);
    }

    private void treeSelectionChanged(TreeSelectionEvent e) {
        try {
            Object o = e.getNewLeadSelectionPath().getParentPath().getLastPathComponent();
            String s = (String)e.getNewLeadSelectionPath().getLastPathComponent();
            if (o == ListListener.AGENTS) {
                this.agentPanel.setValues(s);
                this.showInfo(AGENT);
            } else if (o == ListListener.SERVICES) {
                this.servicePanel.setValues(s);
                this.showInfo(SERVICE);
            } else if (o == ListListener.LIBRARIES) {
                this.libraryPanel.setValues(s);
                this.showInfo(LIBRARY);
            }
            return;
        }
        catch (Exception exception) {
            this.showInfo(EMPTY);
            return;
        }
    }

    private void showInfo(String page) {
        ((CardLayout)this.infoPanel.getLayout()).show(this.infoPanel, page);
    }

    void startESMatrixServer() {
        if (this.gisServer == null) {
            return;
        }
        AgentInfo ai = new AgentInfo();
        ai.setName("MatrixESAgent");
        ai.setReadableName("MatrixESAgent");
        ai.setType("EnvironmentSimulator");
        ai.setMainClass("aglobe.agent.matrixes.MatrixESAgent");
        Libraries l = new Libraries();
        ai.setLibraries(l);
        try {
            this.owner.getAgentManager().createAgent(ai, false);
        }
        catch (ClassNotFoundException ex1) {
            JOptionPane.showMessageDialog(this, "Class not found: \"aglobe.agent.matrixes.MatrixESAgent\"", "Error", 0);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "An exception occured while loading the agent: \"" + ex.toString() + "\"", "Error", 0);
        }
    }

    void startSniffer() {
        if (this.gisServer == null && this.link == null) {
            return;
        }
        AgentInfo ai = new AgentInfo();
        ai.setName("Sniffer");
        ai.setReadableName("Sniffer");
        ai.setType("Sniffer");
        ai.setMainClass("aglobe.agent.sniffer.SnifferAgent");
        Libraries l = new Libraries();
        ai.setLibraries(l);
        try {
            this.owner.getAgentManager().createAgent(ai, false);
        }
        catch (ClassNotFoundException ex1) {
            JOptionPane.showMessageDialog(this, "Class not found: \"aglobe.agent.sniffer.SnifferAgent\"", "Error", 0);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "An exception occured while loading the agent: \"" + ex.toString() + "\"", "Error", 0);
        }
    }

    void startComAnalyzer() {
        if (this.gisServer == null && this.link == null) {
            return;
        }
        AgentInfo ai = new AgentInfo();
        ai.setName("ComAnalyzer");
        ai.setReadableName("ComAnalyzer");
        ai.setType("ComAnalyzer");
        ai.setMainClass("aglobe.agent.comanalyzer.ComAnalyzerAgent");
        Libraries l = new Libraries();
        ai.setLibraries(l);
        try {
            this.owner.getAgentManager().createAgent(ai, false);
        }
        catch (ClassNotFoundException ex1) {
            JOptionPane.showMessageDialog(this, "Class not found: \"aglobe.agent.comanalyzer.ComAnalyzerAgent\"", "Error", 0);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "An exception occured while loading the agent: \"" + ex.toString() + "\"", "Error", 0);
        }
    }

    void startLogger() {
        if (this.gisServer == null) {
            return;
        }
        AgentInfo ai = new AgentInfo();
        ai.setName("Logger");
        ai.setReadableName("Logger");
        ai.setType("Logger");
        ai.setMainClass("aglobe.agent.logger.LoggerAgent");
        Libraries l = new Libraries();
        ai.setLibraries(l);
        try {
            this.owner.getAgentManager().createAgent(ai, false);
        }
        catch (ClassNotFoundException ex1) {
            JOptionPane.showMessageDialog(this, "Class not found: \"aglobe.agent.logger.LoggerAgent\"", "Error", 0);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "An exception occured while loading the agent: \"" + ex.toString() + "\"", "Error", 0);
        }
    }
}

