/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.agent;

import aglobe.container.AgentContainer;
import aglobe.container.DuplicateNameException;
import aglobe.container.MessageReceiver;
import aglobe.container.RecepientNotFound;
import aglobe.container.Store;
import aglobe.container.agent.Agent;
import aglobe.container.agent.AgentFilter;
import aglobe.container.agent.AgentRunner;
import aglobe.container.gui.ListListener;
import aglobe.container.gui.ListSource;
import aglobe.container.library.LibraryManager;
import aglobe.container.library.LibraryObjectInputStream;
import aglobe.container.library.LibraryRequesterCallback;
import aglobe.container.sysservice.AgentMoverCallback;
import aglobe.container.sysservice.AgentMoverService;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.AgentList;
import aglobe.ontology.AglobeParam;
import aglobe.ontology.Libraries;
import aglobe.ontology.Message;
import aglobe.platform.thread.AglobeThreadPool;
import aglobe.platform.transport.CloneBuffer;
import aglobe.util.AglobeXMLtools;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AgentManager
implements MessageReceiver,
ListSource,
AgentMoverCallback {
    private static final String AUTORUN = "agents/autorun.xml";
    private static final String AGENTCNT = "agents/cnt";
    public static final String AGENTTHREAD = "Agents";
    public static final String MAIN_AGENT_THREAD_NAME = "main agent thread";
    private final AgentContainer container;
    private Logger logger = Logger.getLogger("container.AgentManager");
    final Object lock = new Object();
    private Map<String, Agent> agentMap = new TreeMap<String, Agent>();
    private Map<String, ThreadGroup> agentThreadGroupMap = new TreeMap<String, ThreadGroup>();
    private boolean managerShutDown = false;
    AgentList agentList = null;
    private ThreadGroup agentThreads = null;
    ListListener listListener = null;
    AgentMoverService moverservice = null;
    boolean libraryWait = false;
    boolean libraryFailed = false;
    Object libraryWaitLock = new Object();

    public void afterContainerInit(boolean masterContainer, AgentList agentList, boolean noMigration, Address librarySourceContainer) {
        this.initAgents(agentList, librarySourceContainer);
        try {
            if (!masterContainer && !noMigration) {
                this.moverservice = new AgentMoverService();
                this.container.getServiceManager().startService("agent/mover", this.moverservice);
            }
        }
        catch (DuplicateNameException ex) {
            this.logger.severe("Cannot start AgentMoverService: " + ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAgentManager(int timeout) {
        this.managerShutDown = true;
        Object object = this.lock;
        synchronized (object) {
            Iterator<Agent> i = this.agentMap.values().iterator();
            while (i.hasNext()) {
                AgentManager.stopAgent(i.next());
            }
        }
        int lastRunning = -1;
        Object object2 = this.lock;
        synchronized (object2) {
            int curRunning = this.agentMap.size();
            while (curRunning > 0 && curRunning != lastRunning) {
                lastRunning = curRunning;
                try {
                    this.lock.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                curRunning = this.agentMap.size();
            }
        }
    }

    public AgentManager(AgentContainer owner) {
        this.container = owner;
        this.agentThreads = new ThreadGroup(this.container.getContainerThreadGroup(), AGENTTHREAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initAgents(AgentList startAgents, Address librarySourceContainer) {
        Store s = this.container.getGlobalStore();
        try {
            Object object = this.lock;
            synchronized (object) {
                boolean checkLibrary = false;
                boolean saveChanges = false;
                if (startAgents == null) {
                    if (s.exist(AUTORUN)) {
                        this.agentList = (AgentList)s.getXML(AUTORUN, AgentList.class);
                    } else {
                        this.logger.fine("Creating empty agent list...");
                        this.agentList = new AgentList();
                    }
                } else {
                    checkLibrary = true;
                    this.logger.fine("Agent list read from starting params...");
                    this.agentList = startAgents;
                }
                LibraryManager lm = this.container.getLibraryManager();
                this.libraryFailed = false;
                LinkedList<AgentInfo> ai = new LinkedList<AgentInfo>(this.agentList.getAgentInfo());
                LinkedList<AgentInfo> newAgentList = new LinkedList<AgentInfo>();
                for (AgentInfo item : ai) {
                    if (checkLibrary && item.getLibraries().getLibrary().size() > 0) {
                        if (librarySourceContainer == null) {
                            this.logger.severe("Libary source container is not specified.");
                            throw new Exception("Library source container is not specified.");
                        }
                        for (String item2 : item.getLibraries().getLibrary()) {
                            Object object2 = this.libraryWaitLock;
                            synchronized (object2) {
                                this.libraryWait = true;
                                lm.obtainLibrary(this.container, librarySourceContainer, item2, new LibraryRequesterCallback(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void libraryRequestFinished(LibraryRequesterCallback.Result result) {
                                        Object object = AgentManager.this.libraryWaitLock;
                                        synchronized (object) {
                                            if (result == LibraryRequesterCallback.FAILED) {
                                                AgentManager.this.libraryFailed = true;
                                            }
                                            AgentManager.this.libraryWait = false;
                                            AgentManager.this.libraryWaitLock.notify();
                                        }
                                    }
                                });
                                while (this.libraryWait) {
                                    try {
                                        this.libraryWaitLock.wait();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    if (!this.libraryFailed) continue;
                                    this.logger.severe("Library: " + item + " cannot be loaded from: " + librarySourceContainer);
                                    throw new Exception("Library: " + item + " cannot be loaded from: " + librarySourceContainer);
                                }
                            }
                        }
                    }
                    try {
                        newAgentList.add(item);
                        this.startAgent(item, 2);
                    }
                    catch (Exception ex1) {
                        saveChanges = true;
                        this.logger.severe("Cannot restart the agent: " + item.getName() + " (" + ex1 + ")\nThe agent has been removed from autostart configuration.");
                    }
                }
                this.agentList.getAgentInfo().clear();
                this.agentList.getAgentInfo().addAll(newAgentList);
                if (saveChanges) {
                    s.putXML(AUTORUN, this.agentList);
                }
                this.fireAgentListChanged();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.severe("Cannot start the default agents on container " + this.container.getContainerName() + "! " + ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAgent(final AgentInfo ai, int requestedInitState) throws ClassNotFoundException, DuplicateNameException, Exception {
        Object object = this.lock;
        synchronized (object) {
            LibraryManager lm = this.container.getLibraryManager();
            if (this.agentMap.containsKey(ai.getName())) {
                throw new DuplicateNameException(ai.getName());
            }
            try {
                int initState;
                Agent agent;
                List<String> libs = ai.getLibraries().getLibrary();
                ClassLoader classLoader = lm.registerAgent(ai.getName(), libs.toArray(new String[libs.size()]));
                if (ai.getSerialized() == null) {
                    Class<?> cl = classLoader.loadClass(ai.getMainClass());
                    Constructor<?> con = cl.getConstructor(new Class[0]);
                    agent = (Agent)con.newInstance(new Object[0]);
                    initState = requestedInitState;
                } else {
                    LibraryObjectInputStream in = new LibraryObjectInputStream((InputStream)new ByteArrayInputStream(ai.getSerialized()), classLoader);
                    agent = (Agent)in.readObject();
                    ai.setSerialized(null);
                    initState = agent.getState() == 7 ? 5 : 3;
                    agent.moveFinished();
                }
                lm.registerClassOwner(agent, classLoader);
                agent.setContainer(this.container);
                agent.addEvent(new Runnable(){

                    public void run() {
                        agent.sysInit(ai, initState);
                        agent.init(ai, initState);
                    }
                });
                this.agentMap.put(ai.getName(), agent);
                ThreadGroup atg = new ThreadGroup(this.agentThreads, ai.getName());
                this.agentThreadGroupMap.put(ai.getName(), atg);
                AglobeThreadPool.startInNewThread(atg, new AgentRunner(agent, atg), String.valueOf(this.container.getContainerName()) + ": " + ai.getName() + ": " + MAIN_AGENT_THREAD_NAME);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.logger.severe("Error loading agent: " + ex);
                this.deleteAgent(ai.getName(), true);
                throw ex;
            }
        }
    }

    void cloneAgent(Agent agent, String newName, AgentMoverCallback callback) {
        if (agent.getMigrationDest().isSameContainer(Address.getLocalContainerAddress(this.container))) {
            callback.agentMoveFinished(AgentMoverCallback.FAILED, agent);
        }
        try {
            AgentInfo ai = this.getAgentInfo(agent.getName());
            ai.setName(newName);
            ai.setReadableName(newName);
            CloneBuffer buf = new CloneBuffer();
            buf.getOutputStream().writeObject(agent);
            buf.getOutputStream().flush();
            byte[] binaryAgent = new byte[buf.getDataSize()];
            System.arraycopy(buf.array(), 0, binaryAgent, 0, binaryAgent.length);
            ai.setSerialized(binaryAgent);
            Store s = this.container.getAgentStore(agent.getName());
            buf.reset();
            s.zip(buf.getOutputStream());
            if (buf.getDataSize() > 4) {
                byte[] store = new byte[buf.getDataSize() - 4];
                System.arraycopy(buf.array(), 4, store, 0, store.length);
                ai.setData(store);
            }
            AgentInfo.TravelHistory t = ai.getTravelHistory().get(ai.getTravelHistory().size() - 1);
            t.setStop(System.currentTimeMillis());
            this.moverservice.moveAgent(agent, ai, callback, agent);
        }
        catch (IOException ex) {
            callback.agentMoveFinished(AgentMoverCallback.FAILED, agent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void agentFinished(final Agent agent) {
        switch (agent.getState()) {
            case 2: {
                this.logger.warning(String.valueOf(this.container.getContainerName()) + ": A running agent has finished!");
                break;
            }
            case 8: {
                this.logger.severe(String.valueOf(this.container.getContainerName()) + ": Agent " + agent.getName() + " has been removed because it throws an exception !");
                this.deleteAgent(agent.getName(), false);
                break;
            }
            case 3: {
                this.deleteAgent(agent.getName(), false);
                break;
            }
            case 6: {
                this.deleteAgent(agent.getName(), true);
                break;
            }
            case 4: {
                try {
                    int i;
                    Object object = this.lock;
                    synchronized (object) {
                        this.agentMap.remove(agent.getName());
                        this.agentThreadGroupMap.remove(agent.getName());
                    }
                    if (agent.getMigrationDest().isSameContainer(Address.getLocalContainerAddress(this.container))) {
                        throw new Exception("Cannot migrate to the current container");
                    }
                    AgentInfo ai = null;
                    Object object2 = this.lock;
                    synchronized (object2) {
                        int i2 = this.agentList.getAgentInfo().indexOf(AgentFilter.getNameFilter(agent.getName()));
                        ai = (AgentInfo)AglobeXMLtools.cloneSerializable(this.agentList.getAgentInfo().get(i2));
                    }
                    CloneBuffer buf = new CloneBuffer();
                    buf.getOutputStream().writeObject(agent);
                    buf.getOutputStream().flush();
                    byte[] binary = new byte[buf.getDataSize()];
                    System.arraycopy(buf.array(), 0, binary, 0, binary.length);
                    ai.setSerialized(binary);
                    Store s = this.container.getAgentStore(agent.getName());
                    buf.reset();
                    s.zip(buf.getOutputStream());
                    if (buf.getDataSize() > 4) {
                        binary = new byte[buf.getDataSize() - 4];
                        System.arraycopy(buf.array(), 4, binary, 0, binary.length);
                        ai.setData(binary);
                    }
                    if ((i = ai.getTravelHistory().size()) > 0) {
                        AgentInfo.TravelHistory t = ai.getTravelHistory().get(i - 1);
                        t.setStop(System.currentTimeMillis());
                    }
                    this.moverservice.moveAgent(agent, ai, this, null);
                }
                catch (Exception ex) {
                    final AgentInfo ai = this.getInternalAgentInfo(agent.getName());
                    this.logger.severe(String.valueOf(this.container.getContainerName()) + ": Exception migrating Agent" + ex);
                    if (ai == null) {
                        throw new RuntimeException("FATAL: AgentInfo not found!");
                    }
                    try {
                        agent.setContainer(this.container);
                        agent.addEvent(new Runnable(){

                            public void run() {
                                agent.sysInit(ai, 4);
                                agent.init(ai, 4);
                            }
                        });
                        Object binary = this.lock;
                        synchronized (binary) {
                            this.agentMap.put(ai.getName(), agent);
                        }
                        ThreadGroup atg = new ThreadGroup(this.agentThreads, ai.getName());
                        Object object = this.lock;
                        synchronized (object) {
                            this.agentThreadGroupMap.put(ai.getName(), atg);
                        }
                        AglobeThreadPool.startInNewThread(atg, new AgentRunner(agent, atg), String.valueOf(this.container.getContainerName()) + ": " + ai.getName() + ": " + MAIN_AGENT_THREAD_NAME);
                    }
                    catch (Exception ex1) {
                        this.logger.severe(String.valueOf(this.container.getContainerName()) + ": Cannot start agent " + ai.getName() + "\n" + ex1.toString());
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("Bad agent state");
            }
        }
        this.fireAgentListChanged();
    }

    public void createAgent(String readableName, String mainClass, List params) throws DuplicateNameException, Exception {
        AgentInfo ai = new AgentInfo();
        ai.setReadableName(readableName);
        ai.setMainClass(mainClass);
        for (AglobeParam item : params) {
            ai.getAglobeParam().add(item);
        }
        ai.setLibraries(new Libraries());
        this.createAgent(ai, false);
    }

    public void createAgent(AgentInfo agentInfo) throws DuplicateNameException, Exception {
        this.createAgent(agentInfo, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAgent(AgentInfo agentInfo, boolean cloneAgentInfo) throws DuplicateNameException, Exception {
        Object object = this.lock;
        synchronized (object) {
            AgentInfo ai = cloneAgentInfo ? (AgentInfo)AglobeXMLtools.cloneSerializable(agentInfo) : agentInfo;
            if (ai.getName() == null) {
                ai.setName(String.valueOf(ai.getReadableName().replace(' ', '_')) + "-" + this.createUniqueAgentName());
            }
            if (this.agentMap.containsKey(ai.getName())) {
                throw new DuplicateNameException(ai.getName());
            }
            if (ai.getData() != null) {
                Store s = this.container.getAgentStore(ai.getName());
                s.unZip(new ByteArrayInputStream(ai.getData()));
                ai.setData(null);
            }
            AgentInfo.TravelHistory t = new AgentInfo.TravelHistory();
            t.setContainer(Address.getLocalContainerAddress(this.container).toString());
            t.setStart(System.currentTimeMillis());
            t.setStop(0L);
            ai.getTravelHistory().add(t);
            this.startAgent(ai, 1);
            this.agentList.getAgentInfo().add(ai);
            Store s = this.container.getGlobalStore();
            s.putXML(AUTORUN, this.agentList);
            this.fireAgentListChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Agent getAgentInstance(String agentName) {
        Object object = this.lock;
        synchronized (object) {
            return this.agentMap.get(agentName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadGroup getAgentThreadGroup(String agentName) {
        Object object = this.lock;
        synchronized (object) {
            return this.agentThreadGroupMap.get(agentName);
        }
    }

    public List<AgentInfo> getRunningAgents() {
        TreeSet<AgentInfo> sorted = new TreeSet<AgentInfo>(new Comparator<AgentInfo>(){

            @Override
            public int compare(AgentInfo o1, AgentInfo o2) {
                return o1.getName().compareTo(o2.getName());
            }

            public boolean equals(AgentInfo obj) {
                return false;
            }
        });
        sorted.addAll(this.agentList.getAgentInfo());
        return new LinkedList<AgentInfo>(sorted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killAgent(String agentname) {
        Agent a;
        Object object = this.lock;
        synchronized (object) {
            a = this.agentMap.get(agentname);
        }
        if (a != null) {
            a.kill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showAgent(String agentname) {
        Agent a;
        Object object = this.lock;
        synchronized (object) {
            a = this.agentMap.get(agentname);
        }
        if (a != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    a.showGUI();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideAgent(String agentname) {
        Agent a;
        Object object = this.lock;
        synchronized (object) {
            a = this.agentMap.get(agentname);
        }
        if (a != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    a.hideGUI();
                }
            });
        }
    }

    private static void stopAgent(Agent agent) {
        agent.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void deleteAgent(String agentname, boolean die) {
        this.logger.fine("Deleting agent: " + agentname);
        Object object = this.lock;
        synchronized (object) {
            this.agentThreadGroupMap.remove(agentname);
            Agent a = this.agentMap.remove(agentname);
            if (a != null) {
                this.container.getLibraryManager().deregisterClassOwner(a);
            }
            if (this.managerShutDown) {
                this.lock.notify();
            }
        }
        this.fireAgentListChanged();
        AgentInfo ai = this.getInternalAgentInfo(agentname);
        if (die) {
            Object object2 = this.lock;
            synchronized (object2) {
                this.agentList.getAgentInfo().remove(ai);
                this.container.getGlobalStore().putXML(AUTORUN, this.agentList);
            }
        }
        if (ai != null) {
            this.container.getLibraryManager().deregisterAgent(agentname, ai.getLibraries().getLibrary().toArray(new String[0]));
        } else {
            this.container.getLibraryManager().deregisterAgent(agentname, new String[0]);
        }
    }

    public AgentInfo getAgentInfo(String aname) {
        AgentInfo iai = this.getInternalAgentInfo(aname);
        if (iai != null) {
            return (AgentInfo)AglobeXMLtools.cloneSerializable(iai);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageReceiver getMessageReceiver(String receiver) throws RecepientNotFound {
        Agent agent;
        Object object = this.lock;
        synchronized (object) {
            agent = this.agentMap.get(receiver);
        }
        if (agent == null) {
            throw new RecepientNotFound();
        }
        return agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incomingMessage(Message m) throws RecepientNotFound {
        Agent agent;
        Address receiver = m.getReceiver();
        Object object = this.lock;
        synchronized (object) {
            agent = this.agentMap.get(receiver.getName());
        }
        if (agent == null) {
            m.release();
            throw new RecepientNotFound();
        }
        agent.incomingMessage(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] searchAgent(AgentFilter filter) {
        LinkedList<String> l = new LinkedList<String>();
        Object object = this.lock;
        synchronized (object) {
            for (AgentInfo ai : this.agentList.getAgentInfo()) {
                if (!filter.filter(ai)) continue;
                l.add(ai.getName());
            }
        }
        return l.toArray(new String[l.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsAgent(String name) {
        Object object = this.lock;
        synchronized (object) {
            return this.agentMap.containsKey(name);
        }
    }

    private String createUniqueAgentName() {
        Store s = this.container.getGlobalStore();
        int i = s.getInt(AGENTCNT, 0);
        DecimalFormat format = new DecimalFormat("000");
        s.putInt(AGENTCNT, (i + 1) % 1000);
        return String.valueOf(this.container.getContainerName()) + format.format(i) + "." + System.currentTimeMillis();
    }

    @Override
    public void addListListener(ListListener ll) {
        this.listListener = ll;
        this.fireAgentListChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAgentListChanged() {
        if (this.listListener != null) {
            TreeSet<String> agentmap;
            Object object = this.lock;
            synchronized (object) {
                agentmap = new TreeSet<String>((Collection)this.agentMap.keySet());
            }
            this.listListener.ListChanged(ListListener.AGENTS, agentmap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AgentInfo getInternalAgentInfo(String name) {
        if (name == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            int i = this.agentList.getAgentInfo().indexOf(AgentFilter.getNameFilter(name));
            if (i >= 0) {
                return this.agentList.getAgentInfo().get(i);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void agentMoveFinished(AgentMoverCallback.Result result, final Agent agent) {
        if (result == AgentMoverCallback.DONE) {
            this.deleteAgent(agent.getName(), true);
        } else {
            final AgentInfo ai = this.getInternalAgentInfo(agent.getName());
            if (ai == null) {
                throw new RuntimeException("FATAL: AgentInfo not found!");
            }
            try {
                agent.setContainer(this.container);
                agent.addEvent(new Runnable(){

                    public void run() {
                        agent.sysInit(ai, 4);
                        agent.init(ai, 4);
                    }
                });
                Object object = this.lock;
                synchronized (object) {
                    this.agentMap.put(ai.getName(), agent);
                }
                this.fireAgentListChanged();
                ThreadGroup atg = new ThreadGroup(this.agentThreads, ai.getName());
                Object object2 = this.lock;
                synchronized (object2) {
                    this.agentThreadGroupMap.put(ai.getName(), atg);
                }
                AglobeThreadPool.startInNewThread(atg, new AgentRunner(agent, atg), String.valueOf(this.container.getContainerName()) + ": " + ai.getName() + ": " + MAIN_AGENT_THREAD_NAME);
            }
            catch (Exception e) {
                this.logger.severe("Exception thrown during agent's reinitialization (killing agent)" + e);
                this.deleteAgent(agent.getName(), true);
            }
        }
    }
}

