/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.agent;

import aglobe.container.AgentContainer;
import aglobe.container.CallerInferer;
import aglobe.container.ElementaryEntity;
import aglobe.container.MessageReceiver;
import aglobe.container.Store;
import aglobe.container.agent.AgentClonerCalleback;
import aglobe.container.agent.AgentRunner;
import aglobe.container.library.ClassLoaderOwner;
import aglobe.container.service.ServiceShell;
import aglobe.container.sysservice.AgentMoverCallback;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.container.transport.MessageTransport;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;
import aglobe.platform.thread.AglobeThreadPool;
import aglobe.service.gis.client.GISClientService;
import aglobe.service.gis.server.GISServerService;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.LinkedList;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public abstract class Agent
extends ClassLoaderOwner
implements ElementaryEntity,
Serializable {
    private static final long serialVersionUID = -7803140422777661595L;
    private static final int MAXPLAN = 1000000;
    private static final int MAXWAIT = 1000;
    public static final int isCREATED = 1;
    public static final int isRESTARTED = 2;
    public static final int isMOVED = 3;
    public static final int isMOVEFAILED = 4;
    public static final int isCLONED = 5;
    public static final int INIT = 0;
    public static final int RUNNING = 2;
    public static final int DONE = 3;
    public static final int MIGRATING = 4;
    public static final int DEAD = 6;
    public static final int CLONING = 7;
    public static final int EXCEPTION = 8;
    private String name;
    private int state = 0;
    private transient boolean die = false;
    private transient boolean stop = false;
    private transient boolean migrate = false;
    private transient LinkedList<Object> plan = new LinkedList();
    private transient MessageTransport mt = null;
    private transient Address migrationDest = null;
    protected transient Logger logger = null;
    private transient Message unblockingMessage = null;
    private transient boolean waitForIncomingMessage = false;
    private transient AgentContainer container = null;
    private transient Address agentAddress = null;
    private transient boolean useIdle = true;
    transient AgentRunner myAgentRunner = null;
    private volatile transient boolean isActive = true;
    private volatile transient boolean hasThreadAssigned = true;
    private transient String myThreadName = null;
    private transient Thread myThread = null;
    public ConcurrentHashMap<ServiceShell, ServiceShell> ownedServiceShells = new ConcurrentHashMap();
    private boolean logConnectionInitialized = false;
    private boolean hasLogConnection = false;
    private GISServerService.Shell gisServerShell = null;
    private GISClientService.Shell gisClientShell = null;
    private boolean usePersistentThread = false;
    private transient int lastMsgSize = 0;

    public final void sysInit(AgentInfo ai, int initState) {
        this.logger = Logger.getLogger("agent." + ai.getReadableName());
        this.state = 0;
        this.die = false;
        this.stop = false;
        this.migrate = false;
        this.name = ai.getName();
        this.addEvent(new Runnable(){

            public void run() {
                Agent.this.resetupServices();
            }
        });
    }

    public void init(AgentInfo ai, int initState) {
    }

    public final void setContainer(AgentContainer newContainer) throws Exception {
        if (this.container == null) {
            this.container = newContainer;
            this.mt = this.container.getMessageTransport();
            for (ServiceShell elem : this.ownedServiceShells.keySet()) {
                elem.setContainer(newContainer);
            }
        }
    }

    private void resetupServices() {
        if (!this.die && !this.stop) {
            for (ServiceShell elem : this.ownedServiceShells.keySet()) {
                elem.postInit();
            }
        }
    }

    public final AgentContainer getContainer() {
        return this.container;
    }

    protected void idle() {
        this.useIdle = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sysFinish() {
        for (ServiceShell elem : this.ownedServiceShells.keySet()) {
            elem.dispose();
        }
        if (!this.isActive) {
            LinkedList<Object> linkedList = this.plan;
            synchronized (linkedList) {
                for (Object e : this.plan) {
                    if (!(e instanceof Message)) continue;
                    ((Message)e).release();
                }
                this.plan.clear();
            }
        }
    }

    protected void finish() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean run() {
        try {
            LinkedList<Object> linkedList;
            this.myThread = Thread.currentThread();
            if (this.myThreadName == null) {
                this.state = 2;
                this.myThreadName = Thread.currentThread().getName();
            }
            while (!this.die && !this.stop) {
                boolean planIsEmpty;
                linkedList = this.plan;
                synchronized (linkedList) {
                    planIsEmpty = this.plan.isEmpty();
                }
                if (!planIsEmpty) {
                    Object o;
                    LinkedList<Object> linkedList2 = this.plan;
                    synchronized (linkedList2) {
                        o = this.plan.removeFirst();
                    }
                    if (o instanceof Runnable) {
                        ((Runnable)o).run();
                        continue;
                    }
                    if (!(o instanceof Message)) continue;
                    Message m = (Message)o;
                    this.handleIncomingMessage(m);
                    continue;
                }
                if (this.migrate) break;
                if (this.useIdle) {
                    this.idle();
                }
                linkedList = this.plan;
                synchronized (linkedList) {
                    if (this.plan.isEmpty()) {
                        if (!this.usePersistentThread && !this.useIdle) {
                            this.hasThreadAssigned = false;
                            this.myThread = null;
                            return false;
                        }
                        try {
                            this.plan.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            if (this.die) {
                this.isActive = false;
                this.state = 6;
                return true;
            }
            if (this.stop) {
                this.isActive = false;
                this.state = 3;
                return true;
            }
            if (this.migrate) {
                this.state = 4;
                return true;
            }
            linkedList = this.plan;
            synchronized (linkedList) {
                this.isActive = false;
                throw new IllegalStateException("Illegal agent state - stopped without reason.");
            }
        }
        catch (Throwable ex) {
            LinkedList<Object> linkedList = this.plan;
            synchronized (linkedList) {
                this.isActive = false;
            }
            this.logSevere("Run exception: " + ex);
            ex.printStackTrace();
            this.state = 8;
            return true;
        }
    }

    public final boolean isRunning() {
        return this.state == 2;
    }

    protected final void setThreadPersistency(boolean persistent) {
        this.usePersistentThread = persistent;
        AglobeThreadPool.adjustThreadMode(!this.usePersistentThread);
    }

    protected final Thread getCurrentAgentThread() {
        return this.myThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void showGUI() {
        try {
            LinkedList<Object> linkedList = this.plan;
            synchronized (linkedList) {
                if (!this.isActive) {
                    return;
                }
            }
            Field gui = this.getClass().getField("gui");
            Object o = gui.get(this);
            if (o != null && o instanceof Component) {
                final Component reflectGUI = (Component)o;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (reflectGUI != null) {
                            reflectGUI.setVisible(true);
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void hideGUI() {
        try {
            Field gui = this.getClass().getField("gui");
            Object o = gui.get(this);
            if (o != null && o instanceof Component) {
                final Component reflectGUI = (Component)o;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (reflectGUI != null) {
                            reflectGUI.setVisible(false);
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void destroyGUI() {
        try {
            Field gui = this.getClass().getField("gui");
            Object o = gui.get(this);
            if (o != null && o instanceof Window) {
                final Window reflectGUI = (Window)o;
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        reflectGUI.dispose();
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Message waitForIncomingMessage() throws Exception {
        LinkedList<Object> linkedList = this.plan;
        synchronized (linkedList) {
            block7: {
                block6: {
                    if (this.isActive) break block6;
                    return null;
                }
                this.waitForIncomingMessage = true;
                try {
                    this.plan.wait();
                }
                catch (InterruptedException ex) {
                    this.waitForIncomingMessage = false;
                    if (!this.die && !this.stop) break block7;
                    throw new Exception("Agent finished.");
                }
            }
        }
        return this.unblockingMessage;
    }

    public final MessageReceiver getMessageReceiver(String receiver) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incomingMessage(Message m) {
        LinkedList<Object> linkedList = this.plan;
        synchronized (linkedList) {
            if (!this.isActive) {
                m.release();
                return;
            }
            if (this.waitForIncomingMessage) {
                this.waitForIncomingMessage = false;
                this.unblockingMessage = m;
            } else {
                if (this.plan.size() >= 1000000) {
                    throw new IllegalStateException("Maximum scheduled tasks limit exceeded");
                }
                this.plan.addLast(m);
            }
            if (this.hasThreadAssigned) {
                this.plan.notify();
            } else {
                this.hasThreadAssigned = true;
                AglobeThreadPool.startInNewThread(this.myAgentRunner.agentThreadGroup, this.myAgentRunner, this.myThreadName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final TimerTask scheduleEvent(final Runnable event, long delay) {
        LinkedList<Object> linkedList = this.plan;
        synchronized (linkedList) {
            if (!this.isActive) {
                return null;
            }
        }
        TimerTask tt = new TimerTask(){

            public void run() {
                Agent.this.addEvent(event);
            }
        };
        this.getContainer().TIMER.schedule(tt, delay);
        return tt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final TimerTask scheduleEvent(final Runnable event, long delay, long period) {
        LinkedList<Object> linkedList = this.plan;
        synchronized (linkedList) {
            if (!this.isActive) {
                return null;
            }
        }
        TimerTask tt = new TimerTask(){

            public void run() {
                Agent.this.addEvent(event);
            }
        };
        this.getContainer().TIMER.schedule(tt, delay, period);
        return tt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(Runnable e) {
        LinkedList<Object> linkedList = this.plan;
        synchronized (linkedList) {
            if (!this.isActive) {
                return;
            }
            if (this.plan.size() >= 1000000) {
                throw new IllegalStateException("Maximum scheduled tasks limit exceeded");
            }
            this.plan.addLast(e);
            if (this.hasThreadAssigned) {
                this.plan.notify();
            } else {
                this.hasThreadAssigned = true;
                AglobeThreadPool.startInNewThread(this.myAgentRunner.agentThreadGroup, this.myAgentRunner, this.myThreadName);
            }
        }
    }

    protected abstract void handleIncomingMessage(Message var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void migrate(Address dest) {
        LinkedList<Object> linkedList = this.plan;
        synchronized (linkedList) {
            if (!this.isActive) {
                return;
            }
        }
        if (this.getContainer().isServerContainer()) {
            throw new RuntimeException("Agent on the server container cannot migrate");
        }
        if (!dest.isContainerAddress()) {
            throw new IllegalArgumentException("Migrating to non-container address: " + dest.toString());
        }
        if (dest.isSameContainer(this.getAddress())) {
            throw new IllegalArgumentException("Migrating to same container");
        }
        this.migrationDest = dest;
        this.migrate = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clone(final String newCloneName, final Address destination, final AgentClonerCalleback cloneCallback) throws Exception {
        LinkedList<Object> linkedList = this.plan;
        synchronized (linkedList) {
            if (!this.isActive) {
                return;
            }
        }
        if (this.getContainer().isServerContainer()) {
            throw new RuntimeException("Agent on the server container cannot be clonned");
        }
        if (!destination.isContainerAddress()) {
            throw new IllegalArgumentException("Cloning to non-container address: " + destination.toString());
        }
        if (destination.isSameContainer(this.getAddress())) {
            throw new IllegalArgumentException("Cloning to same container");
        }
        this.migrationDest = destination;
        AgentMoverCallback callback = new AgentMoverCallback(){

            public void agentMoveFinished(AgentMoverCallback.Result result, Agent agent) {
                if (result == AgentMoverCallback.DONE) {
                    cloneCallback.done(destination.deriveAgentAddress(newCloneName));
                } else {
                    cloneCallback.failed(newCloneName, destination);
                }
            }
        };
        this.state = 7;
        this.getContainer().getAgentManager().cloneAgent(this, newCloneName, callback);
        this.state = 2;
    }

    final void moveFinished() {
        this.migrationDest = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void stop() {
        LinkedList<Object> linkedList = this.plan;
        synchronized (linkedList) {
            if (!this.isActive) {
                return;
            }
            this.stop = true;
            if (this.hasThreadAssigned) {
                this.plan.notify();
            } else {
                this.hasThreadAssigned = true;
                AglobeThreadPool.startInNewThread(this.myAgentRunner.agentThreadGroup, this.myAgentRunner, this.myThreadName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void kill() {
        LinkedList<Object> linkedList = this.plan;
        synchronized (linkedList) {
            if (!this.isActive) {
                return;
            }
            this.die = true;
            this.state = 6;
            if (this.hasThreadAssigned) {
                this.plan.notify();
            } else {
                this.hasThreadAssigned = true;
                AglobeThreadPool.startInNewThread(this.myAgentRunner.agentThreadGroup, this.myAgentRunner, this.myThreadName);
            }
        }
    }

    public final String getName() {
        return this.name;
    }

    public final int getState() {
        return this.state;
    }

    public final Address getAddress() {
        if (this.agentAddress == null) {
            this.agentAddress = Address.getLocalAgentAddress(this, this.name);
        }
        return this.agentAddress;
    }

    public void sendMessage(Message m) throws InvisibleContainerException {
        this.lastMsgSize = 0;
        this.lastMsgSize = m.isMulticast() ? this.mt.sendMulticastMessage(m, false) : this.mt.sendStandardMessage(m, false);
    }

    public void sendMessageAsReference(Message m) throws InvisibleContainerException {
        this.lastMsgSize = 0;
        this.lastMsgSize = m.isMulticast() ? this.mt.sendMulticastMessage(m, true) : this.mt.sendStandardMessage(m, true);
    }

    public int getLastMessageSize() {
        return this.lastMsgSize;
    }

    protected final void sendNotUnderstood(Message m, String reason) {
        if (!m.getPerformative().equalsIgnoreCase("NOT-UNDERSTOOD")) {
            Message re = m.getReply();
            re.setContent(m.getContent());
            re.setPerformative("NOT-UNDERSTOOD");
            if (reason != null) {
                re.setReason(reason);
            }
            try {
                this.sendMessage(re);
            }
            catch (InvisibleContainerException invisibleContainerException) {
                // empty catch block
            }
            re.release();
        }
    }

    public final Address getMigrationDest() {
        return this.migrationDest;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.logger.getName());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.die = false;
        this.stop = false;
        this.migrate = false;
        this.plan = new LinkedList();
        this.unblockingMessage = null;
        this.waitForIncomingMessage = false;
        this.isActive = true;
        this.hasThreadAssigned = true;
        this.myThreadName = null;
        this.myThread = null;
        this.logger = Logger.getLogger((String)in.readObject());
    }

    public final Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void log(Level level, String[] callPoint, String message) {
        String lm = "container: " + this.getContainer().getContainerName() + "; agent: " + this.getName() + "\n" + message;
        if (this.logger != null) {
            this.logger.logp(level, callPoint[0], callPoint[1], lm);
        } else {
            Logger.getAnonymousLogger().logp(level, callPoint[0], callPoint[1], lm);
        }
        LinkedList<Object> linkedList = this.plan;
        synchronized (linkedList) {
            if (!this.logConnectionInitialized && this.isActive) {
                this.gisClientShell = (GISClientService.Shell)this.getContainer().getServiceManager().getService(this, "gis/client");
                if (this.gisClientShell == null) {
                    this.gisServerShell = (GISServerService.Shell)this.getContainer().getServiceManager().getService(this, "gis/master");
                    if (this.gisServerShell != null) {
                        this.hasLogConnection = true;
                    }
                } else {
                    this.hasLogConnection = true;
                }
                this.logConnectionInitialized = true;
            }
        }
        if (this.hasLogConnection) {
            String m = String.valueOf(new Date().toString()) + ": " + callPoint[0] + " " + callPoint[1] + "\n" + level.toString() + ": " + lm;
            if (this.gisClientShell != null) {
                this.gisClientShell.submitTopic("LOGGER_MESSAGE", m, Integer.toString(level.intValue()));
            } else if (this.gisServerShell != null) {
                this.gisServerShell.sendTopicToLocal("LOGGER_MESSAGE", m, Integer.toString(level.intValue()));
            }
        }
    }

    private final void log(Level level, String message) {
        String[] callPoint = CallerInferer.inferCaller();
        this.log(level, callPoint, message);
    }

    public final void logFinest(String message) {
        this.log(Level.FINEST, message);
    }

    public final void logFine(String message) {
        this.log(Level.FINE, message);
    }

    public final void logInfo(String message) {
        this.log(Level.INFO, message);
    }

    public final void logWarning(String message) {
        this.log(Level.WARNING, message);
    }

    public final void logSevere(String message) {
        this.log(Level.SEVERE, message);
    }

    public final Store getStore() {
        return this.container.getAgentStore(this.name);
    }
}

