/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container;

import aglobe.container.StoreException;
import aglobe.container.library.LibraryObjectInputStream;
import aglobe.util.AglobeXMLtools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class Store {
    private final String agentHome;
    private final String serviceHome;
    private final String libHome;
    private final String prefHome;
    private final String storeRoot;
    public static final String READMEF = "readme.txt";
    public static final String READMETXT = "This directory was generated by the A-Globe" + System.getProperty("line.separator") + "All container persistent information and configuration are stored here.";
    private static final int BUFLEN = 1024;
    private String Root = null;
    private final boolean readOnly;

    public Store(String containerName, String storeRoot, boolean readOnly) {
        this.storeRoot = storeRoot;
        this.readOnly = readOnly;
        String containerHome = storeRoot == null ? String.valueOf(System.getProperty("user.home")) + File.separator + ".container" + File.separator + containerName : String.valueOf(storeRoot) + File.separator + containerName;
        this.agentHome = String.valueOf(containerHome) + File.separator + "agents";
        this.serviceHome = String.valueOf(containerHome) + File.separator + "services";
        this.libHome = String.valueOf(containerHome) + File.separator + "libraries";
        this.prefHome = String.valueOf(containerHome) + File.separator + "prefs";
        this.Root = containerHome;
        if (!this.exist(READMEF) && !readOnly) {
            Logger.getLogger("Store").info("Initializing container store: " + containerHome);
            this.putString(READMEF, READMETXT);
        }
    }

    public String getStoreRootDir() {
        return this.storeRoot;
    }

    public void setAsAgentStore(String agentname) {
        this.Root = String.valueOf(this.agentHome) + File.separator + agentname;
    }

    public void setAsServiceStore(String servicename) {
        this.Root = String.valueOf(this.serviceHome) + File.separator + servicename.replace('.', File.separatorChar);
    }

    public void setAsLibraryStore() {
        this.Root = this.libHome;
    }

    public void setAsGlobalStore() {
        this.Root = this.prefHome;
    }

    public String getAbsolutePath(String key) {
        return String.valueOf(this.Root) + File.separator + key;
    }

    public void putString(String key, String value) {
        if (this.readOnly) {
            return;
        }
        try {
            if (key.indexOf("..") != -1) {
                Logger.getLogger("Store").severe("Store: Illegal write attempt, key: " + key);
                return;
            }
            String file = String.valueOf(this.Root) + "/" + key;
            this.CreateFileWithPath(file);
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter osw = new OutputStreamWriter(fos);
            try {
                fos.getChannel().lock(0L, Long.MAX_VALUE, false);
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
            osw.write(value);
            osw.flush();
            osw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void putInt(String key, int value) {
        this.putString(key, String.valueOf(value));
    }

    public void putDouble(String key, double value) {
        this.putString(key, String.valueOf(value));
    }

    public void putBoolean(String key, boolean value) {
        this.putString(key, String.valueOf(value));
    }

    public void putObject(String key, Serializable value) {
        if (this.readOnly) {
            return;
        }
        FileOutputStream o = this.putFile(key);
        if (o != null) {
            try {
                ObjectOutputStream out = new ObjectOutputStream(o);
                out.writeObject(value);
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean exist(String key) {
        File f = new File(String.valueOf(this.Root) + File.separator + key);
        return f.exists();
    }

    public FileOutputStream putFile(String key) {
        if (this.readOnly) {
            return null;
        }
        try {
            String file = String.valueOf(this.Root) + File.separator + key;
            this.CreateFileWithPath(file);
            FileOutputStream f = new FileOutputStream(new File(file).getAbsolutePath());
            try {
                f.getChannel().lock(0L, Long.MAX_VALUE, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return f;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean removeFile(String key) {
        if (this.readOnly) {
            return false;
        }
        try {
            String file = String.valueOf(this.Root) + File.separator + key;
            file = file.trim();
            File f = new File(file);
            if (f.exists()) {
                return f.delete();
            }
            return true;
        }
        catch (Exception ex) {
            Logger.getLogger("Store").severe("Store: Couldn't remove file.");
            return false;
        }
    }

    public void putXML(String key, Object m) {
        if (this.readOnly) {
            return;
        }
        try {
            FileOutputStream out = this.putFile(key);
            try {
                out.getChannel().lock(0L, Long.MAX_VALUE, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (out != null) {
                AglobeXMLtools.marshallJAXBObject(m, out);
                out.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String getString(String key) {
        if (key.indexOf("..") != -1) {
            return null;
        }
        try {
            FileInputStream fis = new FileInputStream(String.valueOf(this.Root) + File.separator + key);
            try {
                fis.getChannel().lock(0L, Long.MAX_VALUE, true);
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
            BufferedReader d = new BufferedReader(new InputStreamReader(fis));
            String s = d.readLine();
            d.close();
            return s;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getString(String key, String def) {
        String d = this.getString(key);
        if (d == null) {
            this.putString(key, def);
            return def;
        }
        return d;
    }

    public int getInt(String key, int def) {
        try {
            return Integer.parseInt(this.getString(key));
        }
        catch (Exception ex) {
            this.putInt(key, def);
            return def;
        }
    }

    public double getDouble(String key, double def) {
        try {
            return Double.parseDouble(this.getString(key));
        }
        catch (Exception ex) {
            this.putDouble(key, def);
            return def;
        }
    }

    public boolean getBoolean(String key, boolean def) {
        String s = this.getString(key);
        if (s == null) {
            this.putBoolean(key, def);
            return def;
        }
        if (s.equalsIgnoreCase("true")) {
            return true;
        }
        if (s.equalsIgnoreCase("false")) {
            return false;
        }
        return def;
    }

    public Object getObject(String key, ClassLoader classLoader) {
        FileInputStream i = this.getFile(key);
        if (i != null) {
            try {
                LibraryObjectInputStream in = new LibraryObjectInputStream((InputStream)i, classLoader);
                Object o = in.readObject();
                in.close();
                return o;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public FileInputStream getFile(String key) {
        try {
            FileInputStream f = new FileInputStream(new File(String.valueOf(this.Root) + "/" + key).getAbsolutePath());
            try {
                f.getChannel().lock(0L, Long.MAX_VALUE, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return f;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Object getXML(String key, Class c) throws Exception {
        FileInputStream in = this.getFile(key);
        Object o = AglobeXMLtools.unmarshallJAXBObject(c, in);
        in.close();
        return o;
    }

    public String[] listEntries(String key) {
        File f = new File(String.valueOf(this.Root) + File.separator + key);
        String[] l = f.list();
        if (l == null) {
            return new String[0];
        }
        return l;
    }

    private synchronized void CreateFileWithPath(String key) throws StoreException {
        File f = new File(key);
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        try {
            if (!f.exists()) {
                f.createNewFile();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Logger.getLogger("Store").severe("Store: Couldn't create file: " + key);
            throw new StoreException();
        }
    }

    public void deleteKey(String key) {
        this.delete(String.valueOf(this.Root) + File.separator + key);
    }

    private void delete(String key) {
        if (this.readOnly) {
            return;
        }
        File f = new File(key);
        if (f.isDirectory()) {
            String[] files = f.list();
            int i = 0;
            while (i < files.length) {
                this.delete(String.valueOf(key) + File.separator + files[i]);
                ++i;
            }
        }
        f.delete();
    }

    public void zip(OutputStream out) {
        File f = new File(this.Root);
        File[] subs = f.listFiles();
        if (subs != null) {
            ZipOutputStream zip = new ZipOutputStream(out);
            int i = 0;
            while (i < subs.length) {
                this.addToZip("", subs[i], zip);
                ++i;
            }
            try {
                zip.finish();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void unZip(InputStream in) {
        byte[] buf = new byte[1024];
        try {
            ZipEntry e;
            ZipInputStream zip = new ZipInputStream(in);
            while ((e = zip.getNextEntry()) != null) {
                File f;
                if (e.isDirectory()) {
                    f = new File(String.valueOf(this.Root) + File.separator + e.getName());
                    f.mkdirs();
                    continue;
                }
                f = new File(String.valueOf(this.Root) + File.separator + e.getName());
                f.getParentFile().mkdirs();
                try {
                    int len;
                    FileOutputStream out = new FileOutputStream(f);
                    CRC32 crc32 = new CRC32();
                    while ((len = zip.read(buf)) != -1) {
                        crc32.update(buf, 0, len);
                        out.write(buf, 0, len);
                    }
                    out.close();
                    f.setLastModified(e.getTime());
                    if (e.getCrc() == crc32.getValue()) continue;
                    throw new RuntimeException("CRC32 error for file: " + e.getName());
                }
                catch (FileNotFoundException ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void addToZip(String path, File f, ZipOutputStream zip) {
        String name = String.valueOf(path) + f.getName();
        if (f.isDirectory()) {
            name = String.valueOf(name) + "/";
        }
        try {
            ZipEntry e = new ZipEntry(name);
            e.setTime(f.lastModified());
            if (f.isFile()) {
                int len;
                int STORELIMIT = 100;
                byte[] buf = new byte[1024];
                CRC32 crc32 = new CRC32();
                FileInputStream in = new FileInputStream(f.getAbsolutePath());
                while ((len = in.read(buf)) != -1) {
                    crc32.update(buf, 0, len);
                }
                in.close();
                e.setSize(f.length());
                e.setCrc(crc32.getValue());
                if (f.length() < 100L) {
                    e.setMethod(0);
                }
                zip.putNextEntry(e);
                in = new FileInputStream(f.getAbsolutePath());
                while ((len = in.read(buf)) != -1) {
                    zip.write(buf, 0, len);
                }
                in.close();
            } else {
                zip.putNextEntry(e);
                File[] subs = f.listFiles();
                int i = 0;
                while (i < subs.length) {
                    this.addToZip(name, subs[i], zip);
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

