/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container;

import aglobe.container.AgentContainer;
import aglobe.container.library.LibraryManager;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassFinder
extends ClassLoader {
    private static Pattern classFilter = Pattern.compile("^([^$]*)\\.class$");
    private static Pattern jdkjarFilter = Pattern.compile("\\\\jdk");
    private final AgentContainer container;
    private Class<?> agent;
    private Class<?> service;
    private LinkedList<String> agents_result = new LinkedList();
    private HashSet<String> agents_test = new HashSet();
    private LinkedList<String> services_result = new LinkedList();
    private HashSet<String> services_test = new HashSet();
    private boolean initialized = false;
    private boolean valid = false;

    public ClassFinder(AgentContainer container) {
        this.container = container;
        try {
            this.agent = Class.forName("aglobe.container.agent.Agent");
            this.service = Class.forName("aglobe.container.service.Service");
            this.initialized = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private void check() {
        if (!this.initialized) {
            return;
        }
        if (!this.valid) {
            try {
                this.refreshLists();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.valid = true;
        }
    }

    private void refreshDirectory(File path, String pkg) {
        String[] fs = path.list();
        if (fs != null) {
            int i = 0;
            while (i < fs.length) {
                String cname = String.valueOf(pkg.equals("") ? "" : String.valueOf(pkg) + ".") + fs[i];
                Matcher m = classFilter.matcher(cname);
                if (m.find()) {
                    String clname = m.group(1);
                    this.testClass(clname);
                } else {
                    File nf = new File(path, fs[i]);
                    this.refreshDirectory(nf, cname);
                }
                ++i;
            }
        }
    }

    private void refreshLists() {
        LibraryManager.LibraryRecord[] lmlibs;
        int i;
        this.agents_test.clear();
        this.services_test.clear();
        HashSet<String> browsed = new HashSet<String>();
        String cp = System.getProperty("java.class.path");
        String pathseparator = System.getProperty("path.separator");
        String[] cps = cp.split(pathseparator);
        while (cps.length > 0) {
            HashSet<String> newToSearch = new HashSet<String>();
            i = 0;
            while (i < cps.length) {
                File fp = new File(cps[i]);
                browsed.add(fp.getPath());
                if (fp.isDirectory()) {
                    this.refreshDirectory(fp, "");
                } else {
                    Matcher mJdk = jdkjarFilter.matcher(cps[i]);
                    if (!mJdk.find()) {
                        try {
                            String newCP;
                            JarFile jf = new JarFile(cps[i]);
                            Enumeration<JarEntry> je = jf.entries();
                            while (je.hasMoreElements()) {
                                JarEntry el = je.nextElement();
                                Matcher m = classFilter.matcher(el.getName());
                                if (!m.find()) continue;
                                String cname = m.group(1);
                                cname = cname.replace('/', '.');
                                this.testClass(cname);
                            }
                            Manifest mf = jf.getManifest();
                            if (mf != null && (newCP = mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH)) != null) {
                                String[] newCPs = newCP.split(" ");
                                int j = 0;
                                while (j < newCPs.length) {
                                    String nfs;
                                    File nf = new File(newCPs[j]);
                                    if (!nf.isAbsolute()) {
                                        nf = new File(fp.toURI().resolve(newCPs[j]));
                                    }
                                    if (!browsed.contains(nfs = nf.getAbsolutePath())) {
                                        newToSearch.add(nfs);
                                    }
                                    ++j;
                                }
                            }
                        }
                        catch (IOException ex2) {
                            ex2.printStackTrace();
                        }
                    }
                }
                ++i;
            }
            cps = newToSearch.toArray(new String[newToSearch.size()]);
        }
        if (this.container != null && (lmlibs = this.container.getLibraryManager().getLibraryList()) != null) {
            i = 0;
            while (i < lmlibs.length) {
                try {
                    JarFile jf = new JarFile(lmlibs[i].absolutePathToTheLibrary);
                    URLClassLoader ccc = new URLClassLoader(new URL[]{new File(lmlibs[i].absolutePathToTheLibrary).toURI().toURL()});
                    Enumeration<JarEntry> je = jf.entries();
                    while (je.hasMoreElements()) {
                        JarEntry el = je.nextElement();
                        Matcher m = classFilter.matcher(el.getName());
                        if (!m.find()) continue;
                        String cname = m.group(1);
                        cname = cname.replace('/', '.');
                        String name = cname + '@' + lmlibs[i].toString();
                        try {
                            Class<?> obj = ccc.loadClass(cname);
                            if (this.agent.isAssignableFrom(obj)) {
                                if (this.agents_test.contains(name) || (obj.getModifiers() & 0x606) != 0) continue;
                                this.agents_test.add(name);
                                continue;
                            }
                            if (!this.service.isAssignableFrom(obj) || this.services_test.contains(name) || (obj.getModifiers() & 0x606) != 0) continue;
                            this.services_test.add(name);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
                ++i;
            }
        }
        this.agents_result = new LinkedList<String>(new TreeSet<String>(this.agents_test));
        this.services_result = new LinkedList<String>(new TreeSet<String>(this.services_test));
    }

    private void testClass(String cname) {
        try {
            Class<?> obj = Class.forName(cname);
            if (this.agent.isAssignableFrom(obj)) {
                if (!this.agents_test.contains(cname) && (obj.getModifiers() & 0x606) == 0) {
                    this.agents_test.add(cname);
                }
            } else if (this.service.isAssignableFrom(obj) && !this.services_test.contains(cname) && (obj.getModifiers() & 0x606) == 0) {
                this.services_test.add(cname);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void invalidate() {
        this.valid = false;
    }

    public List getAgentList() {
        this.check();
        return this.agents_result;
    }

    public List getServiceList() {
        this.check();
        return this.services_result;
    }

    public static void main(String[] args) {
        ClassFinder cf = new ClassFinder(null);
        cf.check();
        System.out.println("Agents:");
        for (String item : cf.agents_result) {
            System.out.println(item);
        }
        System.out.println("\n\nServices:");
        for (String item : cf.services_result) {
            System.out.println(item);
        }
    }
}

