/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container;

import aglobe.container.ClassFinder;
import aglobe.container.ElementaryEntity;
import aglobe.container.RecepientNotFound;
import aglobe.container.Store;
import aglobe.container.agent.AgentManager;
import aglobe.container.gui.AgentContainerGUI;
import aglobe.container.library.LibraryManager;
import aglobe.container.service.Service;
import aglobe.container.service.ServiceManager;
import aglobe.container.service.ServiceShell;
import aglobe.container.sharedobjects.SharedObjectsManager;
import aglobe.container.sysservice.DeployService;
import aglobe.container.sysservice.directory.DirectoryService;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.container.transport.MessageTransport;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.AgentList;
import aglobe.ontology.Command;
import aglobe.ontology.ContainerStartup;
import aglobe.ontology.Message;
import aglobe.ontology.MessageConstants;
import aglobe.ontology.ServiceInfo;
import aglobe.ontology.ServiceList;
import aglobe.platform.Platform;
import aglobe.platform.thread.AglobeThreadPool;
import aglobe.service.gis.client.AutoConfiguratorClient;
import aglobe.service.gis.client.GISClientService;
import aglobe.service.gis.client.GISTopicListener;
import aglobe.service.gis.hwclient.HWGISClientService;
import aglobe.service.gis.server.GISServerService;
import aglobe.service.gis.server.GISTopicServerListener;
import aglobe.service.gis.server.bridge.client.GISServerBridgeClient;
import aglobe.service.gis.server.bridge.server.GISServerBridgeServer;
import aglobe.service.link.LinkService;
import aglobe.util.AglobeXMLtools;
import aglobe.util.GUIUtils;
import aglobex.service.agentmonitor.AgentMonitorService;
import aglobex.web.server.WebServerService;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AgentContainer {
    public static final String COMMANDSERVICE = "container/command";
    public static final String SERVICEDIR = "container/service/directory";
    public static final String AGENTDIR = "container/agent/directory";
    public static final String LIBDIR = "container/library/directory";
    private static String DEFAULTNAME = "Container";
    public static final String DEFAULT_SYSTEM_NAME = "default";
    private static final int SHUTDOWNTIMEOUT = 5000;
    private String name = null;
    private String storeRootDir = null;
    private LibraryManager lm = null;
    private ClassFinder cf = null;
    private MessageTransport mt = null;
    private ServiceManager sm = null;
    private AgentManager am = null;
    private AgentContainerGUI gui = null;
    private Properties properties = new Properties();
    private HashMap<String, LinkedList<String>> multipleProperties = new HashMap();
    public final Timer TIMER = Platform.TIMER;
    private boolean readOnlyStores = false;
    private boolean isServer = false;
    private boolean isClient = false;
    private boolean hasBridgeServer = false;
    private boolean hasBridgeClient = false;
    private Logger logger = Logger.getLogger("AgentContainer");
    private ThreadGroup containerThreadGroup;
    private LinkedHashSet<ShutdownListener> shutdownListeners = new LinkedHashSet();
    private SharedObjectsManager containerSharedObjectsManager = new SharedObjectsManager();

    public SharedObjectsManager getContainerSharedObjectsManager() {
        return this.containerSharedObjectsManager;
    }

    public String getContainerName() {
        return this.name;
    }

    public ThreadGroup getContainerThreadGroup() {
        return this.containerThreadGroup;
    }

    public LibraryManager getLibraryManager() {
        return this.lm;
    }

    public ClassFinder getClassFinder() {
        return this.cf;
    }

    public AgentManager getAgentManager() {
        return this.am;
    }

    public ServiceManager getServiceManager() {
        return this.sm;
    }

    public MessageTransport getMessageTransport() {
        return this.mt;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key, null);
    }

    public LinkedList<String> getMultipleProperty(String key) {
        return this.multipleProperties.get(key);
    }

    public Store getAgentStore(String name) {
        Store store = new Store(this.name, this.storeRootDir, this.readOnlyStores);
        store.setAsAgentStore(name);
        return store;
    }

    public Store getServiceStore(String name) {
        Store store = new Store(this.name, this.storeRootDir, this.readOnlyStores);
        store.setAsServiceStore(name);
        return store;
    }

    public Store getLibraryStore() {
        Store store = new Store(this.name, this.storeRootDir, this.readOnlyStores);
        store.setAsLibraryStore();
        return store;
    }

    public Store getGlobalStore() {
        Store store = new Store(this.name, this.storeRootDir, this.readOnlyStores);
        store.setAsGlobalStore();
        return store;
    }

    public AgentContainer(String[] args, AgentList agentList, ServiceList serviceList, Address librarySourceContainer) throws Exception {
        List<String> params = Arrays.asList(args);
        this.name = DEFAULTNAME;
        boolean noCommand = false;
        boolean noDirectory = false;
        boolean noMigration = false;
        boolean startWebService = false;
        boolean startAgentMonitorService = false;
        String linkName = null;
        boolean hwMode = false;
        String hwRange = null;
        Address masterAddress = null;
        int i = params.indexOf("-name");
        if (i != -1) {
            this.name = params.get(i + 1);
            this.logger.fine(String.valueOf(this.getContainerName()) + ": Use conatiner name: " + this.name);
        }
        if ((i = params.indexOf("-noStoreChange")) != -1) {
            this.readOnlyStores = true;
            this.logger.info(String.valueOf(this.getContainerName()) + ": store is read only !!!");
        }
        if ((i = params.indexOf("-noCommand")) != -1) {
            noCommand = true;
        }
        if ((i = params.indexOf("-noDirectory")) != -1) {
            noDirectory = true;
        }
        if ((i = params.indexOf("-noMigration")) != -1) {
            noMigration = true;
        }
        if ((i = params.indexOf("-store")) != -1) {
            this.storeRootDir = params.get(i + 1);
            this.logger.fine(String.valueOf(this.getContainerName()) + ": Setting Store root to: " + this.storeRootDir);
        } else {
            this.logger.fine(String.valueOf(this.getContainerName()) + ": Using default Store root.");
        }
        i = params.indexOf("-masterAddress");
        if (i != -1 || (i = params.indexOf("-serverAddress")) != -1) {
            try {
                masterAddress = Address.getAddress(params.get(i + 1));
                masterAddress = masterAddress.deriveServiceAddress("gis/master");
                this.logger.fine(String.valueOf(this.getContainerName()) + ": Setting master service address to: " + masterAddress.toString());
            }
            catch (Exception ex) {
                this.logger.warning(String.valueOf(this.getContainerName()) + ": Bad format of GIS server address:\n" + ex + "\nThe address will be found automatically if it is possible.");
            }
        }
        Iterator<String> j = params.iterator();
        while (j.hasNext()) {
            String item = j.next();
            if (!item.equals("-p")) continue;
            try {
                if (!j.hasNext()) continue;
                item = j.next();
                String[] k = item.split("=");
                this.properties.setProperty(k[0], k[1]);
                LinkedList<String> vals = this.multipleProperties.get(k[0]);
                if (vals == null) {
                    vals = new LinkedList();
                    this.multipleProperties.put(k[0], vals);
                }
                vals.add(k[1]);
            }
            catch (Exception ex) {
                this.logger.warning(String.valueOf(this.getContainerName()) + ": Bad param: " + item);
            }
        }
        if (params.indexOf("-master") != -1 || params.indexOf("-server") != -1) {
            this.isServer = true;
        }
        if (params.indexOf("-slave") != -1 || params.indexOf("-client") != -1) {
            this.isClient = true;
        }
        if (params.indexOf("-bridgeServer") != -1 && this.isServer) {
            this.hasBridgeServer = true;
        }
        if (params.indexOf("-bridgeClient") != -1 && !this.isServer && !this.isClient) {
            this.hasBridgeClient = true;
        }
        if ((i = params.indexOf("-hardwareVisibility")) != -1) {
            hwMode = true;
            hwRange = params.get(i + 1);
        }
        if ((i = params.indexOf("-linkName")) != -1) {
            linkName = params.get(i + 1);
        }
        if (params.indexOf("-web") != -1) {
            startWebService = true;
        }
        if (params.indexOf("-agentMonitor") != -1) {
            startAgentMonitorService = true;
        }
        if (this.isServer && this.isClient) {
            this.isClient = false;
        }
        if (hwMode) {
            this.isServer = false;
            this.isClient = false;
            this.hasBridgeServer = false;
            this.hasBridgeClient = false;
        }
        if (this.isServer || this.isClient || hwMode || this.hasBridgeClient) {
            linkName = null;
        }
        try {
            this.containerThreadGroup = new ThreadGroup(Platform.getPlatformThreadGroup(), new String("Container: " + this.name));
            this.logger.fine(String.valueOf(this.getContainerName()) + ": Starting LibraryManager");
            this.lm = new LibraryManager(this);
            this.cf = new ClassFinder(this);
            this.logger.fine(String.valueOf(this.getContainerName()) + ": Starting MessageTransport");
            this.mt = new MessageTransport(this);
            this.mt.afterInit();
            this.logger.fine(String.valueOf(this.getContainerName()) + ": Starting ServiceManager");
            TreeMap<String, Service> services = new TreeMap<String, Service>();
            if (!noCommand) {
                services.put(COMMANDSERVICE, new CommandService());
            }
            if (!this.isServer && !noMigration) {
                services.put(LIBDIR, new LibraryManager.LibraryDir());
                services.put("container/deploy", new DeployService());
            }
            GISClientService gisClientService = null;
            if (hwMode) {
                this.logger.info(String.valueOf(this.getContainerName()) + ": The visibility restrictions will be taken from the true network visibility");
            }
            String systemName = DEFAULT_SYSTEM_NAME;
            i = params.indexOf("-systemName");
            if (i != -1) {
                systemName = params.get(i + 1);
                this.logger.fine(String.valueOf(this.getContainerName()) + ": Using system name: " + systemName);
            } else if (this.isClient || this.isServer) {
                this.logger.info(String.valueOf(this.getContainerName()) + ": The system name is not specified. The default one will be used.");
            }
            if (this.isClient || this.hasBridgeClient) {
                if (masterAddress == null) {
                    masterAddress = AutoConfiguratorClient.getServerAddress(systemName);
                    if (masterAddress != null) {
                        this.logger.info(String.valueOf(this.getContainerName()) + ": Server container address found automatically: " + masterAddress);
                    }
                } else {
                    this.logger.info(String.valueOf(this.getContainerName()) + ": Use server container address from starting attributes: " + masterAddress);
                }
                if (masterAddress == null) {
                    this.logger.severe(String.valueOf(this.getContainerName()) + ": Server container address not found.");
                    this.shutdown();
                    throw new Exception("Server container address not found.");
                }
                if (this.isClient) {
                    gisClientService = new GISClientService(masterAddress, new Shutdown(){

                        public void shutdownContainer() {
                            AgentContainer.this.shutdown();
                        }
                    });
                    services.put("gis/client", gisClientService);
                } else {
                    GISServerBridgeClient gisBridgeClient = new GISServerBridgeClient(masterAddress, new Shutdown(){

                        public void shutdownContainer() {
                            AgentContainer.this.shutdown();
                        }
                    });
                    services.put("gis/master", gisBridgeClient);
                }
            }
            if (this.isServer) {
                services.put("gis/master", new GISServerService(systemName));
            }
            if (this.hasBridgeServer) {
                services.put("gis/bridgeserver", new GISServerBridgeServer());
            }
            if (hwMode) {
                gisClientService = new HWGISClientService(hwRange, systemName, new Shutdown(){

                    public void shutdownContainer() {
                        AgentContainer.this.shutdown();
                    }
                });
                services.put("gis/client", gisClientService);
            }
            LinkService linkService = null;
            if (linkName != null) {
                linkService = new LinkService(linkName, new Shutdown(){

                    public void shutdownContainer() {
                        AgentContainer.this.shutdown();
                    }
                });
                services.put("container/link", linkService);
            }
            this.sm = new ServiceManager(this);
            this.logger.fine(String.valueOf(this.getContainerName()) + ": Starting AgentManager");
            this.am = new AgentManager(this);
            if (!noMigration) {
                this.lm.aferContainerInit(this);
            }
            this.mt.aferContainerInit();
            this.sm.aferContainerInit(services, serviceList, librarySourceContainer);
            if (!this.isServer) {
                if (!noDirectory) {
                    DirectoryService ds = new DirectoryService();
                    this.sm.startService("container/directory", ds);
                    this.mt.afterServicesInit();
                    ds.afterMTvisibilitySubscription();
                }
            } else {
                this.mt.afterServicesInit();
            }
            if (startWebService) {
                WebServerService wss = new WebServerService();
                this.sm.startService("web/server", wss);
                wss.initWebServer();
            }
            if (startAgentMonitorService) {
                AgentMonitorService ams = new AgentMonitorService();
                this.sm.startService("agent/monitor", ams);
            }
            this.am.afterContainerInit(this.isServer, agentList, noMigration, librarySourceContainer);
            if (gisClientService != null) {
                final GISClientService gisClient = gisClientService;
                gisClient.addEvent(new Runnable(){

                    public void run() {
                        gisClient.afterContainerInit();
                    }
                });
            }
            if (linkService != null) {
                final LinkService lSer = linkService;
                lSer.addEvent(new Runnable(){

                    public void run() {
                        lSer.afterContainerInit();
                    }
                });
            }
            if ((i = params.indexOf("-gui")) != -1) {
                this.showGUI();
            }
            this.logger.info(String.valueOf(this.getContainerName()) + ": started - " + Address.getLocalContainerAddress(this).toString());
        }
        catch (Exception ex) {
            this.logger.severe(String.valueOf(this.getContainerName()) + ": Error occured while initialising the container:\n" + ex);
            this.shutdown();
            throw new Exception("Error occured while initialising the container:\n" + ex);
        }
    }

    public boolean isServerContainer() {
        return this.isServer;
    }

    public boolean isClientContainer() {
        return this.isClient;
    }

    private void containerFinished() {
        this.logger.info(String.valueOf(this.getContainerName()) + ": finished");
        Platform.containerFinishedNotify(this.getContainerName());
    }

    private void shutdown() {
        Thread stopThread = AglobeThreadPool.getThread(Platform.getPlatformThreadGroup(), new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block18: {
                    if (AgentContainer.this.name != null) {
                        ArrayList perfCpy;
                        LinkedHashSet linkedHashSet = AgentContainer.this.shutdownListeners;
                        synchronized (linkedHashSet) {
                            perfCpy = new ArrayList(AgentContainer.this.shutdownListeners);
                        }
                        for (ShutdownListener elem : perfCpy) {
                            elem.shutdownNotification(AgentContainer.this.name);
                        }
                    }
                    if (AgentContainer.this.am != null) {
                        AgentContainer.this.logger.fine(String.valueOf(AgentContainer.this.getContainerName()) + ": Shutting down AgentManager.");
                        AgentContainer.this.am.stopAgentManager(5000);
                    }
                    if (AgentContainer.this.sm != null) {
                        AgentContainer.this.logger.fine(String.valueOf(AgentContainer.this.getContainerName()) + ": Shutting down ServiceManager.");
                        AgentContainer.this.sm.stopServiceManager(5000);
                    }
                    if (AgentContainer.this.mt != null) {
                        AgentContainer.this.logger.fine(String.valueOf(AgentContainer.this.getContainerName()) + ": Shutting down MessageTransport.");
                        AgentContainer.this.mt.stopMessageTransport();
                    }
                    AgentContainer.this.hideGUI();
                    AgentContainer.this.containerFinished();
                    7 var1_3 = this;
                    synchronized (var1_3) {
                        while (true) {
                            while (true) {
                                if (AgentContainer.this.containerThreadGroup.activeCount() <= 0) {
                                    break block18;
                                }
                                try {
                                    this.wait(500L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            break;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                try {
                    AgentContainer.this.containerThreadGroup.destroy();
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, "container shutdown thread : " + this.getContainerName());
        stopThread.setPriority(1);
        stopThread.start();
    }

    private void showGUI() {
        if (this.gui == null) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        try {
                            AgentContainer.this.logger.fine(String.valueOf(AgentContainer.this.getContainerName()) + ": Starting Container GUI");
                            AgentContainer.this.gui = new AgentContainerGUI(AgentContainer.this);
                            AgentContainer.this.gui.pack();
                            GUIUtils.positionOnScreen(AgentContainer.this.gui, GUIUtils.hRIGHT, GUIUtils.vTOP);
                            AgentContainer.this.gui.setVisible(true);
                        }
                        catch (Exception ex) {
                            AgentContainer.this.logger.warning(String.valueOf(AgentContainer.this.getContainerName()) + ": Container GUI cannot be created");
                        }
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AgentContainer.this.gui.setVisible(true);
                }
            });
        }
    }

    private void hideGUI() {
        if (this.gui != null) {
            this.logger.fine(String.valueOf(this.getContainerName()) + ": Hiding Container GUI");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AgentContainer.this.gui.setVisible(false);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerShutdownListener(ShutdownListener listener) {
        LinkedHashSet<ShutdownListener> linkedHashSet = this.shutdownListeners;
        synchronized (linkedHashSet) {
            this.shutdownListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterShutdownListener(ShutdownListener listener) {
        LinkedHashSet<ShutdownListener> linkedHashSet = this.shutdownListeners;
        synchronized (linkedHashSet) {
            this.shutdownListeners.remove(listener);
        }
    }

    public static class CommandService
    extends Service
    implements MessageConstants,
    GISTopicListener,
    GISTopicServerListener {
        public static final String TOPIC_COMMAND = "COMMAND";
        public static final String TOPIC_COMMAND_RESPONSE = "COMMAND_RESPONSE";
        public static final String REQUEST_LIST = "REQUEST_LIST";
        public static final String RESPONSE_LIST = "RESPONSE_LIST";
        public static final String QUIT = "QUIT";
        public static final String GUI = "GUI";
        public static final String ENTITY_GUI = "ENTITY_GUI";
        public static final String VISIBLE = "Visible";
        public static final String TRUE = "true";
        public static final String AGENT = "Agent";
        public static final String SERVICE = "Service";
        private GISClientService.Shell gisShell = null;
        private GISServerService.Shell gisServerShell = null;

        private CommandService() {
        }

        public ServiceShell getServiceShell(ElementaryEntity shellOwner) {
            return new Shell(shellOwner, this);
        }

        public void startService() {
            this.getContainer().logger.fine("Starting COMMANDSERVICE");
            this.gisShell = (GISClientService.Shell)this.getContainer().getServiceManager().getService(null, "gis/client");
            if (this.gisShell != null) {
                this.gisShell.subscribeTopic(TOPIC_COMMAND, this);
            } else {
                this.gisServerShell = (GISServerService.Shell)this.getContainer().getServiceManager().getService(null, "gis/master");
                if (this.gisServerShell != null) {
                    this.gisServerShell.subscribeTopic(TOPIC_COMMAND, this);
                }
            }
        }

        public void stopService() {
            this.getContainer().logger.fine("Stopping COMMANDSERVICE");
            if (this.gisShell != null) {
                this.gisShell.dispose();
            }
            if (this.gisServerShell != null) {
                this.gisServerShell.dispose();
            }
        }

        public void handleIncomingMessage(final Message m) throws RecepientNotFound {
            if (!m.getPerformative().equalsIgnoreCase("REQUEST")) {
                String msg = "Wrong COMMAND performative (" + m.getPerformative() + ")";
                this.sendNotUnderstood(m, msg);
                this.getContainer().logger.warning(msg);
            } else if (m.getContent() instanceof Command) {
                Command c = (Command)m.getContent();
                Message re = m.getReply();
                if (this.execute(c, new Responser(){

                    public void sendResponse(Object reply) {
                        Message re = m.getReply();
                        re.setPerformative("INFORM-RESULT");
                        re.setContent(reply);
                        try {
                            CommandService.this.sendMessage(re);
                        }
                        catch (InvisibleContainerException invisibleContainerException) {
                            // empty catch block
                        }
                        re.release();
                    }
                })) {
                    re.setPerformative("DONE");
                } else {
                    re.setPerformative("FAILURE");
                }
                re.setContent(c);
                try {
                    this.sendMessage(re);
                }
                catch (InvisibleContainerException invisibleContainerException) {
                    // empty catch block
                }
                re.release();
            } else if (m.getContent() instanceof ContainerStartup) {
                this.startNewConatiner((ContainerStartup)m.getContent());
            } else {
                String msg = "Wrong COMMAND ontology (" + m.getOntology() + ")";
                this.sendNotUnderstood(m, msg);
                this.getContainer().logger.warning(msg);
            }
            m.release();
        }

        private boolean execute(Command c, Responser responser) {
            String name = c.getName();
            boolean success = true;
            this.getContainer().logger.finer("Command message received: " + name);
            if (QUIT.equals(name)) {
                this.getContainer().shutdown();
            } else if (GUI.equals(name)) {
                if (!c.getAglobeParam().isEmpty() && VISIBLE.equals(c.getAglobeParam().get(0).getName())) {
                    if (c.getAglobeParam().get(0).getValue().equalsIgnoreCase(TRUE)) {
                        this.getContainer().showGUI();
                    } else if (this.getContainer().gui != null) {
                        this.getContainer().hideGUI();
                    }
                }
            } else if (ENTITY_GUI.equals(name)) {
                if (c.getAglobeParam().size() >= 2 && AGENT.equals(c.getAglobeParam().get(0).getName()) && VISIBLE.equals(c.getAglobeParam().get(1).getName())) {
                    if (TRUE.equals(c.getAglobeParam().get(1).getValue())) {
                        this.getContainer().getAgentManager().showAgent(c.getAglobeParam().get(0).getValue());
                    } else {
                        this.getContainer().getAgentManager().hideAgent(c.getAglobeParam().get(0).getValue());
                    }
                } else if (c.getAglobeParam().size() >= 2 && SERVICE.equals(c.getAglobeParam().get(0).getName()) && VISIBLE.equals(c.getAglobeParam().get(1).getName())) {
                    if (TRUE.equals(c.getAglobeParam().get(1).getValue())) {
                        this.getContainer().getServiceManager().showService(c.getAglobeParam().get(0).getValue());
                    } else {
                        this.getContainer().getServiceManager().hideService(c.getAglobeParam().get(0).getValue());
                    }
                }
            } else if (REQUEST_LIST.equals(name)) {
                if (responser == null) {
                    return false;
                }
                Command resp = new Command();
                resp.setName(RESPONSE_LIST);
                List<AgentInfo> agents = this.getContainer().getAgentManager().getRunningAgents();
                for (AgentInfo item : agents) {
                    resp.getAglobeParam().add(AglobeXMLtools.makeAglobeParam(AGENT, item.getName()));
                }
                List<ServiceInfo> services = this.getContainer().getServiceManager().getRunningServices();
                for (ServiceInfo item : services) {
                    resp.getAglobeParam().add(AglobeXMLtools.makeAglobeParam(SERVICE, item.getName()));
                }
                responser.sendResponse(resp);
            } else {
                String result = "Wrong COMMAND name (" + name + ")";
                c.setResult(result);
                this.getContainer().logger.warning(result);
                success = false;
            }
            return success;
        }

        private void startNewConatiner(ContainerStartup containerStartupRecord) {
            AgentList al = containerStartupRecord.getAgentList();
            ServiceList sl = containerStartupRecord.getServiceList();
            String[] attribs = containerStartupRecord.getAttribute().toArray(new String[containerStartupRecord.getAttribute().size()]);
            try {
                Platform.startNewContainer(attribs, al, sl, containerStartupRecord.getLibrarySourceContainer());
            }
            catch (Exception ex) {
                this.logSevere("Exception during starting new A-globe container: " + ex.toString());
            }
        }

        public void handleTopic(String topic, Object content, String reason) {
            if (topic.equalsIgnoreCase(TOPIC_COMMAND)) {
                if (content instanceof Command) {
                    this.execute((Command)content, new Responser(){

                        public void sendResponse(Object reply) {
                            CommandService.this.gisShell.submitTopicToServer(CommandService.TOPIC_COMMAND_RESPONSE, reply);
                        }
                    });
                } else if (content instanceof ContainerStartup) {
                    this.startNewConatiner((ContainerStartup)content);
                } else {
                    this.logWarning("Wrong command ontology: " + content.getClass().getName());
                }
                return;
            }
            this.logger.warning("Unexpected incoming topic: " + topic);
        }

        public void handleLoginTopic(String topic, String remoteContainerName, Address remoteContainerAddress) {
        }

        public void handleLogoutTopic(String topic, String remoteContainerName) {
        }

        public void handleTopic(String topic, Object content, String reason, final String remoteContainerName, Address remoteClientAddress) {
            if (topic.equalsIgnoreCase(TOPIC_COMMAND)) {
                if (content instanceof Command) {
                    this.execute((Command)content, new Responser(){

                        public void sendResponse(Object reply) {
                            CommandService.this.gisServerShell.sendTopic(remoteContainerName, CommandService.TOPIC_COMMAND_RESPONSE, reply);
                        }
                    });
                } else if (content instanceof ContainerStartup) {
                    this.startNewConatiner((ContainerStartup)content);
                } else {
                    this.logWarning("Wrong command ontology: " + content.getClass().getName());
                }
                return;
            }
            this.logger.warning("Unexpected incoming topic: " + topic);
        }

        public static class Shell
        extends ServiceShell {
            transient CommandService theservice = null;

            public Shell() {
            }

            private Shell(ElementaryEntity shellOwner, CommandService _theservice) {
                super(shellOwner);
                this.theservice = _theservice;
            }

            public boolean execute(Command c) {
                return this.theservice.execute(c, null);
            }

            public boolean isValid() {
                return this.theservice != null;
            }

            public void writeExternal(ObjectOutput out) throws IOException {
                super.writeExternal(out);
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
                super.readExternal(in);
            }

            public void setContainer(AgentContainer container) throws Exception {
                ServiceShell ss = container.getServiceManager().getService(null, AgentContainer.COMMANDSERVICE);
                if (ss == null || !(ss instanceof Shell)) {
                    throw new Exception(String.valueOf(container.getContainerName()) + ": Cannot reconect to the Command Service");
                }
                this.theservice = ((Shell)ss).theservice;
            }

            public void postInit() {
            }
        }

        private static interface Responser {
            public void sendResponse(Object var1);
        }
    }

    public static interface Shutdown {
        public void shutdownContainer();
    }

    public static interface ShutdownListener {
        public void shutdownNotification(String var1);
    }
}

