/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.visibility;

import aglobe.container.agent.Agent;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;
import aglobe.ontology.VisibilityUpdate;
import aglobe.service.gis.server.GISServerService;
import aglobe.service.gis.server.GISTopicServerListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullVisibilityAgent
extends Agent
implements GISTopicServerListener {
    long visibilityID = 1L;
    private GISServerService.Shell gisServer = null;
    Map<String, Address> logged_containers = new LinkedHashMap<String, Address>();

    @Override
    public void init(AgentInfo a, int initState) {
        if (this.gisServer == null) {
            this.gisServer = (GISServerService.Shell)this.getContainer().getServiceManager().getService(this, "gis/master");
        }
        if (this.gisServer == null) {
            this.logWarning("GISServerService not running");
            this.stop();
            return;
        }
        this.gisServer.subscribeTopic("VISIBILITY_UPDATES", this);
    }

    @Override
    protected void finish() {
    }

    @Override
    protected void handleIncomingMessage(Message m) {
        this.logWarning("Unexpected message: " + m.toString());
        m.release();
    }

    protected void sendChange(Address receiver, List<Address> seen) {
        if (this.gisServer != null) {
            VisibilityUpdate nfo = new VisibilityUpdate();
            nfo.setVisibilityID(this.visibilityID);
            nfo.getVisibleContainerAddress().addAll(seen);
            this.gisServer.sendTopic(receiver.getContainerName(), "VISIBILITY_UPDATES", nfo);
        }
    }

    private void loginContainer(Address vp) {
        this.addContainer(vp);
    }

    private void logoutContainer(String containeName) {
        Address vp = this.logged_containers.get(containeName);
        this.removeContainer(vp);
    }

    public void addContainer(Address p) {
        this.logged_containers.put(p.getContainerName(), p);
        this.sendChange();
    }

    public void removeContainer(Address p) {
        this.logged_containers.remove(p);
        this.sendChange();
    }

    private void sendChange() {
        for (Address ad : this.logged_containers.values()) {
            ArrayList<Address> ar = new ArrayList<Address>();
            ar.addAll(this.logged_containers.values());
            this.sendChange(ad, ar);
        }
    }

    @Override
    public void handleLoginTopic(String topic, String remoteContainerName, Address remoteContainerAddress) {
        if (topic.equals("VISIBILITY_UPDATES")) {
            if (remoteContainerName == null) {
                return;
            }
            this.loginContainer(remoteContainerAddress);
            return;
        }
        this.logWarning("Unexpected topic login: " + topic);
    }

    @Override
    public void handleLogoutTopic(String topic, String remoteContainerName) {
        if (topic.equals("VISIBILITY_UPDATES")) {
            if (remoteContainerName == null) {
                return;
            }
            this.logoutContainer(remoteContainerName);
            return;
        }
        this.logWarning("Unexpected topic logout: " + topic);
    }

    @Override
    public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
    }
}

