/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.sniffer;

import aglobe.agent.sniffer.DataContainer;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class SnifferTreeModel
implements TreeModel {
    private final DataContainer dataContainer;
    List<TreeModelListener> listeners = new LinkedList<TreeModelListener>();
    static Icon AGENT_ICON = new ImageIcon(SnifferTreeModel.class.getResource("agent.gif"));
    static Icon SERVICE_ICON = new ImageIcon(SnifferTreeModel.class.getResource("service.gif"));
    static Icon SELECTED_ICON = new ImageIcon(SnifferTreeModel.class.getResource("selected.gif"));
    static Icon NON_SELECTED_ICON = new ImageIcon(SnifferTreeModel.class.getResource("nonSelected.gif"));
    static String ROOT = "Containers";
    static String OTHERS = "Others";
    static String AGENTS = "Agents";
    static String SERVICES = "Services";
    private Container[] containers = new Container[0];
    private JPopupMenu popupMenu = new JPopupMenu();
    private JMenuItem doSniffMenuItem = new JMenuItem();
    private JMenuItem dontSniffMenuItem = new JMenuItem();
    private DataContainer.Record selActor = null;

    SnifferTreeModel(DataContainer _owner) {
        this.dataContainer = _owner;
        this.doSniffMenuItem.setText("Add to filter");
        this.doSniffMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SnifferTreeModel.this.selActor != null) {
                    SnifferTreeModel.this.dataContainer.doSniff(SnifferTreeModel.this.selActor, true);
                }
            }
        });
        this.dontSniffMenuItem.setText("Remove from filter");
        this.dontSniffMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SnifferTreeModel.this.selActor != null) {
                    SnifferTreeModel.this.dataContainer.dontSniff(SnifferTreeModel.this.selActor, true);
                }
            }
        });
        this.popupMenu.add(this.doSniffMenuItem);
        this.popupMenu.add(this.dontSniffMenuItem);
    }

    TreeCellRenderer getCellRenderer() {
        return new MyRenderer();
    }

    MouseListener getMouseListener(JTree owner) {
        return new MyMouseListener(owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void containersAdded(DataContainer.ContainerRecord _container) {
        Container[] containerArray = this.containers;
        synchronized (this.containers) {
            ArrayList<Container> _newContainer = new ArrayList<Container>((Collection)Arrays.asList(this.containers));
            Container _new = new Container(_container);
            _newContainer.add(_new);
            this.containers = _newContainer.toArray(new Container[_newContainer.size()]);
            Arrays.sort(this.containers);
            this.fireRootChange();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void containersRemoved(DataContainer.ContainerRecord _container) {
        Container[] containerArray = this.containers;
        synchronized (this.containers) {
            ArrayList _newContainer = new ArrayList(Arrays.asList(this.containers));
            Iterator iter = _newContainer.iterator();
            while (iter.hasNext()) {
                Container item = (Container)iter.next();
                if (item.content != _container) continue;
                iter.remove();
                break;
            }
            this.containers = _newContainer.toArray(new Container[_newContainer.size()]);
            this.fireRootChange();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void agentAdded(DataContainer.AgentRecord _agent) {
        Container[] containerArray = this.containers;
        synchronized (this.containers) {
            int i = -1;
            int k = 0;
            while (k < this.containers.length) {
                if (this.containers[k].content == _agent.container) {
                    i = k;
                    break;
                }
                ++k;
            }
            if (i < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            Entities which = _agent.isAgent ? this.containers[i].agents : this.containers[i].services;
            ArrayList<Agent> _newAgents = new ArrayList<Agent>((Collection)Arrays.asList(which.childs));
            _newAgents.add(new Agent(_agent));
            which.childs = _newAgents.toArray(new Agent[_newAgents.size()]);
            Arrays.sort(which.childs);
            this.fireAgentsChange(this.containers[i], which);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void fireEvent(TreeModelEvent event) {
        Iterator<TreeModelListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().treeStructureChanged(event);
        }
    }

    private void fireRootChange() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{ROOT});
                SnifferTreeModel.this.fireEvent(e);
            }
        });
    }

    private void fireAgentsChange(final Container _container, final Entities _agents) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{ROOT, _container, _agents});
                SnifferTreeModel.this.fireEvent(e);
            }
        });
    }

    public Object getRoot() {
        return ROOT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getChild(Object parent, int index) {
        if (parent == ROOT) {
            Container[] containerArray = this.containers;
            synchronized (this.containers) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.containers[index];
            }
        }
        if (parent instanceof Container) {
            switch (index) {
                case 0: {
                    return ((Container)parent).others;
                }
                case 1: {
                    return ((Container)parent).agents;
                }
                case 2: {
                    return ((Container)parent).services;
                }
            }
            throw new IllegalArgumentException("Bad index passed to ContainerTreeModel");
        }
        if (parent instanceof Entities) {
            return ((Entities)parent).childs[index];
        }
        throw new IllegalArgumentException("Bad parent passed to ContainerTreeModel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildCount(Object parent) {
        if (parent == ROOT) {
            Container[] containerArray = this.containers;
            synchronized (this.containers) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.containers.length;
            }
        }
        if (parent instanceof Container) {
            return 3;
        }
        if (parent instanceof Others) {
            return 0;
        }
        if (parent instanceof Entities) {
            return ((Entities)parent).childs.length;
        }
        throw new IllegalArgumentException("Bad parent passed to ContainerTreeModel");
    }

    public boolean isLeaf(Object node) {
        return node != ROOT && !(node instanceof Container) && !(node instanceof Entities);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException("Method ContainerTreeModel.valueForPathChanged should have never been called.");
    }

    private int getIndexOf(Object[] array, Object node) {
        int k = 0;
        while (k < array.length) {
            if (array[k] == node) {
                return k;
            }
            ++k;
        }
        throw new IllegalArgumentException("Bad child node passed to ContainerTreeModel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == ROOT) {
            Container[] containerArray = this.containers;
            synchronized (this.containers) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.getIndexOf(this.containers, child);
            }
        }
        if (parent instanceof Container) {
            if (((Container)parent).others == child) {
                return 0;
            }
            if (((Container)parent).agents == child) {
                return 1;
            }
            if (((Container)parent).services == child) {
                return 2;
            }
            throw new IllegalArgumentException("Bad child node passed to ContainerTreeModel");
        }
        if (parent instanceof Entities) {
            return this.getIndexOf(((Entities)parent).childs, child);
        }
        throw new IllegalArgumentException("Bad parent passed to ContainerTreeModel");
    }

    public void addTreeModelListener(TreeModelListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    public DataContainer.Record getRecord(Object _object) {
        if (_object == null) {
            return null;
        }
        if (_object instanceof Others) {
            return ((Others)_object).container.content;
        }
        if (_object instanceof Agent) {
            return ((Agent)_object).content;
        }
        return null;
    }

    private class Container
    implements Comparable {
        final DataContainer.ContainerRecord content;
        final Others others;
        final Entities agents;
        final Entities services;

        private Container(DataContainer.ContainerRecord _content) {
            this.others = new Others(this);
            this.agents = new Entities(AGENTS);
            this.services = new Entities(SERVICES);
            this.content = _content;
        }

        public int compareTo(Object _to) {
            if (_to instanceof Container) {
                return this.content.name.compareTo(((Container)_to).content.name);
            }
            return 0;
        }

        public String toString() {
            return this.content.name;
        }
    }

    private class Entities {
        final String name;
        Agent[] childs = new Agent[0];

        private Entities(String _name) {
            this.name = _name;
        }

        public String toString() {
            return this.name;
        }
    }

    private class Others {
        final String name = OTHERS;
        final Container container;

        private Others(Container _container) {
            this.container = _container;
        }

        public String toString() {
            return this.name;
        }
    }

    private class Agent
    implements Comparable {
        final DataContainer.AgentRecord content;

        private Agent(DataContainer.AgentRecord _content) {
            this.content = _content;
        }

        public String toString() {
            return this.content.name;
        }

        public int compareTo(Object _to) {
            if (_to instanceof Agent) {
                return this.content.name.compareTo(((Agent)_to).content.name);
            }
            return 0;
        }
    }

    private class MyRenderer
    extends DefaultTreeCellRenderer {
        private Font normalFont = null;
        private Font boldFont;

        private MyRenderer() {
        }

        private void setFonts() {
            this.normalFont = this.getFont();
            this.boldFont = this.getFont().deriveFont(1);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (this.normalFont == null) {
                this.setFonts();
            }
            this.setFont(this.normalFont);
            if (value == ROOT) {
                this.setIcon(this.openIcon);
            } else if (value instanceof Container) {
                if (expanded) {
                    this.setIcon(this.openIcon);
                } else {
                    this.setIcon(this.closedIcon);
                }
                if (((Container)value).content.isLogged()) {
                    this.setFont(this.boldFont);
                }
            } else if (value instanceof Others) {
                if (((Others)value).container.content.isSniffed()) {
                    this.setIcon(SELECTED_ICON);
                } else {
                    this.setIcon(NON_SELECTED_ICON);
                }
            } else if (value instanceof Entities) {
                if (((Entities)value).name == AGENTS) {
                    this.setIcon(AGENT_ICON);
                } else {
                    this.setIcon(SERVICE_ICON);
                }
            } else if (value instanceof Agent) {
                if (((Agent)value).content.isSniffed()) {
                    this.setIcon(SELECTED_ICON);
                } else {
                    this.setIcon(NON_SELECTED_ICON);
                }
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }

    private class MyMouseListener
    implements MouseListener {
        private final JTree tree;

        private MyMouseListener(JTree _owner) {
            this.tree = _owner;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                TreePath selPath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (selPath == null) {
                    return;
                }
                Object lastItem = selPath.getLastPathComponent();
                DataContainer.Record record = SnifferTreeModel.this.getRecord(lastItem);
                if (record != null) {
                    SnifferTreeModel.this.dataContainer.changeShowing(record, true);
                }
            } else if (mouseEvent.getButton() == 3) {
                TreePath selPath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (selPath == null) {
                    return;
                }
                Object lastItem = selPath.getLastPathComponent();
                SnifferTreeModel.this.selActor = SnifferTreeModel.this.getRecord(lastItem);
                if (SnifferTreeModel.this.selActor != null) {
                    this.tree.setSelectionRow(this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY()));
                    if (SnifferTreeModel.this.selActor.isSniffed()) {
                        SnifferTreeModel.this.doSniffMenuItem.setEnabled(false);
                        SnifferTreeModel.this.dontSniffMenuItem.setEnabled(true);
                    } else {
                        SnifferTreeModel.this.doSniffMenuItem.setEnabled(true);
                        SnifferTreeModel.this.dontSniffMenuItem.setEnabled(false);
                    }
                    SnifferTreeModel.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

