/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.sniffer;

import aglobe.agent.sniffer.AboutGUI;
import aglobe.agent.sniffer.DataContainer;
import aglobe.agent.sniffer.DetailHeaderPanel;
import aglobe.agent.sniffer.DetailMainPanel;
import aglobe.agent.sniffer.DrawingConstants;
import aglobe.agent.sniffer.LeftHeaderPanel;
import aglobe.agent.sniffer.OptionGUI;
import aglobe.agent.sniffer.SnifferAgent;
import aglobe.util.gui.RememberPositionJFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.Border;

class SnifferGUI
extends RememberPositionJFrame {
    final SnifferAgent owner;
    private final DataContainer dataContainer;
    private AboutGUI aboutWindow;
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenu1 = new JMenu();
    JMenuItem closeSniffer = new JMenuItem();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JSplitPane jSplitPanel = new JSplitPane();
    JPanel previewPanel = new JPanel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JScrollPane detailedScrollPanel = new JScrollPane();
    final DetailMainPanel detailMainPanel;
    final DetailHeaderPanel detailHeaderPanel;
    final LeftHeaderPanel leftHeaderPanel;
    JPanel cornerPanel1 = new JPanel();
    JPanel cornerPanel2 = new JPanel();
    Border border1;
    JMenuItem showContainerGUI_MenuItem = new JMenuItem();
    JScrollPane previewScrollPanel = new JScrollPane();
    JTree previewTree;
    JMenu jMenu2 = new JMenu();
    JMenuItem jMenuItem1 = new JMenuItem();
    JPanel statusPanel = new JPanel();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JLabel jLabel1 = new JLabel();
    JLabel historyUsed = new JLabel();
    JLabel maxHistory = new JLabel();
    JLabel jLabel3 = new JLabel();
    JLabel parsedMsg = new JLabel();
    JMenuItem option_MenuItem = new JMenuItem();

    SnifferGUI(SnifferAgent _owner, DataContainer _dataContainer) {
        super(_owner);
        this.owner = _owner;
        this.dataContainer = _dataContainer;
        this.detailMainPanel = new DetailMainPanel(this.dataContainer);
        this.detailHeaderPanel = new DetailHeaderPanel(this.dataContainer);
        this.leftHeaderPanel = new LeftHeaderPanel(this.dataContainer);
        try {
            this.jbInit();
            this.setSize(300, 300);
            this.jSplitPanel.setDividerLocation(100);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dataContainer.setHeaderPanel(this.detailHeaderPanel);
        this.dataContainer.setMainPanel(this.detailMainPanel);
        this.dataContainer.setLeftHeaderPanel(this.leftHeaderPanel);
        this.dataContainer.setContainerTree(this.previewTree);
        this.setVisible(true);
    }

    protected void saveWindowSettings() {
        this.store.putInt("gui/divider", this.jSplitPanel.getDividerLocation());
    }

    protected void loadWindowSettings() {
        int divPos = this.jSplitPanel.getDividerLocation();
        this.jSplitPanel.setDividerLocation(this.store.getInt("gui/divider", divPos));
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder();
        this.setJMenuBar(this.jMenuBar1);
        this.setState(0);
        this.setTitle("Sniffer");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                SnifferGUI.this.this_windowClosed(e);
            }

            public void windowClosing(WindowEvent e) {
                SnifferGUI.this.this_windowClosing(e);
            }
        });
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.jSplitPanel.setMinimumSize(new Dimension(250, 250));
        this.jSplitPanel.setDividerSize(3);
        this.jSplitPanel.setBorder(null);
        this.previewPanel.setLayout(this.gridBagLayout2);
        this.cornerPanel1.setBackground(DrawingConstants.BACKGROUND_COLOR);
        this.cornerPanel2.setBackground(DrawingConstants.BACKGROUND_COLOR);
        this.previewTree = new JTree();
        this.previewTree.setModel(this.dataContainer.getTreeModel());
        this.previewTree.setCellRenderer(this.dataContainer.getTreeCellRenderer());
        this.previewTree.getSelectionModel().setSelectionMode(1);
        this.previewTree.addMouseListener(this.dataContainer.getMouseListener(this.previewTree));
        this.jMenu1.setText("File");
        this.closeSniffer.setText("Close Sniffer");
        this.closeSniffer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SnifferGUI.this.closeSniffer_actionPerformed(e);
            }
        });
        this.showContainerGUI_MenuItem.setText("Show agent container GUI");
        this.showContainerGUI_MenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SnifferGUI.this.showContainerGUI_MenuItem_actionPerformed(e);
            }
        });
        this.jMenu2.setText("About");
        this.jMenuItem1.setText("About Sniffer");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SnifferGUI.this.aboutItem_actionPerformed(e);
            }
        });
        this.statusPanel.setLayout(this.gridBagLayout3);
        this.jLabel1.setText("Message history buffer:");
        this.historyUsed.setText("0");
        this.maxHistory.setText("/0");
        this.jLabel3.setText("Total sniffed messages:");
        this.parsedMsg.setVerifyInputWhenFocusTarget(true);
        this.parsedMsg.setText("0");
        this.option_MenuItem.setText("Options");
        this.option_MenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SnifferGUI.this.option_MenuItem_actionPerformed(e);
            }
        });
        this.jMenuBar1.add(this.jMenu1);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu1.add(this.showContainerGUI_MenuItem);
        this.jMenu1.addSeparator();
        this.jMenu1.add(this.option_MenuItem);
        this.jMenu1.addSeparator();
        this.jMenu1.add(this.closeSniffer);
        this.getContentPane().add((Component)this.jSplitPanel, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jSplitPanel.add((Component)this.previewPanel, "left");
        this.previewPanel.add((Component)this.previewScrollPanel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jSplitPanel.add((Component)this.detailedScrollPanel, "right");
        this.getContentPane().add((Component)this.statusPanel, new GridBagConstraints(0, 2, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.detailedScrollPanel.getViewport().add((Component)this.detailMainPanel, null);
        this.previewScrollPanel.getViewport().add((Component)this.previewTree, null);
        this.jMenu2.add(this.jMenuItem1);
        this.statusPanel.add((Component)this.jLabel1, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.statusPanel.add((Component)this.historyUsed, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.statusPanel.add((Component)this.maxHistory, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 15), 0, 0));
        this.statusPanel.add((Component)this.jLabel3, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.statusPanel.add((Component)this.parsedMsg, new GridBagConstraints(8, 0, 1, 1, 0.1, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.detailedScrollPanel.setColumnHeaderView(this.detailHeaderPanel);
        this.detailedScrollPanel.setRowHeaderView(this.leftHeaderPanel);
        this.detailedScrollPanel.setCorner("UPPER_RIGHT_CORNER", this.cornerPanel1);
        this.detailedScrollPanel.setCorner("UPPER_LEFT_CORNER", this.cornerPanel2);
    }

    void closeSniffer_actionPerformed(ActionEvent e) {
        this.owner.close_gui();
    }

    void showContainerGUI_MenuItem_actionPerformed(ActionEvent e) {
        this.owner.showContainerGUI();
    }

    void aboutItem_actionPerformed(ActionEvent e) {
        if (this.aboutWindow == null) {
            this.aboutWindow = new AboutGUI();
        }
        this.aboutWindow.setVisible(true);
    }

    void this_windowClosed(WindowEvent e) {
        this.owner.close_gui();
    }

    void this_windowClosing(WindowEvent e) {
        this.owner.close_gui();
    }

    void option_MenuItem_actionPerformed(ActionEvent e) {
        OptionGUI options = new OptionGUI(this);
        options.setVisible(true);
    }
}

