/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.sniffer;

import aglobe.agent.sniffer.DataContainer;
import aglobe.agent.sniffer.SnifferGUI;
import aglobe.container.AgentContainer;
import aglobe.container.Store;
import aglobe.container.agent.Agent;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Command;
import aglobe.ontology.Message;
import aglobe.service.gis.server.GISServerService;
import aglobe.service.gis.server.GISTopicServerListener;
import aglobe.service.link.LinkMessageCopyListener;
import aglobe.service.link.LinkNeighbourListener;
import aglobe.service.link.LinkService;
import aglobe.util.AglobeXMLtools;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;

public class SnifferAgent
extends Agent
implements GISTopicServerListener {
    static final String SNIFFER_VERSION = "1.2";
    public SnifferGUI gui;
    private GISServerService.Shell gisServer = null;
    private LinkService.Shell link = null;
    private DataContainer dataContainer;
    int msgHistoryLength;
    private static final int MSG_HISTORY_LENGTH_DEFAULT = 4000;
    private static final String MSG_HISTORY_LENGTH_NAME = "MSG_HISTORY_LENGTH_NAME";
    String addressFilter;
    Pattern addressFilterPattern;
    private static final String ADDRESS_FILTER_DEFAULT = "(agent|others)";
    private static final String ADDRESS_FILTER_NAME = "ADDRESS_FILTER";
    private Store store;
    private AgentContainer.CommandService.Shell cshell;

    public void init(AgentInfo a, int initState) {
        this.store = this.getContainer().getAgentStore(this.getName());
        this.msgHistoryLength = this.store.getInt(MSG_HISTORY_LENGTH_NAME, 4000);
        this.addressFilter = this.store.getString(ADDRESS_FILTER_NAME, ADDRESS_FILTER_DEFAULT);
        this.addressFilterPattern = Pattern.compile(this.addressFilter, 2);
        this.dataContainer = new DataContainer(this);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    SnifferAgent.this.gui = new SnifferGUI(SnifferAgent.this, SnifferAgent.this.dataContainer);
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SnifferAgent.this.gui.maxHistory.setText("/" + SnifferAgent.this.msgHistoryLength);
                }
            });
        }
        catch (Exception ex) {
            this.logSevere("Cannot create GUI due to: " + ex + "\nSniffer will be stopped.");
            this.stop();
            return;
        }
        if (this.gisServer == null) {
            this.gisServer = (GISServerService.Shell)this.getContainer().getServiceManager().getService(this, "gis/master");
        }
        if (this.gisServer == null) {
            this.link = (LinkService.Shell)this.getContainer().getServiceManager().getService(this, "container/link");
            if (this.link == null) {
                this.logSevere("Neither GISServerService nor LinkService not running");
                this.stop();
                return;
            }
            this.link.subscribeNeighbour(new LinkNeighbourListener(){

                public void handleRegister(Address containerAddress) {
                    SnifferAgent.this.loginContainer(containerAddress);
                }

                public void handleDeregister(Address containerAddress) {
                    SnifferAgent.this.logoutContainer(containerAddress.getContainerName());
                }

                public void addEvent(Runnable e) {
                    SnifferAgent.this.addEvent(e);
                }
            });
            this.link.subsribeMessageCopy(new LinkMessageCopyListener(){

                public void handleMessageCopy(byte[] serializedMessage, String undeliverable) {
                    try {
                        Message m = Message.getMessageFormBinarySerializedData(serializedMessage, SnifferAgent.this);
                        SnifferAgent.this.incomingMessageCopy(m, Boolean.valueOf(undeliverable));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                public void addEvent(Runnable e) {
                    SnifferAgent.this.addEvent(e);
                }
            });
        } else {
            this.gisServer.subscribeTopic("VISIBILITY_UPDATES", this);
            this.gisServer.subscribeTopic("OUTGOING_MESSAGE_COPY", this);
        }
        this.cshell = (AgentContainer.CommandService.Shell)this.getContainer().getServiceManager().getService(null, "container/command");
    }

    protected void finish() {
        if (this.gui != null) {
            this.gui.setVisible(false);
        }
    }

    protected void handleIncomingMessage(Message m) {
        this.logSevere("Unexpected message: " + m.toString());
        m.release();
    }

    private void loginContainer(Address containerAddress) {
        this.dataContainer.loginContainer(containerAddress);
    }

    private void logoutContainer(String containerName) {
        this.dataContainer.logoutContainer(containerName);
    }

    private void incomingMessageCopy(Message m, boolean undeliverable) {
        if (m.isMulticast()) {
            this.logWarning("Multicast messages are not supported yet");
            return;
        }
        this.dataContainer.incomingMessageCopy(m, undeliverable);
    }

    void close_gui() {
        this.kill();
    }

    void showContainerGUI() {
        if (this.cshell != null) {
            Command c = new Command();
            c.setName("GUI");
            c.getAglobeParam().add(AglobeXMLtools.makeAglobeParam("Visible", Boolean.toString(true)));
            this.cshell.execute(c);
        }
    }

    public void handleLoginTopic(String topic, String remoteContainerName, Address remoteContainerAddress) {
        if (topic.equals("VISIBILITY_UPDATES")) {
            Address rAdr = remoteContainerAddress;
            if (rAdr == null) {
                rAdr = this.getAddress().deriveContainerAddress();
            }
            this.loginContainer(rAdr);
            return;
        }
    }

    public void handleLogoutTopic(String topic, String remoteContainerName) {
        if (topic.equals("VISIBILITY_UPDATES")) {
            this.logoutContainer(remoteContainerName);
            return;
        }
    }

    public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
        if (topic.equals("OUTGOING_MESSAGE_COPY")) {
            try {
                Message m = Message.getMessageFormBinarySerializedData((byte[])content, this);
                this.incomingMessageCopy(m, Boolean.valueOf(reason));
            }
            catch (Exception ex) {
                this.logWarning("Problem with getting message copy: " + ex + "\nOrginal content: " + content);
                try {
                    Message m = Message.getMessageFormBinarySerializedData((byte[])content, this);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return;
        }
    }

    void updateMsgHistoryLength(int newMsgHistoryLength) {
        this.msgHistoryLength = newMsgHistoryLength;
        this.store.putInt(MSG_HISTORY_LENGTH_NAME, this.msgHistoryLength);
        if (this.gui != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SnifferAgent.this.gui.maxHistory.setText("/" + SnifferAgent.this.msgHistoryLength);
                }
            });
        }
        this.dataContainer.updateMsgHistoryLength();
    }

    void updateAddressFilter(String newAddressFilter) {
        this.addressFilter = newAddressFilter;
        this.store.putString(ADDRESS_FILTER_NAME, this.addressFilter);
        this.addressFilterPattern = Pattern.compile(this.addressFilter, 2);
    }
}

