/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.sniffer;

import aglobe.agent.sniffer.DataContainer;
import aglobe.agent.sniffer.DrawingConstants;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JPanel;

class LeftHeaderPanel
extends JPanel {
    private final DataContainer dataContainer;

    LeftHeaderPanel(DataContainer _dataContainer) {
        this.dataContainer = _dataContainer;
        this.setBackground(DrawingConstants.BACKGROUND_COLOR);
        this.repaintThis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void repaintThis() {
        DataContainer dataContainer = this.dataContainer;
        synchronized (dataContainer) {
            this.setPreferredSize(new Dimension(30, (this.dataContainer.filteredMsg.size() + 1) * 10));
        }
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void repaintLastMessage() {
        DataContainer dataContainer = this.dataContainer;
        synchronized (dataContainer) {
            this.setPreferredSize(new Dimension(30, (this.dataContainer.filteredMsg.size() + 1) * 10));
        }
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Rectangle currentClip = g2.getClipBounds();
        g2.setColor(Color.BLACK);
        g2.setFont(DrawingConstants.BOX_FONT);
        int msgNumFrom = (int)Math.round((double)currentClip.y / 10.0) - 1;
        int msgNumTo = (int)Math.floor((double)currentClip.height / 10.0) + 1 + msgNumFrom;
        if (msgNumFrom < 0) {
            msgNumFrom = 0;
        }
        FontMetrics metrics = g.getFontMetrics();
        DataContainer dataContainer = this.dataContainer;
        synchronized (dataContainer) {
            int msgCnt = this.dataContainer.filteredMsg.size();
            if (msgNumTo >= msgCnt) {
                msgNumTo = msgCnt - 1;
            }
            int k = msgNumFrom;
            while (k <= msgNumTo) {
                DataContainer.FilteredMessageCover mc = this.dataContainer.filteredMsg.get(k);
                int y = (k + 1) * 10 + 4;
                String text = "" + mc.msgCover.msgId;
                int width = metrics.stringWidth(text);
                g2.drawString(text, 29 - width, y);
                ++k;
            }
        }
    }
}

