/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.sniffer;

import aglobe.agent.sniffer.ACLMessageGUI;
import aglobe.agent.sniffer.DataContainer;
import aglobe.agent.sniffer.DrawingConstants;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JPanel;

class DetailMainPanel
extends JPanel {
    private final DataContainer dataContainer;
    ACLMessageGUI aclMessageGUI = null;
    private long selectedMsg = -1L;

    DetailMainPanel(DataContainer _dataContainer) {
        this.dataContainer = _dataContainer;
        this.setBackground(DrawingConstants.BACKGROUND_COLOR);
        this.addMouseListener(new myMouseListener(this));
        this.repaintThis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void repaintThis() {
        DataContainer dataContainer = this.dataContainer;
        synchronized (dataContainer) {
            this.setPreferredSize(new Dimension(54 * this.dataContainer.filteredObjects.size(), 10 * (this.dataContainer.filteredMsg.size() + 1)));
        }
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void repaintLastMessage() {
        DataContainer dataContainer = this.dataContainer;
        synchronized (dataContainer) {
            this.setPreferredSize(new Dimension(54 * this.dataContainer.filteredObjects.size(), 10 * (this.dataContainer.filteredMsg.size() + 1)));
        }
        this.revalidate();
        this.repaint();
    }

    private void drawMessage(Graphics2D g, int x1, int y1, int x2, int y2) {
        g.drawLine(x1, y1, x2, y2);
        g.setStroke(DrawingConstants.REGULAR_MESSAGE_STROKE);
        int direction = (x2 < x1 ? 1 : -1) * 7;
        g.drawLine(x2, y2, x2 + direction, y2 + 4);
        g.drawLine(x2, y2, x2 + direction, y2 - 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Rectangle currentClip = g2.getClipBounds();
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(DrawingConstants.ACTOR_LINE_COLOR);
        int msgNumFrom = (int)Math.round((double)currentClip.y / 10.0) - 1;
        int msgNumTo = (int)Math.floor((double)currentClip.height / 10.0) + 1 + msgNumFrom;
        if (msgNumFrom < 0) {
            msgNumFrom = 0;
        }
        DataContainer dataContainer = this.dataContainer;
        synchronized (dataContainer) {
            int actorCnt = this.dataContainer.filteredObjects.size();
            int msgCnt = this.dataContainer.filteredMsg.size();
            int y = (msgCnt + 1) * 10;
            int k = 0;
            while (k < actorCnt) {
                int x = 27 + k * 54;
                g2.drawLine(x, 0, x, y);
                ++k;
            }
            if (msgNumTo >= msgCnt) {
                msgNumTo = msgCnt - 1;
            }
            k = msgNumFrom;
            while (k <= msgNumTo) {
                DataContainer.FilteredMessageCover mc = this.dataContainer.filteredMsg.get(k);
                g2.setColor(mc.msgCover.messageColor);
                if (mc.msgCover.undeliverable) {
                    g2.setStroke(mc.msgCover.msgId != this.selectedMsg ? DrawingConstants.INACCESSIBLE_MESSAGE_STROKE : DrawingConstants.SELECTED_INACCESSIBLE_MESSAGE_STROKE);
                } else {
                    g2.setStroke(mc.msgCover.msgId != this.selectedMsg ? DrawingConstants.REGULAR_MESSAGE_STROKE : DrawingConstants.SELECTED_REGULAR_MESSAGE_STROKE);
                }
                y = (k + 1) * 10;
                this.drawMessage(g2, 27 + mc.fromPosition * 54, y, 27 + mc.toPosition * 54, y);
                ++k;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMouseClick(int x, int y) {
        DataContainer dataContainer = this.dataContainer;
        synchronized (dataContainer) {
            int right;
            int left;
            int msgCnt = this.dataContainer.filteredMsg.size();
            int _selectedMsg = (int)Math.round((double)y / 10.0) - 1;
            if (_selectedMsg < 0 || _selectedMsg >= msgCnt) {
                this.selectedMsg = -1L;
                this.repaint();
                this.showACLMessage(null);
                return;
            }
            DataContainer.FilteredMessageCover mc = this.dataContainer.filteredMsg.get(_selectedMsg);
            if (mc.fromPosition < mc.toPosition) {
                left = mc.fromPosition * 54 + 27;
                right = mc.toPosition * 54 + 27;
            } else {
                right = mc.fromPosition * 54 + 27;
                left = mc.toPosition * 54 + 27;
            }
            if (x < left || x > right) {
                this.selectedMsg = -1L;
                this.repaint();
                this.showACLMessage(null);
                return;
            }
            this.selectedMsg = mc.msgCover.msgId;
            this.repaint();
            this.showACLMessage(mc.msgCover);
        }
    }

    void setSelectedMsg(long selectedMsgId) {
        this.selectedMsg = selectedMsgId;
        this.repaint();
    }

    void showACLMessage(DataContainer.MessageCover mc) {
        if (mc == null && this.aclMessageGUI != null) {
            this.aclMessageGUI.showGUI(false);
            return;
        }
        if (mc == null) {
            return;
        }
        if (this.aclMessageGUI == null) {
            this.aclMessageGUI = new ACLMessageGUI(this);
        }
        ArrayList<DataContainer.MessageCover> mcs = new ArrayList<DataContainer.MessageCover>();
        mcs.add(mc);
        int cur = 0;
        String convId = mc.msg.getConversationID();
        if (convId != null) {
            int i;
            boolean found;
            ArrayList<DataContainer.MessageCover> next = new ArrayList<DataContainer.MessageCover>();
            for (DataContainer.FilteredMessageCover item : this.dataContainer.filteredMsg) {
                if (item.msgCover == mc || !convId.equals(item.msgCover.msg.getConversationID())) continue;
                next.add(item.msgCover);
            }
            String inReplyTo = mc.msg.getInReplyTo();
            boolean stop = false;
            while (!stop && inReplyTo != null) {
                found = false;
                i = 0;
                while (i < next.size()) {
                    if (inReplyTo.equals(((DataContainer.MessageCover)next.get((int)i)).msg.getReplyWith())) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (found) {
                    DataContainer.MessageCover p = (DataContainer.MessageCover)next.remove(i);
                    mcs.add(0, p);
                    ++cur;
                    inReplyTo = p.msg.getInReplyTo();
                    continue;
                }
                stop = true;
            }
            String replyWith = mc.msg.getReplyWith();
            if (replyWith != null) {
                stop = false;
                while (!stop) {
                    found = false;
                    i = 0;
                    while (i < next.size()) {
                        if (replyWith.equals(((DataContainer.MessageCover)next.get((int)i)).msg.getInReplyTo())) {
                            found = true;
                            break;
                        }
                        ++i;
                    }
                    if (found) {
                        DataContainer.MessageCover p = (DataContainer.MessageCover)next.remove(i);
                        mcs.add(p);
                        replyWith = p.msg.getReplyWith();
                        continue;
                    }
                    stop = true;
                }
            }
        }
        this.aclMessageGUI.setACLMessage(mcs.toArray(new DataContainer.MessageCover[mcs.size()]), cur);
        this.aclMessageGUI.showGUI(true);
    }

    void clearSelection() {
        this.selectedMsg = -1L;
        this.repaint();
    }

    void hideACLMessageWindow() {
        if (this.aclMessageGUI != null) {
            this.aclMessageGUI.showGUI(false);
        }
    }

    class myMouseListener
    implements MouseListener {
        private final DetailMainPanel owner;

        myMouseListener(DetailMainPanel _owner) {
            this.owner = _owner;
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() >= 2) {
                this.owner.parseMouseClick(e.getX(), e.getY());
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }
}

