/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.sniffer;

import aglobe.agent.sniffer.DataContainer;
import aglobe.agent.sniffer.DrawingConstants;
import aglobe.agent.sniffer.SnifferTreeModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

class DetailHeaderPanel
extends JPanel {
    private final DataContainer dataContainer;
    private DataContainer.Record selectedItem = null;
    private boolean selectedContainer = false;
    private JPopupMenu popupMenu = new JPopupMenu();
    private JMenuItem dontSniffMenuItem = new JMenuItem();
    private JMenuItem moveLeft = new JMenuItem();
    private JMenuItem moveRight = new JMenuItem();

    DetailHeaderPanel(DataContainer _dataContainer) {
        this.dataContainer = _dataContainer;
        this.setBackground(DrawingConstants.BACKGROUND_COLOR);
        this.repaintThis();
        this.dontSniffMenuItem.setText("Remove from filter");
        this.dontSniffMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!DetailHeaderPanel.this.selectedContainer && DetailHeaderPanel.this.selectedItem != null && DetailHeaderPanel.this.selectedItem.isSniffed()) {
                    DetailHeaderPanel.this.dataContainer.dontSniff(DetailHeaderPanel.this.selectedItem, true);
                }
            }
        });
        this.moveLeft.setText("Move Left");
        this.moveLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DetailHeaderPanel.this.selectedItem != null) {
                    if (!DetailHeaderPanel.this.selectedContainer) {
                        DetailHeaderPanel.this.dataContainer.moveActorLeft(DetailHeaderPanel.this.selectedItem);
                    } else {
                        DetailHeaderPanel.this.dataContainer.moveContainerLeft(DetailHeaderPanel.this.selectedItem);
                    }
                }
            }
        });
        this.moveRight.setText("Move Right");
        this.moveRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DetailHeaderPanel.this.selectedItem != null) {
                    if (!DetailHeaderPanel.this.selectedContainer) {
                        DetailHeaderPanel.this.dataContainer.moveActorRight(DetailHeaderPanel.this.selectedItem);
                    } else {
                        DetailHeaderPanel.this.dataContainer.moveContainerRight(DetailHeaderPanel.this.selectedItem);
                    }
                }
            }
        });
        this.popupMenu.add(this.dontSniffMenuItem);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.moveLeft);
        this.popupMenu.add(this.moveRight);
        this.addMouseListener(new MyMouseListener(this));
    }

    private void drawActorBox(Graphics2D g, int position, Color color, String text, boolean selected) {
        int box_X_center = 27 + position * 54;
        if (selected) {
            g.setStroke(DrawingConstants.BOX_ACTOR_SELECTED_STROKE);
        } else {
            g.setStroke(DrawingConstants.BOX_ACTOR_STROKE);
        }
        g.setColor(color);
        g.fillRoundRect(box_X_center - 24, 20, 48, 30, 10, 10);
        g.setColor(DrawingConstants.BOX_BORDER_COLOR);
        g.drawRoundRect(box_X_center - 24, 20, 48, 30, 10, 10);
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(DrawingConstants.ACTOR_LINE_COLOR);
        g.drawLine(box_X_center, 50, box_X_center, 60);
        FontMetrics metrics = g.getFontMetrics();
        int width = metrics.stringWidth(text);
        int height = metrics.getHeight() - 4;
        if (width <= 48) {
            g.drawString(text, box_X_center - width / 2, 40);
        } else {
            int numLines = (int)Math.ceil((double)width / 46.0);
            int startY = 40 - height * (int)Math.floor((double)numLines / 2.0);
            int partLen = (int)Math.floor((double)text.length() / (double)numLines);
            int i = 0;
            while (i < numLines) {
                String part = i + 1 == numLines ? text.substring(i * partLen) : text.substring(i * partLen, (i + 1) * partLen);
                int partWidth = metrics.stringWidth(part);
                g.drawString(part, box_X_center - partWidth / 2, startY);
                startY += height;
                ++i;
            }
        }
    }

    private void drawContainerBox(Graphics2D g, int position, int length, Color color, String text, boolean selected) {
        int x1 = 27 + position * 54 - 24 - 2;
        int width = (length - 1) * 54 + 4 + 48;
        if (selected) {
            g.setStroke(DrawingConstants.BOX_CONTAINER_SELECTED_STROKE);
        } else {
            g.setStroke(DrawingConstants.BOX_CONTAINER_STROKE);
        }
        g.setColor(color);
        g.fillRect(x1, 5, width, 50);
        g.setColor(DrawingConstants.BOX_BORDER_COLOR);
        g.drawRect(x1, 5, width, 50);
        FontMetrics metrics = g.getFontMetrics();
        int textWidth = metrics.stringWidth(text);
        g.drawString(text, x1 + width / 2 - textWidth / 2, 15);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaintThis() {
        DataContainer dataContainer = this.dataContainer;
        synchronized (dataContainer) {
            this.setPreferredSize(new Dimension(54 * this.dataContainer.filteredObjects.size(), 60));
        }
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        int i = -1;
        g2.setStroke(new BasicStroke(1.0f));
        g2.setFont(DrawingConstants.BOX_FONT);
        DataContainer dataContainer = this.dataContainer;
        synchronized (dataContainer) {
            for (DataContainer.Record item : this.dataContainer.filteredObjects) {
                DataContainer.ContainerRecord container;
                ++i;
                if (item.isFirstFromThisContainer()) {
                    container = item.getContainer();
                    this.drawContainerBox(g2, i, item.countFromThisContainer, container.isLogged() ? DrawingConstants.BOX_LOGGED_CONTAINER_COLOR : DrawingConstants.BOX_UNLOGGED_CONTAINER_COLOR, container.name, this.selectedContainer && this.selectedItem != null && container == this.selectedItem.getContainer());
                }
                if (item instanceof DataContainer.ContainerRecord) {
                    container = (DataContainer.ContainerRecord)item;
                    this.drawActorBox(g2, i, DrawingConstants.BOX_OTHER_ACTOR, SnifferTreeModel.OTHERS, !this.selectedContainer && this.selectedItem == container);
                    continue;
                }
                if (!(item instanceof DataContainer.AgentRecord)) continue;
                DataContainer.AgentRecord agent = (DataContainer.AgentRecord)item;
                this.drawActorBox(g2, i, agent.isAgent ? DrawingConstants.BOX_AGENT_ACTOR : DrawingConstants.BOX_SERVICE_ACTOR, agent.name, !this.selectedContainer && this.selectedItem == agent);
            }
        }
    }

    private void clearSelection() {
        if (this.selectedItem != null) {
            this.selectedItem = null;
            this.selectedContainer = false;
            this.repaint();
        }
    }

    private void changeSelection(DataContainer.Record _record, boolean _isContainer) {
        if (this.selectedItem != _record || this.selectedContainer != _isContainer) {
            this.selectedItem = _record;
            this.selectedContainer = _isContainer;
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findItem(int x, int y) {
        DataContainer dataContainer = this.dataContainer;
        synchronized (dataContainer) {
            int position = x - 0;
            if (position < 0) {
                this.clearSelection();
                return;
            }
            if ((position = (int)Math.floor((double)position / 54.0)) >= this.dataContainer.filteredObjects.size()) {
                this.clearSelection();
                return;
            }
            if (y > 20 && y < 50) {
                this.changeSelection(this.dataContainer.filteredObjects.get(position), false);
            } else if (y > 5 && y < 20) {
                this.changeSelection(this.dataContainer.filteredObjects.get(position), true);
            }
        }
    }

    private class MyMouseListener
    implements MouseListener {
        private final DetailHeaderPanel owner;

        public MyMouseListener(DetailHeaderPanel _owner) {
            this.owner = _owner;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 3 && DetailHeaderPanel.this.selectedItem != null) {
                if (DetailHeaderPanel.this.selectedContainer) {
                    DetailHeaderPanel.this.dontSniffMenuItem.setEnabled(false);
                    if (DetailHeaderPanel.this.selectedItem.isFisrtContainer()) {
                        DetailHeaderPanel.this.moveLeft.setEnabled(false);
                    } else {
                        DetailHeaderPanel.this.moveLeft.setEnabled(true);
                    }
                    if (DetailHeaderPanel.this.selectedItem.isLastContainer()) {
                        DetailHeaderPanel.this.moveRight.setEnabled(false);
                    } else {
                        DetailHeaderPanel.this.moveRight.setEnabled(true);
                    }
                } else {
                    DetailHeaderPanel.this.dontSniffMenuItem.setEnabled(true);
                    if (DetailHeaderPanel.this.selectedItem.isFirstFromThisContainer()) {
                        DetailHeaderPanel.this.moveLeft.setEnabled(false);
                    } else {
                        DetailHeaderPanel.this.moveLeft.setEnabled(true);
                    }
                    if (((DetailHeaderPanel)DetailHeaderPanel.this).selectedItem.isLast) {
                        DetailHeaderPanel.this.moveRight.setEnabled(false);
                    } else {
                        DetailHeaderPanel.this.moveRight.setEnabled(true);
                    }
                }
                DetailHeaderPanel.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.owner.findItem(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

