/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.sniffer;

import aglobe.agent.sniffer.DetailHeaderPanel;
import aglobe.agent.sniffer.DetailMainPanel;
import aglobe.agent.sniffer.DrawingConstants;
import aglobe.agent.sniffer.LeftHeaderPanel;
import aglobe.agent.sniffer.SnifferAgent;
import aglobe.agent.sniffer.SnifferTreeModel;
import aglobe.container.transport.Address;
import aglobe.ontology.Message;
import java.awt.Color;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;

class DataContainer {
    private final SnifferAgent owner;
    private DetailHeaderPanel headerPanel = null;
    private DetailMainPanel mainPanel = null;
    private LeftHeaderPanel leftHeaderPanel = null;
    JTree containerTree = null;
    final LinkedHashMap<Address, ContainerRecord> containers = new LinkedHashMap();
    final LinkedHashMap<Address, AgentRecord> agents = new LinkedHashMap();
    private long nextMsgId = 1L;
    private LinkedList<MessageCover> allMsg;
    private boolean showAllContainers = true;
    ArrayList<FilteredMessageCover> filteredMsg;
    ArrayList<Record> filteredObjects = new ArrayList(200);
    private int lastShowPosition = 0;
    private final HashMap<String, Color> messageTypeColors = new HashMap();
    private final SnifferTreeModel treeModel;

    DataContainer(SnifferAgent _owner) {
        this.owner = _owner;
        this.allMsg = new LinkedList();
        this.filteredMsg = new ArrayList(this.owner.msgHistoryLength);
        int i = 0;
        while (i < DrawingConstants.MESSAGE_TYPES.length) {
            this.messageTypeColors.put(DrawingConstants.MESSAGE_TYPES[i], DrawingConstants.MESSAGE_TYPE_COLORS[i]);
            ++i;
        }
        this.treeModel = new SnifferTreeModel(this);
        ContainerRecord container = new ContainerRecord(this.owner.getAddress().deriveContainerAddress());
        this.containers.put(container.address, container);
        if (this.showAllContainers) {
            if (this.owner.addressFilterPattern.matcher(SnifferTreeModel.OTHERS).find()) {
                this.filteredObjects.add(container);
                container.showPosition = this.lastShowPosition++;
                container.countFromThisContainer = 1;
                container.isLast = true;
            }
            this.treeModel.containersAdded(container);
        }
    }

    synchronized void setHeaderPanel(DetailHeaderPanel _new) {
        this.headerPanel = _new;
    }

    synchronized void setMainPanel(DetailMainPanel _new) {
        this.mainPanel = _new;
    }

    synchronized void setLeftHeaderPanel(LeftHeaderPanel _new) {
        this.leftHeaderPanel = _new;
    }

    synchronized void setContainerTree(JTree _new) {
        this.containerTree = _new;
    }

    TreeModel getTreeModel() {
        return this.treeModel;
    }

    TreeCellRenderer getTreeCellRenderer() {
        return this.treeModel.getCellRenderer();
    }

    MouseListener getMouseListener(JTree owner) {
        return this.treeModel.getMouseListener(owner);
    }

    synchronized void loginContainer(Address _address) {
        ContainerRecord container = this.containers.get(_address);
        if (container == null) {
            ContainerRecord sameContainer = this.getContainerWithSameName(_address.getContainerName());
            if (sameContainer != null) {
                this.removeThisContainer(sameContainer);
            }
            container = new ContainerRecord(_address);
            this.containers.put(_address, container);
            if (this.showAllContainers) {
                if (this.owner.addressFilterPattern.matcher(SnifferTreeModel.OTHERS).find()) {
                    container.showPosition = this.lastShowPosition++;
                    container.countFromThisContainer = 1;
                    container.isLast = true;
                    this.filteredObjects.add(container);
                    this.repaintAll();
                }
                this.treeModel.containersAdded(container);
            }
        } else {
            container.setLogged(true);
            this.repaintAll();
        }
    }

    synchronized void logoutContainer(String _name) {
        ContainerRecord container = null;
        for (ContainerRecord item : this.containers.values()) {
            if (!item.getContainer().name.equals(_name)) continue;
            container = item;
            break;
        }
        if (container != null) {
            container.setLogged(false);
            this.repaintAll();
        }
    }

    synchronized void dontSniff(Record record, boolean updateHistory) {
        this.filteredObjects.remove(record);
        this.rebuildShowLists();
        this.rebuildFilteredMsg();
        this.mainPanel.hideACLMessageWindow();
        this.repaintAll();
    }

    synchronized void doSniff(Record record, boolean updateHistory) {
        ContainerRecord container = record.getContainer();
        boolean founded = false;
        boolean copyRest = false;
        ArrayList<Record> _newFilteredObjects = new ArrayList<Record>();
        for (Record item : this.filteredObjects) {
            if (copyRest) {
                _newFilteredObjects.add(item);
                continue;
            }
            ContainerRecord actualRecord = item.getContainer();
            if (actualRecord == container) {
                if (!founded) {
                    founded = true;
                }
            } else if (founded) {
                _newFilteredObjects.add(record);
                copyRest = true;
            }
            _newFilteredObjects.add(item);
        }
        if (!copyRest) {
            _newFilteredObjects.add(record);
        }
        this.filteredObjects = _newFilteredObjects;
        this.rebuildShowLists();
        if (updateHistory) {
            this.rebuildFilteredMsg();
            this.mainPanel.hideACLMessageWindow();
            this.repaintAll();
        } else {
            this.headerPanel.repaintThis();
            this.containerTree.repaint();
        }
    }

    synchronized void changeShowing(Record record, boolean updateHistory) {
        if (record.showPosition >= 0) {
            this.dontSniff(record, updateHistory);
        } else {
            this.doSniff(record, updateHistory);
        }
    }

    synchronized void moveActorLeft(Record record) {
        if (!record.isFirstFromThisContainer() && record.isSniffed()) {
            int actPosition = this.filteredObjects.indexOf(record);
            this.filteredObjects.remove(actPosition);
            this.filteredObjects.add(actPosition - 1, record);
            this.rebuildShowLists();
            this.rebuildFilteredMsg();
            this.mainPanel.hideACLMessageWindow();
            this.repaintAll();
        }
    }

    synchronized void moveActorRight(Record record) {
        if (!record.isLast && record.isSniffed()) {
            int actPosition = this.filteredObjects.indexOf(record);
            this.filteredObjects.remove(actPosition);
            this.filteredObjects.add(actPosition + 1, record);
            this.rebuildShowLists();
            this.rebuildFilteredMsg();
            this.mainPanel.hideACLMessageWindow();
            this.repaintAll();
        }
    }

    synchronized void moveContainerLeft(Record record) {
        if (record.isSniffed()) {
            int first = this.getFirstFromThisContainer(record);
            int len = this.filteredObjects.get((int)first).countFromThisContainer;
            ArrayList<Record> buf = new ArrayList<Record>();
            int i = 0;
            while (i < len) {
                buf.add(0, this.filteredObjects.remove(first));
                ++i;
            }
            int before = this.getFirstFromThisContainer(this.filteredObjects.get(first - 1));
            int i2 = 0;
            while (i2 < len) {
                this.filteredObjects.add(before, (Record)buf.get(i2));
                ++i2;
            }
            this.rebuildShowLists();
            this.rebuildFilteredMsg();
            this.mainPanel.hideACLMessageWindow();
            this.repaintAll();
        }
    }

    synchronized void moveContainerRight(Record record) {
        if (record.isSniffed()) {
            int first = this.getFirstFromThisContainer(record);
            int len = this.filteredObjects.get((int)first).countFromThisContainer;
            ArrayList<Record> buf = new ArrayList<Record>();
            int i = 0;
            while (i < len) {
                buf.add(0, this.filteredObjects.remove(first));
                ++i;
            }
            int before = this.filteredObjects.get((int)first).countFromThisContainer + first;
            int i2 = 0;
            while (i2 < len) {
                this.filteredObjects.add(before, (Record)buf.get(i2));
                ++i2;
            }
            this.rebuildShowLists();
            this.rebuildFilteredMsg();
            this.mainPanel.hideACLMessageWindow();
            this.repaintAll();
        }
    }

    synchronized void updateMsgHistoryLength() {
        while (this.allMsg.size() >= this.owner.msgHistoryLength) {
            MessageCover rmMc = this.allMsg.removeFirst();
            if (this.filteredMsg.get((int)0).msgCover != rmMc) continue;
            this.filteredMsg.remove(0);
        }
        final long msgSize = this.allMsg.size();
        if (this.owner.gui != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((DataContainer)DataContainer.this).owner.gui.historyUsed.setText(Long.toString(msgSize));
                }
            });
        }
        this.mainPanel.repaintThis();
        this.leftHeaderPanel.repaintThis();
    }

    synchronized void incomingMessageCopy(Message m, boolean undeliverable) {
        MessageCover rmMc;
        AgentRecord from = this.getAgentRecord(m.getSender());
        AgentRecord to = this.getAgentRecord(m.getReceiver());
        if (from == null || to == null || from == to) {
            return;
        }
        final long a = this.nextMsgId;
        if (this.owner.gui != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((DataContainer)DataContainer.this).owner.gui.parsedMsg.setText(Long.toString(a));
                }
            });
        }
        MessageCover mc = new MessageCover(from, to, undeliverable, m, this.nextMsgId++);
        if (this.allMsg.size() == this.owner.msgHistoryLength - 1 && this.filteredMsg.get((int)0).msgCover == (rmMc = this.allMsg.removeFirst())) {
            this.filteredMsg.remove(0);
        }
        this.allMsg.add(mc);
        final long msgSize = this.allMsg.size();
        if (this.owner.gui != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((DataContainer)DataContainer.this).owner.gui.historyUsed.setText(Long.toString(msgSize));
                }
            });
        }
        if (this.parseMessage(mc)) {
            this.mainPanel.repaintLastMessage();
            this.leftHeaderPanel.repaintLastMessage();
        }
    }

    private boolean parseMessage(MessageCover mc) {
        int from = mc.from.showPosition;
        if (from < 0 && (from = mc.from.container.showPosition) < 0) {
            return false;
        }
        int to = mc.to.showPosition;
        if (to < 0 && (to = mc.to.container.showPosition) < 0) {
            return false;
        }
        if (from == to) {
            return false;
        }
        this.filteredMsg.add(new FilteredMessageCover(from, to, mc));
        return true;
    }

    private AgentRecord getAgentRecord(Address agentAdress) {
        ContainerRecord container;
        AgentRecord retVal = this.agents.get(agentAdress);
        if (retVal == null && (container = this.containers.get(agentAdress.deriveContainerAddress())) != null) {
            retVal = new AgentRecord(container, agentAdress);
            this.agents.put(agentAdress, retVal);
            this.treeModel.agentAdded(retVal);
            if (this.owner.addressFilterPattern.matcher(agentAdress.toString()).find()) {
                this.changeShowing(retVal, true);
            }
        }
        return retVal;
    }

    private void repaintAll() {
        this.mainPanel.repaintThis();
        this.headerPanel.repaintThis();
        this.leftHeaderPanel.repaintThis();
        this.containerTree.repaint();
    }

    private ContainerRecord getContainerWithSameName(String name) {
        for (ContainerRecord item : this.containers.values()) {
            if (!item.name.equals(name)) continue;
            return item;
        }
        return null;
    }

    private void removeAllFromMsg(AgentRecord agent) {
        Iterator iter = this.allMsg.iterator();
        while (iter.hasNext()) {
            MessageCover item = (MessageCover)iter.next();
            if (item.from != agent && item.to != agent) continue;
            iter.remove();
        }
    }

    private void removeThisContainer(ContainerRecord container) {
        this.containers.values().remove(container);
        this.filteredObjects.remove(container);
        Iterator<AgentRecord> iter = this.agents.values().iterator();
        while (iter.hasNext()) {
            AgentRecord ar = iter.next();
            if (container != ar.container) continue;
            iter.remove();
            this.filteredObjects.remove(ar);
            this.removeAllFromMsg(ar);
        }
        this.rebuildShowLists();
        this.rebuildFilteredMsg();
        this.mainPanel.hideACLMessageWindow();
        this.repaintAll();
        this.treeModel.containersRemoved(container);
    }

    /*
     * WARNING - void declaration
     */
    private void rebuildShowLists() {
        this.lastShowPosition = 0;
        for (ContainerRecord containerRecord : this.containers.values()) {
            containerRecord.showPosition = -1;
            containerRecord.countFromThisContainer = -1;
            containerRecord.isLast = false;
        }
        for (AgentRecord agentRecord : this.agents.values()) {
            agentRecord.showPosition = -1;
            agentRecord.countFromThisContainer = -1;
            agentRecord.isLast = false;
        }
        Object var2_5 = null;
        Iterator<Record> iter2 = this.filteredObjects.iterator();
        Record item2 = null;
        Record lastRecord = null;
        if (iter2.hasNext()) {
            item2 = iter2.next();
        }
        for (Record item : this.filteredObjects) {
            void var2_6;
            ++this.lastShowPosition;
            item.showPosition = item.showPosition;
            ContainerRecord actContainer = item.getContainer();
            if (actContainer != var2_6) {
                int count = 0;
                while (item2.getContainer() == actContainer && ++count > 0 && iter2.hasNext()) {
                    item2 = iter2.next();
                }
                ContainerRecord containerRecord = actContainer;
                item.countFromThisContainer = count;
                if (lastRecord != null) {
                    lastRecord.isLast = true;
                }
            }
            lastRecord = item;
        }
        if (lastRecord != null) {
            lastRecord.isLast = true;
        }
    }

    private void rebuildFilteredMsg() {
        this.filteredMsg.clear();
        for (MessageCover item : this.allMsg) {
            this.parseMessage(item);
        }
    }

    private int getFirstFromThisContainer(Record record) {
        int actPosition = this.filteredObjects.indexOf(record);
        while (!this.filteredObjects.get(actPosition).isFirstFromThisContainer()) {
            --actPosition;
        }
        return actPosition;
    }

    private synchronized boolean testFirstContainer(Record record) {
        int actPosition = this.getFirstFromThisContainer(record);
        return actPosition == 0;
    }

    private synchronized boolean testLastContainer(Record record) {
        int actPosition = this.getFirstFromThisContainer(record);
        return actPosition + this.filteredObjects.get((int)actPosition).countFromThisContainer >= this.filteredObjects.size();
    }

    class Record {
        int showPosition = -1;
        int countFromThisContainer = -1;
        boolean isLast = false;

        private Record() {
        }

        boolean isSniffed() {
            return this.showPosition >= 0;
        }

        ContainerRecord getContainer() {
            if (this instanceof ContainerRecord) {
                return (ContainerRecord)this;
            }
            return ((AgentRecord)this).container;
        }

        boolean isFirstFromThisContainer() {
            return this.countFromThisContainer >= 0;
        }

        boolean isFisrtContainer() {
            if (!this.isSniffed()) {
                return false;
            }
            return DataContainer.this.testFirstContainer(this);
        }

        boolean isLastContainer() {
            if (!this.isSniffed()) {
                return false;
            }
            return DataContainer.this.testLastContainer(this);
        }
    }

    class ContainerRecord
    extends Record {
        final String name;
        final Address address;
        private boolean logged;

        ContainerRecord(Address _address) {
            this.name = _address.getContainerName();
            this.address = _address;
            this.logged = true;
        }

        boolean isLogged() {
            return this.logged;
        }

        void setLogged(boolean _status) {
            this.logged = _status;
        }
    }

    class AgentRecord
    extends Record {
        final ContainerRecord container;
        final Address address;
        final boolean isAgent;
        final String name;

        AgentRecord(ContainerRecord _container, Address _address) {
            this.container = _container;
            this.address = _address;
            this.isAgent = this.address.isAgent();
            this.name = this.address.getName();
        }
    }

    class MessageCover {
        final AgentRecord from;
        final AgentRecord to;
        final long msgId;
        final boolean undeliverable;
        final Color messageColor;
        final Message msg;

        MessageCover(AgentRecord _from, AgentRecord _to, boolean _undeliverable, Message _msg, long msgId) {
            this.from = _from;
            this.to = _to;
            this.undeliverable = _undeliverable;
            this.msg = _msg;
            this.msgId = msgId;
            Color col = (Color)DataContainer.this.messageTypeColors.get(this.msg.getPerformative());
            if (col == null) {
                col = DrawingConstants.OTHER_MESSAGE_TYPE_COLOR;
            }
            this.messageColor = col;
        }
    }

    class FilteredMessageCover {
        final int fromPosition;
        final int toPosition;
        final MessageCover msgCover;

        FilteredMessageCover(int _from, int _to, MessageCover _msgCover) {
            this.fromPosition = _from;
            this.toPosition = _to;
            this.msgCover = _msgCover;
        }
    }
}

