/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.sniffer;

import aglobe.agent.sniffer.DataContainer;
import aglobe.agent.sniffer.DetailMainPanel;
import aglobe.util.AglobeXMLtools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

class ACLMessageGUI
extends JFrame {
    private final DetailMainPanel owner;
    private DataContainer.MessageCover[] mcs;
    private int curPos;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel jPanel1 = new JPanel();
    JButton closeButton = new JButton();
    Border border1;
    TitledBorder titledBorder1;
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JTextField sender = new JTextField();
    JTextField receiver = new JTextField();
    JLabel jLabel3 = new JLabel();
    JTextField performative = new JTextField();
    JLabel jLabel4 = new JLabel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTextPane content = new JTextPane();
    JTextField protocol = new JTextField();
    JLabel jLabel5 = new JLabel();
    JLabel jLabel6 = new JLabel();
    JTextField ontology = new JTextField();
    JLabel jLabel7 = new JLabel();
    JTextField conversationID = new JTextField();
    JLabel jLabel8 = new JLabel();
    JTextField inReplyTo = new JTextField();
    JLabel jLabel9 = new JLabel();
    JTextField replyWith = new JTextField();
    JLabel jLabel10 = new JLabel();
    JTextField reason = new JTextField();
    JLabel jLabel11 = new JLabel();
    JTextField msgId = new JTextField();
    JPanel buttonPanel = new JPanel();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JButton prevButton = new JButton();
    JButton nextButton = new JButton();

    ACLMessageGUI(DetailMainPanel _owner) {
        this.owner = _owner;
        try {
            this.setTitle("ACL Message");
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.border1 = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.titledBorder1 = new TitledBorder(this.border1, "ACL Message details");
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.closeButton.setSelected(true);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ACLMessageGUI.this.closeButton_actionPerformed(e);
            }
        });
        this.jPanel1.setBorder(this.titledBorder1);
        this.jPanel1.setLayout(this.gridBagLayout2);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setIconTextGap(4);
        this.jLabel1.setText("Sender:");
        this.jLabel2.setVerifyInputWhenFocusTarget(true);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setHorizontalTextPosition(11);
        this.jLabel2.setText("Receiver:");
        this.sender.setPreferredSize(new Dimension(300, 21));
        this.sender.setEditable(false);
        this.sender.setText("");
        this.receiver.setEditable(false);
        this.receiver.setText("");
        this.jLabel3.setText("Performative:");
        this.performative.setEditable(false);
        this.performative.setText("");
        this.performative.setBackground(Color.WHITE);
        this.jLabel4.setText("Content:");
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.content.setBackground(Color.LIGHT_GRAY);
        this.content.setOpaque(false);
        this.content.setPreferredSize(new Dimension(300, 84));
        this.content.setDisabledTextColor(Color.LIGHT_GRAY);
        this.content.setEditable(false);
        this.content.setText("");
        this.protocol.setEditable(false);
        this.protocol.setText("");
        this.jLabel5.setText("Protocol:");
        this.jLabel6.setText("Ontology:");
        this.ontology.setToolTipText("");
        this.ontology.setVerifyInputWhenFocusTarget(true);
        this.ontology.setEditable(false);
        this.ontology.setText("");
        this.jLabel7.setText("ConversationID:");
        this.conversationID.setEditable(false);
        this.conversationID.setText("");
        this.jLabel8.setText("InReplyTo:");
        this.inReplyTo.setEnabled(true);
        this.inReplyTo.setEditable(false);
        this.inReplyTo.setText("");
        this.jLabel9.setText("ReplyWith:");
        this.replyWith.setEditable(false);
        this.replyWith.setSelectionStart(11);
        this.replyWith.setText("");
        this.jLabel10.setText("Reason:");
        this.reason.setEditable(false);
        this.reason.setText("");
        this.setResizable(false);
        this.jLabel11.setText("Sniffer msgId:");
        this.msgId.setDoubleBuffered(false);
        this.msgId.setEditable(false);
        this.msgId.setText("jTextField1");
        this.buttonPanel.setLayout(this.gridBagLayout3);
        this.prevButton.setText("<< Conversation");
        this.prevButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ACLMessageGUI.this.prevButton_actionPerformed(e);
            }
        });
        this.nextButton.setText("Conversation >>");
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ACLMessageGUI.this.nextButton_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.jPanel1, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.1, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.closeButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 20, 5, 20), 0, 0));
        this.buttonPanel.add((Component)this.prevButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.nextButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.buttonPanel, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabel1, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabel2, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.sender, new GridBagConstraints(2, 1, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.receiver, new GridBagConstraints(2, 2, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.jLabel3, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.performative, new GridBagConstraints(2, 3, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.jLabel4, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jScrollPane1, new GridBagConstraints(2, 4, 1, 1, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.content, null);
        this.jPanel1.add((Component)this.protocol, new GridBagConstraints(2, 5, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.jLabel5, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabel6, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.ontology, new GridBagConstraints(2, 6, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.jLabel7, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.conversationID, new GridBagConstraints(2, 7, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.jLabel8, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.inReplyTo, new GridBagConstraints(2, 8, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.jLabel9, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.replyWith, new GridBagConstraints(2, 9, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.jLabel10, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.reason, new GridBagConstraints(2, 10, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.jLabel11, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.msgId, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    private String parseText(Object object) {
        return object != null ? object.toString() : "{null}";
    }

    private String parseContent(Object object) {
        return object != null ? AglobeXMLtools.printObject(object) : "{null}";
    }

    void setACLMessage(final DataContainer.MessageCover[] mc, final int pos) {
        this.mcs = mc;
        this.curPos = pos;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ACLMessageGUI.this.msgId.setText(Long.toString(mc[pos].msgId));
                ACLMessageGUI.this.sender.setText(ACLMessageGUI.this.parseText(mc[pos].msg.getSender()));
                ACLMessageGUI.this.receiver.setText(ACLMessageGUI.this.parseText(mc[pos].msg.getReceiver()));
                ACLMessageGUI.this.performative.setText(ACLMessageGUI.this.parseText(mc[pos].msg.getPerformative()));
                ACLMessageGUI.this.performative.setForeground(mc[pos].messageColor);
                ACLMessageGUI.this.content.setText(ACLMessageGUI.this.parseText(mc[pos].msg.getContent()));
                ACLMessageGUI.this.protocol.setText(ACLMessageGUI.this.parseText(mc[pos].msg.getProtocol()));
                ACLMessageGUI.this.ontology.setText(ACLMessageGUI.this.parseText(mc[pos].msg.getOntology()));
                ACLMessageGUI.this.conversationID.setText(ACLMessageGUI.this.parseText(mc[pos].msg.getConversationID()));
                ACLMessageGUI.this.inReplyTo.setText(ACLMessageGUI.this.parseText(mc[pos].msg.getInReplyTo()));
                ACLMessageGUI.this.replyWith.setText(ACLMessageGUI.this.parseText(mc[pos].msg.getReplyWith()));
                ACLMessageGUI.this.reason.setText(ACLMessageGUI.this.parseText(mc[pos].msg.getReason()));
                if (pos > 0) {
                    ACLMessageGUI.this.prevButton.setEnabled(true);
                } else {
                    ACLMessageGUI.this.prevButton.setEnabled(false);
                }
                if (pos < mc.length - 1) {
                    ACLMessageGUI.this.nextButton.setEnabled(true);
                } else {
                    ACLMessageGUI.this.nextButton.setEnabled(false);
                }
            }
        });
    }

    void showGUI(final boolean state) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ACLMessageGUI.this.setVisible(state);
            }
        });
    }

    void closeButton_actionPerformed(ActionEvent e) {
        this.showGUI(false);
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            this.owner.clearSelection();
        }
    }

    private void updateSelectedMessage() {
        this.owner.setSelectedMsg(this.mcs[this.curPos].msgId);
    }

    void prevButton_actionPerformed(ActionEvent e) {
        if (this.curPos > 0) {
            --this.curPos;
            this.setACLMessage(this.mcs, this.curPos);
            this.updateSelectedMessage();
        }
    }

    void nextButton_actionPerformed(ActionEvent e) {
        if (this.curPos < this.mcs.length - 1) {
            ++this.curPos;
            this.setACLMessage(this.mcs, this.curPos);
            this.updateSelectedMessage();
        }
    }
}

