/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.matrixes;

import aglobe.agent.matrixes.MatrixESAgent;
import aglobe.container.transport.Address;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;

class MatrixTableModel
extends AbstractTableModel {
    List<LinkedList<Object>> rows = new ArrayList<LinkedList<Object>>();
    List<Address> containers = new ArrayList<Address>();
    private static Boolean DefaultVisibility = Boolean.TRUE;
    LinkedList listeners = new LinkedList();
    MatrixESAgent owner = null;
    RowHeaderListModel rowHeaderModel = new RowHeaderListModel();

    MatrixTableModel(MatrixESAgent owner) {
        this.owner = owner;
    }

    public synchronized int getRowCount() {
        return this.rows.size();
    }

    public synchronized int getColumnCount() {
        return this.containers.size();
    }

    public synchronized String getColumnName(int columnIndex) {
        return this.containers.get(columnIndex).getContainerName();
    }

    public Class getColumnClass(int columnIndex) {
        return Boolean.class;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return rowIndex != columnIndex;
    }

    public synchronized Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex == columnIndex) {
            return Boolean.TRUE;
        }
        return this.rows.get(rowIndex).get(columnIndex);
    }

    public synchronized void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        ++this.owner.visibilityID;
        this.rows.get(rowIndex).set(columnIndex, aValue);
        this.rows.get(columnIndex).set(rowIndex, aValue);
        this.fireTableCellUpdated(columnIndex, rowIndex);
        this.sendChange(rowIndex);
        this.sendChange(columnIndex);
    }

    public synchronized void addContainer(Address p) {
        this.containers.add(p);
        LinkedList<Boolean> row = new LinkedList<Boolean>();
        int i = 0;
        while (i < this.containers.size()) {
            row.add(DefaultVisibility);
            ++i;
        }
        Iterator<LinkedList<Object>> i2 = this.rows.iterator();
        while (i2.hasNext()) {
            i2.next().addLast(DefaultVisibility);
        }
        this.rows.add(row);
        this.fireTableStructureChanged();
        this.rowHeaderModel.fireChange();
        this.sendChangeAll();
    }

    synchronized void removeContainer(Address p) {
        int pos = this.containers.indexOf(p);
        if (pos != -1) {
            this.containers.remove(pos);
            this.rows.remove(pos);
            Iterator<LinkedList<Object>> i = this.rows.iterator();
            while (i.hasNext()) {
                i.next().remove(pos);
            }
        } else {
            throw new RuntimeException("Removing non-existing container from the Matrix.");
        }
        this.fireTableStructureChanged();
        this.rowHeaderModel.fireChange();
        this.sendChangeAll();
    }

    private void sendChange(int container) {
        if (this.owner != null) {
            try {
                LinkedList<Address> pList = new LinkedList<Address>();
                Iterator pi = this.rows.get(container).iterator();
                Iterator<Address> i = this.containers.iterator();
                while (i.hasNext()) {
                    if (((Boolean)pi.next()).booleanValue()) {
                        pList.add(i.next());
                        continue;
                    }
                    i.next();
                }
                this.owner.sendChange(this.containers.get(container), pList);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("MatrixTableModel error (sendChangeMethod)");
            }
        }
    }

    private void sendChangeAll() {
        ++this.owner.visibilityID;
        int i = 0;
        while (i < this.containers.size()) {
            this.sendChange(i);
            ++i;
        }
    }

    public synchronized Component getRowHeader(JTable table) {
        JList rowHeader = new JList(this.rowHeaderModel);
        rowHeader.setFixedCellWidth(70);
        rowHeader.setFixedCellHeight(table.getRowHeight());
        rowHeader.setCellRenderer(new RowHeaderRenderer(table));
        rowHeader.setOpaque(false);
        return rowHeader;
    }

    private class RowHeaderListModel
    extends AbstractListModel {
        private RowHeaderListModel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getSize() {
            MatrixTableModel matrixTableModel = MatrixTableModel.this;
            synchronized (matrixTableModel) {
                return MatrixTableModel.this.containers.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getElementAt(int index) {
            MatrixTableModel matrixTableModel = MatrixTableModel.this;
            synchronized (matrixTableModel) {
                return MatrixTableModel.this.containers.get(index).getContainerName();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireChange() {
            MatrixTableModel matrixTableModel = MatrixTableModel.this;
            synchronized (matrixTableModel) {
                this.fireContentsChanged(this, 0, MatrixTableModel.this.containers.size());
            }
        }
    }

    public class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer {
        RowHeaderRenderer(JTable table) {
            JTableHeader header = table.getTableHeader();
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

