/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.matrixes;

import aglobe.agent.matrixes.MatrixESAgent;
import aglobe.agent.matrixes.MatrixTableModel;
import aglobe.container.AgentContainer;
import aglobe.container.transport.Address;
import aglobe.ontology.Command;
import aglobe.util.gui.RememberPositionJFrame;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

class MatrixESAgentGUI
extends RememberPositionJFrame {
    private String MATRIX = "matrix";
    private String EMPTY = "empty";
    private MatrixESAgent owner = null;
    private MatrixTableModel matrixTableModel = null;
    private CardLayout cardLayout1 = new CardLayout();
    private JPanel matrixPanel = new JPanel();
    private JPanel emptyPanel = new JPanel();
    private JTable matrixTable = new JTable();
    private JScrollPane jScrollPane1 = new JScrollPane(this.matrixTable);
    private JLabel jLabel1 = new JLabel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JMenuBar menuBar = new JMenuBar();
    private JMenu containersMenu = new JMenu("Agent Containers");
    private JMenuItem showAllMenuItem = new JMenuItem("Show All GUIs");
    private JMenuItem hideAllMenuItem = new JMenuItem("Hide All GUIs");
    private JMenuItem killAllMenuItem = new JMenuItem("Kill All");
    private JMenuItem showThisMenuItem = new JMenuItem("Show This GUI");
    private JMenuItem exitContainerMenuItem = new JMenuItem("Shutdown This Agent Container");
    private JMenuItem killTotalMenuItem = new JMenuItem("Kill All + Shutdown This");

    MatrixESAgentGUI(MatrixESAgent owner) {
        super(owner);
        try {
            this.owner = owner;
            this.matrixTableModel = new MatrixTableModel(owner);
            this.jbInit();
            this.jScrollPane1.setRowHeaderView(this.matrixTableModel.getRowHeader(this.matrixTable));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                MatrixESAgentGUI.this.this_windowClosed(e);
            }

            public void windowClosing(WindowEvent e) {
                MatrixESAgentGUI.this.this_windowClosing(e);
            }
        });
        this.menuBar.add(this.containersMenu);
        this.containersMenu.add(this.showAllMenuItem);
        this.containersMenu.add(this.hideAllMenuItem);
        this.containersMenu.addSeparator();
        this.containersMenu.add(this.showThisMenuItem);
        this.containersMenu.addSeparator();
        this.containersMenu.add(this.exitContainerMenuItem);
        this.containersMenu.add(this.killAllMenuItem);
        this.containersMenu.add(this.killTotalMenuItem);
        this.showAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MatrixESAgentGUI.this.owner != null) {
                    MatrixESAgentGUI.this.owner.showAll();
                }
            }
        });
        this.hideAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MatrixESAgentGUI.this.owner != null) {
                    MatrixESAgentGUI.this.owner.hideAll();
                }
            }
        });
        this.showThisMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MatrixESAgentGUI.this.owner != null) {
                    MatrixESAgentGUI.this.owner.showThis();
                }
            }
        });
        this.exitContainerMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MatrixESAgentGUI.this.exitContainerMenuItem_actionPerformed(e);
            }
        });
        this.killAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MatrixESAgentGUI.this.owner != null) {
                    MatrixESAgentGUI.this.owner.killAll();
                }
            }
        });
        this.killTotalMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MatrixESAgentGUI.this.killTotalMenuItem_actionPerformed(e);
            }
        });
        this.getContentPane().setLayout(this.cardLayout1);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setHorizontalTextPosition(0);
        this.jLabel1.setText("No containers registered.");
        this.emptyPanel.setLayout(this.borderLayout1);
        this.matrixTable.setModel(this.matrixTableModel);
        this.jScrollPane1.setMinimumSize(new Dimension(100, 100));
        this.matrixPanel.setLayout(this.borderLayout2);
        this.getContentPane().add((Component)this.matrixPanel, this.MATRIX);
        this.matrixPanel.add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.emptyPanel, this.EMPTY);
        this.emptyPanel.add((Component)this.jLabel1, "Center");
        this.cardLayout1.show(this.getContentPane(), this.EMPTY);
        this.setJMenuBar(this.menuBar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addContainer(Address p) {
        this.matrixTableModel.addContainer(p);
        MatrixTableModel matrixTableModel = this.matrixTableModel;
        synchronized (matrixTableModel) {
            if (this.matrixTableModel.containers.size() > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MatrixESAgentGUI.this.cardLayout1.show(MatrixESAgentGUI.this.getContentPane(), MatrixESAgentGUI.this.MATRIX);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeContainer(Address p) {
        this.matrixTableModel.removeContainer(p);
        MatrixTableModel matrixTableModel = this.matrixTableModel;
        synchronized (matrixTableModel) {
            if (this.matrixTableModel.containers.size() == 0) {
                this.cardLayout1.show(this.getContentPane(), this.EMPTY);
            }
        }
    }

    void exitContainerMenuItem_actionPerformed(ActionEvent e) {
        int res = JOptionPane.showConfirmDialog(this, "Are you sure to shut down the Agent Container?", "Shutdown agent container", 0);
        if (res != 0) {
            return;
        }
        AgentContainer.CommandService.Shell s = (AgentContainer.CommandService.Shell)this.owner.getContainer().getServiceManager().getService(this.owner, "container/command");
        Command c = new Command();
        c.setName("quit");
        s.execute(c);
    }

    void killTotalMenuItem_actionPerformed(ActionEvent e) {
        int res = JOptionPane.showConfirmDialog(this, "Kill all containers including Server container?", "Shutdown agent container?", 0);
        if (res != 0) {
            return;
        }
        if (this.owner != null) {
            this.owner.killAll();
            this.owner.killSelf();
        }
    }

    void this_windowClosed(WindowEvent e) {
        this.owner.killAllandExit();
    }

    void this_windowClosing(WindowEvent e) {
        this.owner.killAllandExit();
    }
}

