/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.matrixes;

import aglobe.agent.matrixes.MatrixESAgentGUI;
import aglobe.container.AgentContainer;
import aglobe.container.agent.Agent;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.AglobeParam;
import aglobe.ontology.Command;
import aglobe.ontology.Message;
import aglobe.ontology.VisibilityUpdate;
import aglobe.service.gis.server.GISServerService;
import aglobe.service.gis.server.GISTopicServerListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixESAgent
extends Agent
implements GISTopicServerListener {
    public MatrixESAgentGUI gui = null;
    long visibilityID = 1L;
    private GISServerService.Shell gisServer = null;
    Map<String, Address> logged_containers = new LinkedHashMap<String, Address>();

    @Override
    public void init(AgentInfo a, int initState) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    try {
                        MatrixESAgent.this.gui = new MatrixESAgentGUI(MatrixESAgent.this);
                        MatrixESAgent.this.gui.setTitle(MatrixESAgent.this.getAddress().toString());
                        MatrixESAgent.this.gui.pack();
                        MatrixESAgent.this.gui.setVisible(true);
                    }
                    catch (Exception ex) {
                        MatrixESAgent.this.logWarning("Cannot create GUI due to: " + ex);
                    }
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.gisServer == null) {
            this.gisServer = (GISServerService.Shell)this.getContainer().getServiceManager().getService(this, "gis/master");
        }
        if (this.gisServer == null) {
            this.logWarning("GISServerService not running");
            this.stop();
            return;
        }
        this.gisServer.subscribeTopic("VISIBILITY_UPDATES", this);
    }

    @Override
    protected void finish() {
        if (this.gui != null) {
            this.gui.setVisible(false);
        }
    }

    @Override
    protected void handleIncomingMessage(Message m) {
        this.logWarning("Unexpected message: " + m.toString());
    }

    protected void sendChange(Address receiver, List<Address> seen) {
        if (this.gisServer != null) {
            VisibilityUpdate nfo = new VisibilityUpdate();
            nfo.setVisibilityID(this.visibilityID);
            nfo.getVisibleContainerAddress().addAll(seen);
            this.gisServer.sendTopic(receiver.getContainerName(), "VISIBILITY_UPDATES", nfo);
        }
    }

    protected void showAll() {
        this.sendAllCommand(this.getVisibilityCommand(true));
    }

    protected void hideAll() {
        this.sendAllCommand(this.getVisibilityCommand(false));
    }

    protected void showThis() {
        this.addEvent(new Runnable(){

            public void run() {
                AgentContainer.CommandService.Shell s = (AgentContainer.CommandService.Shell)MatrixESAgent.this.getContainer().getServiceManager().getService(MatrixESAgent.this, "container/command");
                s.execute(MatrixESAgent.this.getVisibilityCommand(true));
            }
        });
    }

    protected void killAll() {
        Command c = new Command();
        c.setName("QUIT");
        this.sendAllCommand(c);
    }

    protected void killSelf() {
        this.addEvent(new Runnable(){

            public void run() {
                AgentContainer.CommandService.Shell s = (AgentContainer.CommandService.Shell)MatrixESAgent.this.getContainer().getServiceManager().getService(MatrixESAgent.this, "container/command");
                Command c = new Command();
                c.setName("QUIT");
                s.execute(c);
            }
        });
    }

    protected void killAllandExit() {
        this.killAll();
        this.killSelf();
    }

    private Command getVisibilityCommand(boolean visible) {
        Command c = new Command();
        c.setName("GUI");
        AglobeParam p = new AglobeParam();
        p.setName("Visible");
        p.setValue(Boolean.toString(visible));
        c.getAglobeParam().add(p);
        return c;
    }

    private void sendAllCommand(Command c) {
        if (this.gisServer != null) {
            for (String item : this.logged_containers.keySet()) {
                this.gisServer.sendTopic(item, "COMMAND", c);
            }
        }
    }

    private void loginContainer(Address vp) {
        this.logged_containers.put(vp.getContainerName(), vp);
        if (this.gui != null) {
            this.gui.addContainer(vp);
        }
    }

    private void logoutContainer(String containeName) {
        Address vp = this.logged_containers.get(containeName);
        this.logged_containers.remove(containeName);
        if (this.gui != null) {
            this.gui.removeContainer(vp);
        }
    }

    @Override
    public void handleLoginTopic(String topic, String remoteContainerName, Address remoteContainerAddress) {
        if (topic.equals("VISIBILITY_UPDATES")) {
            if (remoteContainerName == null) {
                return;
            }
            Address vp = remoteContainerAddress;
            this.loginContainer(vp);
            return;
        }
        this.logWarning("Unexpected topic login: " + topic);
    }

    @Override
    public void handleLogoutTopic(String topic, String remoteContainerName) {
        if (topic.equals("VISIBILITY_UPDATES")) {
            if (remoteContainerName == null) {
                return;
            }
            this.logoutContainer(remoteContainerName);
            return;
        }
        this.logWarning("Unexpected topic logout: " + topic);
    }

    @Override
    public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
    }
}

