/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.logger;

import aglobe.agent.logger.LoggerAgent;
import aglobe.container.Store;
import aglobe.util.gui.RememberPositionJFrame;
import aglobe.util.gui.SearchableTextArea;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;

class LoggerAgentGUI
extends RememberPositionJFrame {
    private final LoggerAgent owner;
    private final String[] levels = new String[]{"FINEST", "FINER", "FINE", "CONFIG", "INFO", "WARNING", "SEVERE"};
    private final int[] levelTranslation = new int[]{300, 400, 500, 700, 800, 900, 1000};
    private int currentSelectedLevel = 0;
    private static final String LEVEL = "gui/level";
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    SearchableTextArea jEditorPane1 = new SearchableTextArea(false, true);
    JLabel jLabel1 = new JLabel();
    JComboBox jComboBox1 = new JComboBox<String>(this.levels);

    LoggerAgentGUI(LoggerAgent owner) {
        super(owner);
        this.owner = owner;
        try {
            this.jbInit();
            this.setSize(300, 300);
            this.jComboBox1.setSelectedIndex(4);
            this.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void saveWindowSettings() {
        this.store.putInt(LEVEL, this.jComboBox1.getSelectedIndex());
    }

    protected void loadWindowSettings() {
        int level = this.jComboBox1.getSelectedIndex();
        level = this.store.getInt(LEVEL, level);
        this.jComboBox1.setSelectedIndex(level);
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                LoggerAgentGUI.this.this_windowClosing(e);
            }

            public void windowClosed(WindowEvent e) {
                LoggerAgentGUI.this.this_windowClosing(e);
            }
        });
        this.jLabel1.setText("Show only specified level and higher:");
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoggerAgentGUI.this.currentSelectedLevel = LoggerAgentGUI.this.levelTranslation[LoggerAgentGUI.this.jComboBox1.getSelectedIndex()];
                Store store = LoggerAgentGUI.this.owner.getContainer().getAgentStore(LoggerAgentGUI.this.owner.getName());
                store.putInt(LoggerAgentGUI.LEVEL, LoggerAgentGUI.this.jComboBox1.getSelectedIndex());
            }
        });
        this.getContentPane().add((Component)this.jEditorPane1, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.getContentPane().add((Component)this.jComboBox1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.setTitle("A-globe Agent&Service Distributed Logger");
    }

    private void this_windowClosing(WindowEvent e) {
        this.owner.closeGUI();
    }

    void addLogMessage(String message, int logLevel) {
        if (logLevel >= this.currentSelectedLevel) {
            this.jEditorPane1.append(String.valueOf(message) + "\n\n");
        }
    }
}

