/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.logger;

import aglobe.agent.logger.LoggerAgentGUI;
import aglobe.container.agent.Agent;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;
import aglobe.service.gis.server.GISServerService;
import aglobe.service.gis.server.GISTopicServerListener;
import javax.swing.SwingUtilities;

public class LoggerAgent
extends Agent
implements GISTopicServerListener {
    public static final String TOPIC_LOGGER_MESSAGE = "LOGGER_MESSAGE";
    private GISServerService.Shell gisShell;
    private LoggerAgentGUI gui;

    protected void handleIncomingMessage(Message m) {
        this.logSevere("Unexpected incoming message: " + m);
        m.release();
    }

    public void init(AgentInfo ai, int initState) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    try {
                        LoggerAgent.this.gui = new LoggerAgentGUI(LoggerAgent.this);
                    }
                    catch (Exception ex) {
                        LoggerAgent.this.logWarning("Cannot create GUI due to: " + ex);
                    }
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.gisShell = (GISServerService.Shell)this.getContainer().getServiceManager().getService(this, "gis/master");
        if (this.gisShell == null) {
            this.logWarning("Can run only on the server container.");
            this.stop();
        }
        this.gisShell.subscribeTopic(TOPIC_LOGGER_MESSAGE, this);
    }

    public void handleLoginTopic(String topic, String remoteContainerName, Address remoteContainerAddress) {
    }

    public void handleLogoutTopic(String topic, String remoteContainerName) {
    }

    public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
        if (topic.equals(TOPIC_LOGGER_MESSAGE)) {
            if (this.gui != null) {
                try {
                    this.gui.addLogMessage((String)content, Integer.parseInt(reason));
                }
                catch (NumberFormatException ex) {
                    this.gui.addLogMessage((String)content, Integer.MAX_VALUE);
                }
            }
            return;
        }
        this.logWarning("Unexpected incoming topic: " + topic);
    }

    protected void finish() {
        if (this.gui != null) {
            this.gui.setVisible(false);
        }
    }

    void closeGUI() {
        this.kill();
    }
}

