/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.dataanalyzer;

import aglobe.container.agent.Agent;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.AglobeParam;
import aglobe.ontology.AglobeParams;
import aglobe.ontology.Message;
import aglobe.platform.thread.AglobeThreadPool;
import aglobe.service.gis.client.GISClientService;
import java.util.Random;

public class RandomDataAgent
extends Agent {
    private RandomTimer clockThread = null;
    private String valueName = "value";
    private double value = 0.0;
    private GISClientService.Shell gisShell;
    public static final String TYPE = "Test Agent";

    public void init(AgentInfo ai, int initState) {
        if (ai.getAglobeParam().size() == 1) {
            this.valueName = ai.getAglobeParam().get(0).getValue();
        }
        if (this.clockThread == null) {
            this.clockThread = new RandomTimer(500, 1500);
            AglobeThreadPool.getThread(this.clockThread, "Random timer thread").start();
        }
        if (this.gisShell == null) {
            this.gisShell = (GISClientService.Shell)this.getContainer().getServiceManager().getService(this, "gis/client");
        }
        if (this.gisShell == null) {
            this.logWarning("RandomDataAgent runs only on a client container!");
            this.clockThread.halt();
            this.kill();
        }
    }

    public void processClockEvent(long time) {
        AglobeParams ps = new AglobeParams();
        AglobeParam p1 = new AglobeParam();
        AglobeParam p2 = new AglobeParam();
        AglobeParam p3 = new AglobeParam();
        p1.setName("timestamp");
        p1.setValue(String.valueOf(time));
        p2.setName(this.valueName);
        p2.setValue(String.valueOf(this.value + (0.5 * new Random().nextGaussian() - 1.0)));
        p3.setName("name");
        p3.setValue(this.getName());
        ps.getAglobeParam().add(p1);
        ps.getAglobeParam().add(p2);
        ps.getAglobeParam().add(p3);
        this.gisShell.submitTopicToServer("TEST_DATA", ps);
    }

    protected void handleIncomingMessage(Message m) {
        this.logWarning("Unexpected message: " + m.toString());
        m.release();
    }

    public void exit() {
        this.clockThread.halt();
        this.kill();
    }

    public void handleTopic(String topic, Object content, String reason) {
        this.logWarning("Unexpected incoming topic: " + topic);
    }

    protected void finish() {
        this.clockThread.halt();
    }

    private class RandomTimer
    implements Runnable {
        private long frame = 0L;
        private volatile RandomTimer dummy;
        private int minTime;
        private int maxTime;
        private Random randomGenerator = new Random();

        public RandomTimer(int min, int max) {
            this.dummy = this;
            this.minTime = min;
            this.maxTime = max;
        }

        public void run() {
            int wait = 0;
            this.dummy = this;
            while (this.dummy == this) {
                try {
                    wait = this.minTime + (int)((double)(this.maxTime - this.minTime) * this.randomGenerator.nextDouble());
                    Thread.sleep(wait);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.frame += (long)wait;
                RandomDataAgent.this.processClockEvent(this.frame);
            }
        }

        public void halt() {
            this.dummy = null;
        }
    }
}

