/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.dataanalyzer;

import aglobe.agent.dataanalyzer.CollectedData;
import aglobe.agent.dataanalyzer.DataAnalyzerAgent;
import aglobe.agent.dataanalyzer.DummyEditor;
import aglobe.agent.dataanalyzer.DummyRenderer;
import aglobe.agent.dataanalyzer.Graph;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class MatrixGraphSelector
extends JPanel {
    private MyTableModel mtm = null;
    private int cols = -1;
    private int rows = -1;

    public MatrixGraphSelector(DataAnalyzerAgent da) {
        super(new GridLayout(1, 0));
        this.mtm = new MyTableModel(da);
        JTable table = new JTable(this.mtm);
        table.setPreferredScrollableViewportSize(new Dimension(600, 10));
        JScrollPane scrollPane = new JScrollPane(table);
        table.setDefaultRenderer(Graph.class, new DummyRenderer(true));
        table.setDefaultEditor(Graph.class, new DummyEditor());
        this.add(scrollPane);
    }

    public synchronized void updateContent() {
        this.mtm.fireTableDataChanged();
        if (this.cols != this.mtm.getColumnCount()) {
            this.mtm.fireTableStructureChanged();
        }
        this.rows = this.mtm.getRowCount();
        this.cols = this.mtm.getColumnCount();
    }

    class MyTableModel
    extends AbstractTableModel {
        private DataAnalyzerAgent da;
        private CollectedData cd;

        public MyTableModel(DataAnalyzerAgent da) {
            this.da = da;
            this.cd = da.getData();
        }

        public int getColumnCount() {
            return this.cd.numParams() + 1;
        }

        public synchronized int getRowCount() {
            return this.cd.numAgents();
        }

        public synchronized String getColumnName(int col) {
            if (col == 0) {
                return "Agent name";
            }
            return this.cd.paramName(col - 1);
        }

        public synchronized Object getValueAt(int row, int col) {
            boolean r = false;
            boolean c = false;
            if (col == 0) {
                return this.cd.agentName(row);
            }
            return this.cd.get(row, col - 1);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return col > 0;
        }

        public synchronized void setValueAt(Object value, int row, int col) {
            Graph gr = this.cd.get(row, col - 1);
            this.da.updateUI();
            this.fireTableCellUpdated(row, col);
        }
    }
}

