/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.dataanalyzer;

import aglobe.agent.dataanalyzer.DataAnalyzerAgent;
import aglobe.agent.dataanalyzer.GraphSelector;
import aglobe.agent.dataanalyzer.GraphSelectorGUI_this_windowAdapter;
import aglobe.agent.dataanalyzer.MatrixGraphSelector;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class GraphSelectorGUI
extends JFrame {
    private DataAnalyzerAgent da = null;
    private GraphSelector gs = null;
    private MatrixGraphSelector gs2 = null;
    private JTabbedPane tabbedPane = new JTabbedPane();

    public GraphSelectorGUI(DataAnalyzerAgent da) {
        this.da = da;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void createAndShowGUI() {
        this.gs = new GraphSelector(this.da);
        this.gs2 = new MatrixGraphSelector(this.da);
        this.tabbedPane.addTab("Matrix view", null, this.gs2, "");
        this.tabbedPane.addTab("List view", null, this.gs, "");
        this.setTitle("Graph Selector");
        this.setSize(800, 400);
        this.validate();
        this.setVisible(true);
    }

    public void showGUI() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GraphSelectorGUI.this.createAndShowGUI();
            }
        });
    }

    public void updateContent() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (GraphSelectorGUI.this.gs != null) {
                    GraphSelectorGUI.this.gs.updateContent();
                }
                if (GraphSelectorGUI.this.gs2 != null) {
                    GraphSelectorGUI.this.gs2.updateContent();
                }
                GraphSelectorGUI.this.tabbedPane.updateUI();
            }
        });
    }

    private void jbInit() throws Exception {
        this.addWindowListener(new GraphSelectorGUI_this_windowAdapter(this));
        this.getContentPane().add(this.tabbedPane);
    }

    public void this_windowClosing(WindowEvent e) {
    }

    public void enableChoice(boolean enabled) {
        this.tabbedPane.setEnabled(enabled);
    }
}

