/*
 * Decompiled with CFR 0.152.
 */
package aglobe.agent.dataanalyzer;

import aglobe.agent.dataanalyzer.CollectedData;
import aglobe.agent.dataanalyzer.ColorEditor;
import aglobe.agent.dataanalyzer.ColorRenderer;
import aglobe.agent.dataanalyzer.DataAnalyzerAgent;
import aglobe.agent.dataanalyzer.Graph;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class GraphSelector
extends JPanel {
    private MyTableModel mtm = null;

    public GraphSelector(DataAnalyzerAgent da) {
        super(new GridLayout(1, 0));
        this.mtm = new MyTableModel(da);
        JTable table = new JTable(this.mtm);
        table.setPreferredScrollableViewportSize(new Dimension(600, 10));
        JScrollPane scrollPane = new JScrollPane(table);
        table.setDefaultRenderer(Color.class, new ColorRenderer(true));
        table.setDefaultEditor(Color.class, new ColorEditor());
        this.add(scrollPane);
    }

    public synchronized void updateContent() {
        this.mtm.fireTableDataChanged();
    }

    class MyTableModel
    extends AbstractTableModel {
        private DataAnalyzerAgent da;
        private CollectedData cd;
        private String[] columnNames = new String[]{"Name", "Value count", "Start time", "Last time", "Min value", "Max value", "Last value", "Color", "Visible"};

        public MyTableModel(DataAnalyzerAgent da) {
            this.da = da;
            this.cd = da.getData();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public synchronized int getRowCount() {
            return this.cd.numAgents() * this.cd.numParams() + 1;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public synchronized Object getValueAt(int row, int col) {
            Graph gr;
            int r = 0;
            int c = 0;
            if (row == 0) {
                gr = this.cd.agentCount();
            } else {
                r = (row - 1) / this.cd.numParams();
                c = (row - 1) % this.cd.numParams();
                gr = this.cd.get(r, c);
            }
            switch (col) {
                case 0: {
                    if (row == 0) {
                        return "number of agents";
                    }
                    return String.valueOf(this.cd.agentName(r)) + " (" + this.cd.paramName(c) + ")";
                }
                case 1: {
                    return gr.getFunction().size();
                }
                case 2: {
                    if (!gr.getFunction().isEmpty()) {
                        return String.valueOf(gr.getFunction().getSample((int)0).x);
                    }
                    return "n/a";
                }
                case 3: {
                    if (!gr.getFunction().isEmpty()) {
                        return String.valueOf(gr.getFunction().getSample((int)(gr.getFunction().size() - 1)).x);
                    }
                    return "n/a";
                }
                case 4: {
                    if (!gr.getFunction().isEmpty()) {
                        return String.valueOf(gr.getFunction().minValue());
                    }
                    return "n/a";
                }
                case 5: {
                    if (!gr.getFunction().isEmpty()) {
                        return String.valueOf(gr.getFunction().maxValue());
                    }
                    return "n/a";
                }
                case 6: {
                    if (!gr.getFunction().isEmpty()) {
                        return String.valueOf(gr.getFunction().lastValue());
                    }
                    return "n/a";
                }
                case 7: {
                    return gr.getColor();
                }
            }
            return gr.isVisible();
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return col >= 7;
        }

        public synchronized void setValueAt(Object value, int row, int col) {
            Graph gr;
            if (row == 0) {
                gr = this.cd.agentCount();
            } else {
                int r = (row - 1) / this.cd.numParams();
                int c = (row - 1) % this.cd.numParams();
                gr = this.cd.get(r, c);
            }
            if (col == 7) {
                gr.setColor((Color)value);
                this.da.updateUI();
            }
            if (col == 8) {
                gr.setVisible((Boolean)value);
                this.da.updateUI();
            }
            this.fireTableCellUpdated(row, col);
        }
    }
}

